/*
 * Decompiled with CFR 0.152.
 */
package com.acsbendi.requestinspectorwebview;

import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.acsbendi.requestinspectorwebview.WebViewRequestType;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0000\u0018\u0000 &2\u00020\u0001:\u0002&'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00142\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J0\u0010\u001d\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000eH\u0007J:\u0010\"\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000e2\b\u0010$\u001a\u0004\u0018\u00010\u000eH\u0007J0\u0010%\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\u000eH\u0007R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface;", "", "webView", "Landroid/webkit/WebView;", "(Landroid/webkit/WebView;)V", "recordedRequests", "Ljava/util/ArrayList;", "Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$RecordedRequest;", "Lkotlin/collections/ArrayList;", "addRecordedRequest", "", "recordedRequest", "findRecordedRequestForUrl", "url", "", "getFormParametersAsMap", "", "formParameterJsonArray", "Lorg/json/JSONArray;", "getHeadersAsMap", "", "headersString", "getMultiPartFormBody", "getPlainTextFormBody", "getUrlEncodedFormBody", "isExcludedFormParameter", "", "type", "checked", "recordFetch", "method", "body", "headers", "trace", "recordFormSubmission", "formParameterList", "enctype", "recordXhr", "Companion", "RecordedRequest", "app_release"})
public final class RequestInspectorJavaScriptInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<RecordedRequest> recordedRequests;
    @NotNull
    private static final String LOG_TAG = "RequestInspectorJs";
    @NotNull
    private static final String MULTIPART_FORM_BOUNDARY = "----WebKitFormBoundaryU7CgQs9WnqlZYKs6";
    @NotNull
    private static final String INTERFACE_NAME = "RequestInspection";
    @Language(value="JS")
    @NotNull
    private static final String JAVASCRIPT_INTERCEPTION_CODE = "\nfunction getFullUrl(url) {\n    if (url.startsWith(\"/\")) {\n        return location.protocol + '//' + location.host + url;\n    } else {\n        return url;\n    }\n}\n\nfunction recordFormSubmission(form) {\n    var jsonArr = [];\n    for (i = 0; i < form.elements.length; i++) {\n        var parName = form.elements[i].name;\n        var parValue = form.elements[i].value;\n        var parType = form.elements[i].type;\n        var parChecked = form.elements[i].checked;\n        var parId = form.elements[i].id;\n\n        jsonArr.push({\n            name: parName,\n            value: parValue,\n            type: parType,\n            checked:parChecked,\n            id:parId\n        });\n    }\n\n    const path = form.attributes['action'] === undefined ? \"/\" : form.attributes['action'].nodeValue;\n    const method = form.attributes['method'] === undefined ? \"GET\" : form.attributes['method'].nodeValue;\n    const url = getFullUrl(path);\n    const encType = form.attributes['enctype'] === undefined ? \"application/x-www-form-urlencoded\" : form.attributes['enctype'].nodeValue;\n    const err = new Error();\n    RequestInspection.recordFormSubmission(\n        url,\n        method,\n        JSON.stringify(jsonArr),\n        \"{}\",\n        err.stack,\n        encType\n    );\n}\n\nfunction handleFormSubmission(e) {\n    const form = e ? e.target : this;\n    recordFormSubmission(form);\n    form._submit();\n}\n\nHTMLFormElement.prototype._submit = HTMLFormElement.prototype.submit;\nHTMLFormElement.prototype.submit = handleFormSubmission;\nwindow.addEventListener('submit', function (submitEvent) {\n    const form = submitEvent ? submitEvent.target : this;\n    recordFormSubmission(form);\n}, true);\n\nlet lastXmlhttpRequestPrototypeMethod = null;\nlet xmlhttpRequestHeaders = {};\nlet xmlhttpRequestUrl = null;\nXMLHttpRequest.prototype._open = XMLHttpRequest.prototype.open;\nXMLHttpRequest.prototype.open = function (method, url, async, user, password) {\n    lastXmlhttpRequestPrototypeMethod = method;\n    xmlhttpRequestUrl = url;\n    const asyncWithDefault = async === undefined ? true : async;\n    this._open(method, url, asyncWithDefault, user, password);\n};\nXMLHttpRequest.prototype._setRequestHeader = XMLHttpRequest.prototype.setRequestHeader;\nXMLHttpRequest.prototype.setRequestHeader = function (header, value) {\n    xmlhttpRequestHeaders[header] = value;\n    this._setRequestHeader(header, value);\n};\nXMLHttpRequest.prototype._send = XMLHttpRequest.prototype.send;\nXMLHttpRequest.prototype.send = function (body) {\n    const err = new Error();\n    const url = getFullUrl(xmlhttpRequestUrl);\n    RequestInspection.recordXhr(\n        url,\n        lastXmlhttpRequestPrototypeMethod,\n        body || \"\",\n        JSON.stringify(xmlhttpRequestHeaders),\n        err.stack\n    );\n    lastXmlhttpRequestPrototypeMethod = null;\n    xmlhttpRequestUrl = null;\n    xmlhttpRequestHeaders = {};\n    this._send(body);\n};\n\nwindow._fetch = window.fetch;\nwindow.fetch = function () {\n    const firstArgument = arguments[0];\n    let url;\n    let method;\n    let body;\n    let headers;\n    if (typeof firstArgument === 'string') {\n        url = firstArgument;\n        method = arguments[1] && 'method' in arguments[1] ? arguments[1]['method'] : \"GET\";\n        body = arguments[1] && 'body' in arguments[1] ? arguments[1]['body'] : \"\";\n        headers = JSON.stringify(arguments[1] && 'headers' in arguments[1] ? arguments[1]['headers'] : {});\n    } else {\n        // Request object\n        url = firstArgument.url;\n        method = firstArgument.method;\n        body = firstArgument.body;\n        headers = JSON.stringify(Object.fromEntries(firstArgument.headers.entries()));\n    }\n    const fullUrl = getFullUrl(url);\n    const err = new Error();\n    RequestInspection.recordFetch(fullUrl, method, body, headers, err.stack);\n    return window._fetch.apply(this, arguments);\n}\n        ";

    public RequestInspectorJavaScriptInterface(@NotNull WebView webView) {
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        webView.addJavascriptInterface((Object)this, INTERFACE_NAME);
        this.recordedRequests = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final RecordedRequest findRecordedRequestForUrl(@NotNull String url) {
        RecordedRequest recordedRequest;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ArrayList<RecordedRequest> arrayList = this.recordedRequests;
        synchronized (arrayList) {
            RecordedRequest recordedRequest2;
            Object v0;
            RecordedRequest recordedRequest3;
            Object e;
            ListIterator listIterator;
            List list;
            block6: {
                boolean bl = false;
                list = this.recordedRequests;
                listIterator = list.listIterator(list.size());
                while (listIterator.hasPrevious()) {
                    e = listIterator.previous();
                    recordedRequest3 = (RecordedRequest)e;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)url, (Object)recordedRequest3.getUrl())) continue;
                    v0 = e;
                    break block6;
                }
                v0 = null;
            }
            if ((recordedRequest2 = (RecordedRequest)v0) == null) {
                Object v2;
                block7: {
                    list = this.recordedRequests;
                    listIterator = list.listIterator(list.size());
                    while (listIterator.hasPrevious()) {
                        e = listIterator.previous();
                        recordedRequest3 = (RecordedRequest)e;
                        boolean bl = false;
                        if (!StringsKt.contains$default((CharSequence)url, (CharSequence)recordedRequest3.getUrl(), (boolean)false, (int)2, null)) continue;
                        v2 = e;
                        break block7;
                    }
                    v2 = null;
                }
                recordedRequest2 = v2;
            }
            recordedRequest = recordedRequest2;
        }
        return recordedRequest;
    }

    /*
     * Unable to fully structure code
     */
    @JavascriptInterface
    public final void recordFormSubmission(@NotNull String url, @NotNull String method, @NotNull String formParameterList, @NotNull String headers, @NotNull String trace, @Nullable String enctype) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)formParameterList, (String)"formParameterList");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        formParameterJsonArray = new JSONArray(formParameterList);
        headerMap = this.getHeadersAsMap(headers);
        formParameterMap = this.getFormParametersAsMap(formParameterJsonArray);
        var11_10 = enctype;
        if (var11_10 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var11_10.hashCode()) {
            case -655019664: {
                if (var11_10.equals("multipart/form-data")) {
                    tmp = 1;
                }
                break;
            }
            case -1485569826: {
                if (var11_10.equals("application/x-www-form-urlencoded")) {
                    tmp = 2;
                }
                break;
            }
            case 817335912: {
                if (var11_10.equals("text/plain")) {
                    tmp = 3;
                }
                break;
            }
        }
        switch (tmp) {
            case 2: {
                headerMap.put("content-type", enctype);
                v0 = this.getUrlEncodedFormBody(formParameterJsonArray);
                break;
            }
            case 1: {
                headerMap.put("content-type", "multipart/form-data; boundary=----WebKitFormBoundaryU7CgQs9WnqlZYKs6");
                v0 = this.getMultiPartFormBody(formParameterJsonArray);
                break;
            }
            case 3: {
                headerMap.put("content-type", enctype);
                v0 = this.getPlainTextFormBody(formParameterJsonArray);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                Log.e((String)"RequestInspectorJs", (String)("Incorrect encoding received from JavaScript: " + enctype));
                v0 = "";
            }
        }
        body = v0;
        Log.i((String)"RequestInspectorJs", (String)"Recorded form submission from JavaScript");
        this.addRecordedRequest(new RecordedRequest(WebViewRequestType.FORM, url, method, body, formParameterMap, headerMap, trace, enctype));
    }

    @JavascriptInterface
    public final void recordXhr(@NotNull String url, @NotNull String method, @NotNull String body, @NotNull String headers, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Log.i((String)LOG_TAG, (String)"Recorded XHR from JavaScript");
        Map<String, String> headerMap = this.getHeadersAsMap(headers);
        this.addRecordedRequest(new RecordedRequest(WebViewRequestType.XML_HTTP, url, method, body, MapsKt.emptyMap(), headerMap, trace, null));
    }

    @JavascriptInterface
    public final void recordFetch(@NotNull String url, @NotNull String method, @NotNull String body, @NotNull String headers, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Log.i((String)LOG_TAG, (String)"Recorded fetch from JavaScript");
        Map<String, String> headerMap = this.getHeadersAsMap(headers);
        this.addRecordedRequest(new RecordedRequest(WebViewRequestType.FETCH, url, method, body, MapsKt.emptyMap(), headerMap, trace, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addRecordedRequest(RecordedRequest recordedRequest) {
        ArrayList<RecordedRequest> arrayList = this.recordedRequests;
        synchronized (arrayList) {
            boolean bl = false;
            boolean bl2 = this.recordedRequests.add(recordedRequest);
        }
    }

    private final Map<String, String> getHeadersAsMap(String headersString2) {
        JSONObject headersObject = new JSONObject(headersString2);
        HashMap map = new HashMap();
        Iterator iterator = headersObject.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"headersObject.keys()");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String string;
            String lowercaseHeader;
            String key = (String)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            Intrinsics.checkNotNullExpressionValue((Object)key.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue((Object)headersObject.getString(key), (String)"headersObject.getString(key)");
            map2.put(lowercaseHeader, string);
        }
        return map;
    }

    private final Map<String, String> getFormParametersAsMap(JSONArray formParameterJsonArray) {
        HashMap map = new HashMap();
        int n = formParameterJsonArray.length();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            boolean bl = false;
            Object object = formParameterJsonArray.get(i2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.json.JSONObject");
            }
            JSONObject formParameter = (JSONObject)object;
            String name = formParameter.getString("name");
            String value = formParameter.optString("value");
            boolean checked = formParameter.optBoolean("checked");
            String type = formParameter.optString("type");
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            if (this.isExcludedFormParameter(type, checked)) continue;
            Map map2 = map;
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
            Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
            map2.put(name, value);
        }
        return map;
    }

    private final String getUrlEncodedFormBody(JSONArray formParameterJsonArray) {
        StringBuilder resultStringBuilder = new StringBuilder();
        int n = formParameterJsonArray.length();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            boolean bl = false;
            Object object = formParameterJsonArray.get(i2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.json.JSONObject");
            }
            JSONObject formParameter = (JSONObject)object;
            String name = formParameter.getString("name");
            String value = formParameter.optString("value");
            boolean checked = formParameter.optBoolean("checked");
            String type = formParameter.optString("type");
            String encodedValue = URLEncoder.encode(value, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            if (this.isExcludedFormParameter(type, checked)) continue;
            if (i2 != 0) {
                resultStringBuilder.append("&");
            }
            resultStringBuilder.append(name);
            resultStringBuilder.append("=");
            resultStringBuilder.append(encodedValue);
        }
        String string = resultStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultStringBuilder.toString()");
        return string;
    }

    private final String getMultiPartFormBody(JSONArray formParameterJsonArray) {
        StringBuilder resultStringBuilder = new StringBuilder();
        int n = formParameterJsonArray.length();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            boolean bl = false;
            Object object = formParameterJsonArray.get(i2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.json.JSONObject");
            }
            JSONObject formParameter = (JSONObject)object;
            String name = formParameter.getString("name");
            String value = formParameter.optString("value");
            boolean checked = formParameter.optBoolean("checked");
            String type = formParameter.optString("type");
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            if (this.isExcludedFormParameter(type, checked)) continue;
            resultStringBuilder.append("--");
            resultStringBuilder.append(MULTIPART_FORM_BOUNDARY);
            resultStringBuilder.append("\n");
            resultStringBuilder.append("Content-Disposition: form-data; name=\"" + name + '\"');
            resultStringBuilder.append("\n\n");
            resultStringBuilder.append(value);
            resultStringBuilder.append("\n");
        }
        resultStringBuilder.append("--");
        resultStringBuilder.append(MULTIPART_FORM_BOUNDARY);
        resultStringBuilder.append("--");
        String string = resultStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultStringBuilder.toString()");
        return string;
    }

    private final String getPlainTextFormBody(JSONArray formParameterJsonArray) {
        StringBuilder resultStringBuilder = new StringBuilder();
        int n = formParameterJsonArray.length();
        for (int i = 0; i < n; ++i) {
            int i2 = i;
            boolean bl = false;
            Object object = formParameterJsonArray.get(i2);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.json.JSONObject");
            }
            JSONObject formParameter = (JSONObject)object;
            String name = formParameter.getString("name");
            String value = formParameter.optString("value");
            boolean checked = formParameter.optBoolean("checked");
            String type = formParameter.optString("type");
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            if (this.isExcludedFormParameter(type, checked)) continue;
            if (i2 != 0) {
                resultStringBuilder.append("\n");
            }
            resultStringBuilder.append(name);
            resultStringBuilder.append("=");
            resultStringBuilder.append(value);
        }
        String string = resultStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultStringBuilder.toString()");
        return string;
    }

    private final boolean isExcludedFormParameter(String type, boolean checked) {
        return (Intrinsics.areEqual((Object)type, (Object)"radio") || Intrinsics.areEqual((Object)type, (Object)"checkbox")) && !checked;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0019\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J\u0015\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010 \u001a\u0004\u0018\u00010\u0005H\u00c6\u0003Js\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t2\b\b\u0002\u0010\u000b\u001a\u00020\u00052\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006("}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$RecordedRequest;", "", "type", "Lcom/acsbendi/requestinspectorwebview/WebViewRequestType;", "url", "", "method", "body", "formParameters", "", "headers", "trace", "enctype", "(Lcom/acsbendi/requestinspectorwebview/WebViewRequestType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;)V", "getBody", "()Ljava/lang/String;", "getEnctype", "getFormParameters", "()Ljava/util/Map;", "getHeaders", "getMethod", "getTrace", "getType", "()Lcom/acsbendi/requestinspectorwebview/WebViewRequestType;", "getUrl", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "app_release"})
    public static final class RecordedRequest {
        @NotNull
        private final WebViewRequestType type;
        @NotNull
        private final String url;
        @NotNull
        private final String method;
        @NotNull
        private final String body;
        @NotNull
        private final Map<String, String> formParameters;
        @NotNull
        private final Map<String, String> headers;
        @NotNull
        private final String trace;
        @Nullable
        private final String enctype;

        public RecordedRequest(@NotNull WebViewRequestType type, @NotNull String url, @NotNull String method, @NotNull String body, @NotNull Map<String, String> formParameters, @NotNull Map<String, String> headers, @NotNull String trace, @Nullable String enctype) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter(formParameters, (String)"formParameters");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            this.type = type;
            this.url = url;
            this.method = method;
            this.body = body;
            this.formParameters = formParameters;
            this.headers = headers;
            this.trace = trace;
            this.enctype = enctype;
        }

        @NotNull
        public final WebViewRequestType getType() {
            return this.type;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @NotNull
        public final String getBody() {
            return this.body;
        }

        @NotNull
        public final Map<String, String> getFormParameters() {
            return this.formParameters;
        }

        @NotNull
        public final Map<String, String> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final String getTrace() {
            return this.trace;
        }

        @Nullable
        public final String getEnctype() {
            return this.enctype;
        }

        @NotNull
        public final WebViewRequestType component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final String component3() {
            return this.method;
        }

        @NotNull
        public final String component4() {
            return this.body;
        }

        @NotNull
        public final Map<String, String> component5() {
            return this.formParameters;
        }

        @NotNull
        public final Map<String, String> component6() {
            return this.headers;
        }

        @NotNull
        public final String component7() {
            return this.trace;
        }

        @Nullable
        public final String component8() {
            return this.enctype;
        }

        @NotNull
        public final RecordedRequest copy(@NotNull WebViewRequestType type, @NotNull String url, @NotNull String method, @NotNull String body, @NotNull Map<String, String> formParameters, @NotNull Map<String, String> headers, @NotNull String trace, @Nullable String enctype) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter(formParameters, (String)"formParameters");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            return new RecordedRequest(type, url, method, body, formParameters, headers, trace, enctype);
        }

        public static /* synthetic */ RecordedRequest copy$default(RecordedRequest recordedRequest, WebViewRequestType webViewRequestType, String string, String string2, String string3, Map map, Map map2, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                webViewRequestType = recordedRequest.type;
            }
            if ((n & 2) != 0) {
                string = recordedRequest.url;
            }
            if ((n & 4) != 0) {
                string2 = recordedRequest.method;
            }
            if ((n & 8) != 0) {
                string3 = recordedRequest.body;
            }
            if ((n & 0x10) != 0) {
                map = recordedRequest.formParameters;
            }
            if ((n & 0x20) != 0) {
                map2 = recordedRequest.headers;
            }
            if ((n & 0x40) != 0) {
                string4 = recordedRequest.trace;
            }
            if ((n & 0x80) != 0) {
                string5 = recordedRequest.enctype;
            }
            return recordedRequest.copy(webViewRequestType, string, string2, string3, map, map2, string4, string5);
        }

        @NotNull
        public String toString() {
            return "RecordedRequest(type=" + (Object)((Object)this.type) + ", url=" + this.url + ", method=" + this.method + ", body=" + this.body + ", formParameters=" + this.formParameters + ", headers=" + this.headers + ", trace=" + this.trace + ", enctype=" + this.enctype + ')';
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.url.hashCode();
            result = result * 31 + this.method.hashCode();
            result = result * 31 + this.body.hashCode();
            result = result * 31 + ((Object)this.formParameters).hashCode();
            result = result * 31 + ((Object)this.headers).hashCode();
            result = result * 31 + this.trace.hashCode();
            result = result * 31 + (this.enctype == null ? 0 : this.enctype.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecordedRequest)) {
                return false;
            }
            RecordedRequest recordedRequest = (RecordedRequest)other;
            if (this.type != recordedRequest.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)recordedRequest.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.method, (Object)recordedRequest.method)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.body, (Object)recordedRequest.body)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.formParameters, recordedRequest.formParameters)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.headers, recordedRequest.headers)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.trace, (Object)recordedRequest.trace)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.enctype, (Object)recordedRequest.enctype);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$Companion;", "", "()V", "INTERFACE_NAME", "", "JAVASCRIPT_INTERCEPTION_CODE", "LOG_TAG", "MULTIPART_FORM_BOUNDARY", "enabledRequestInspection", "", "webView", "Landroid/webkit/WebView;", "extraJavaScriptToInject", "app_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void enabledRequestInspection(@NotNull WebView webView, @NotNull String extraJavaScriptToInject) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            Intrinsics.checkNotNullParameter((Object)extraJavaScriptToInject, (String)"extraJavaScriptToInject");
            webView.evaluateJavascript("javascript: \nfunction getFullUrl(url) {\n    if (url.startsWith(\"/\")) {\n        return location.protocol + '//' + location.host + url;\n    } else {\n        return url;\n    }\n}\n\nfunction recordFormSubmission(form) {\n    var jsonArr = [];\n    for (i = 0; i < form.elements.length; i++) {\n        var parName = form.elements[i].name;\n        var parValue = form.elements[i].value;\n        var parType = form.elements[i].type;\n        var parChecked = form.elements[i].checked;\n        var parId = form.elements[i].id;\n\n        jsonArr.push({\n            name: parName,\n            value: parValue,\n            type: parType,\n            checked:parChecked,\n            id:parId\n        });\n    }\n\n    const path = form.attributes['action'] === undefined ? \"/\" : form.attributes['action'].nodeValue;\n    const method = form.attributes['method'] === undefined ? \"GET\" : form.attributes['method'].nodeValue;\n    const url = getFullUrl(path);\n    const encType = form.attributes['enctype'] === undefined ? \"application/x-www-form-urlencoded\" : form.attributes['enctype'].nodeValue;\n    const err = new Error();\n    RequestInspection.recordFormSubmission(\n        url,\n        method,\n        JSON.stringify(jsonArr),\n        \"{}\",\n        err.stack,\n        encType\n    );\n}\n\nfunction handleFormSubmission(e) {\n    const form = e ? e.target : this;\n    recordFormSubmission(form);\n    form._submit();\n}\n\nHTMLFormElement.prototype._submit = HTMLFormElement.prototype.submit;\nHTMLFormElement.prototype.submit = handleFormSubmission;\nwindow.addEventListener('submit', function (submitEvent) {\n    const form = submitEvent ? submitEvent.target : this;\n    recordFormSubmission(form);\n}, true);\n\nlet lastXmlhttpRequestPrototypeMethod = null;\nlet xmlhttpRequestHeaders = {};\nlet xmlhttpRequestUrl = null;\nXMLHttpRequest.prototype._open = XMLHttpRequest.prototype.open;\nXMLHttpRequest.prototype.open = function (method, url, async, user, password) {\n    lastXmlhttpRequestPrototypeMethod = method;\n    xmlhttpRequestUrl = url;\n    const asyncWithDefault = async === undefined ? true : async;\n    this._open(method, url, asyncWithDefault, user, password);\n};\nXMLHttpRequest.prototype._setRequestHeader = XMLHttpRequest.prototype.setRequestHeader;\nXMLHttpRequest.prototype.setRequestHeader = function (header, value) {\n    xmlhttpRequestHeaders[header] = value;\n    this._setRequestHeader(header, value);\n};\nXMLHttpRequest.prototype._send = XMLHttpRequest.prototype.send;\nXMLHttpRequest.prototype.send = function (body) {\n    const err = new Error();\n    const url = getFullUrl(xmlhttpRequestUrl);\n    RequestInspection.recordXhr(\n        url,\n        lastXmlhttpRequestPrototypeMethod,\n        body || \"\",\n        JSON.stringify(xmlhttpRequestHeaders),\n        err.stack\n    );\n    lastXmlhttpRequestPrototypeMethod = null;\n    xmlhttpRequestUrl = null;\n    xmlhttpRequestHeaders = {};\n    this._send(body);\n};\n\nwindow._fetch = window.fetch;\nwindow.fetch = function () {\n    const firstArgument = arguments[0];\n    let url;\n    let method;\n    let body;\n    let headers;\n    if (typeof firstArgument === 'string') {\n        url = firstArgument;\n        method = arguments[1] && 'method' in arguments[1] ? arguments[1]['method'] : \"GET\";\n        body = arguments[1] && 'body' in arguments[1] ? arguments[1]['body'] : \"\";\n        headers = JSON.stringify(arguments[1] && 'headers' in arguments[1] ? arguments[1]['headers'] : {});\n    } else {\n        // Request object\n        url = firstArgument.url;\n        method = firstArgument.method;\n        body = firstArgument.body;\n        headers = JSON.stringify(Object.fromEntries(firstArgument.headers.entries()));\n    }\n    const fullUrl = getFullUrl(url);\n    const err = new Error();\n    RequestInspection.recordFetch(fullUrl, method, body, headers, err.stack);\n    return window._fetch.apply(this, arguments);\n}\n        \n" + extraJavaScriptToInject, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

