/*
 * Decompiled with CFR 0.152.
 */
package com.acsbendi.requestinspectorwebview;

import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.acsbendi.requestinspectorwebview.WebViewRequestType;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0007J:\u0010\u0018\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\tH\u0007J0\u0010\u001b\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0007R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface;", "", "()V", "recordedRequests", "Ljava/util/ArrayList;", "Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$RecordedRequest;", "Lkotlin/collections/ArrayList;", "findRecordedRequestForUrl", "url", "", "getHeadersAsMap", "", "headersString", "getMultiPartFormBody", "formParameterJsonArray", "Lorg/json/JSONArray;", "getPlainTextFormBody", "getUrlEncodedFormBody", "recordFetch", "", "method", "body", "headers", "trace", "recordFormSubmission", "formParameterList", "enctype", "recordXhr", "Companion", "RecordedRequest", "app_release"})
public final class RequestInspectorJavaScriptInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<RecordedRequest> recordedRequests = new ArrayList();
    @NotNull
    private static final String LOG_TAG = "RequestInspectorJs";
    @NotNull
    private static final String MULTIPART_FORM_BOUNDARY = "----WebKitFormBoundaryU7CgQs9WnqlZYKs6";
    @Language(value="JS")
    @NotNull
    private static final String JAVASCRIPT_INTERCEPTION_CODE = "\nfunction getFullUrl(url) {\n    if (url.startsWith(\"/\")) {\n        return location.protocol + '//' + location.host + url;\n    } else {\n        return url;\n    }\n}\n\nfunction recordFormSubmission(form) {\n    var jsonArr = [];\n    for (i = 0; i < form.elements.length; i++) {\n        var parName = form.elements[i].name;\n        var parValue = form.elements[i].value;\n        var parType = form.elements[i].type;\n\n        jsonArr.push({\n            name: parName,\n            value: parValue,\n            type: parType\n        });\n    }\n\n    const path = form.attributes['action'] === undefined ? \"/\" : form.attributes['action'].nodeValue;\n    const method = form.attributes['method'] === undefined ? \"GET\" : form.attributes['method'].nodeValue;\n    const url = getFullUrl(path);\n    const encType = form.attributes['enctype'] === undefined ? \"application/x-www-form-urlencoded\" : form.attributes['enctype'].nodeValue;\n    const err = new Error();\n    RequestInspection.recordFormSubmission(\n        url,\n        method,\n        JSON.stringify(jsonArr),\n        \"\",\n        err.stack,\n        encType\n    );\n}\n\nfunction handleFormSubmission(e) {\n    const form = e ? e.target : this;\n    recordFormSubmission(form);\n    form._submit();\n}\n\nHTMLFormElement.prototype._submit = HTMLFormElement.prototype.submit;\nHTMLFormElement.prototype.submit = handleFormSubmission;\nwindow.addEventListener('submit', function (submitEvent) {\n    handleFormSubmission(submitEvent);\n}, true);\n\nlet lastXmlhttpRequestPrototypeMethod = null;\nlet xmlhttpRequestHeaders = {};\nlet xmlhttpRequestUrl = null;\nXMLHttpRequest.prototype._open = XMLHttpRequest.prototype.open;\nXMLHttpRequest.prototype.open = function (method, url, async, user, password) {\n    lastXmlhttpRequestPrototypeMethod = method;\n    xmlhttpRequestUrl = url;\n    this._open(method, url, async, user, password);\n};\nXMLHttpRequest.prototype._setRequestHeader = XMLHttpRequest.prototype.setRequestHeader;\nXMLHttpRequest.prototype.setRequestHeader = function (header, value) {\n    xmlhttpRequestHeaders[header] = value;\n    this._setRequestHeader(header, value);\n};\nXMLHttpRequest.prototype._send = XMLHttpRequest.prototype.send;\nXMLHttpRequest.prototype.send = function (body) {\n    const err = new Error();\n    const url = getFullUrl(xmlhttpRequestUrl);\n    RequestInspection.recordXhr(\n        url,\n        lastXmlhttpRequestPrototypeMethod,\n        body,\n        JSON.stringify(xmlhttpRequestHeaders),\n        err.stack\n    );\n    lastXmlhttpRequestPrototypeMethod = null;\n    xmlhttpRequestUrl = null;\n    xmlhttpRequestHeaders = {};\n    this._send(body);\n};\n\nwindow._fetch = window.fetch;\nwindow.fetch = function () {\n    const url = arguments[1] && 'url' in arguments[1] ? arguments[1]['url'] : \"/\";\n    const fullUrl = getFullUrl(url);\n    const method = arguments[1] && 'method' in arguments[1] ? arguments[1]['method'] : \"GET\";\n    const body = arguments[1] && 'body' in arguments[1] ? arguments[1]['body'] : \"\";\n    const headers = JSON.stringify(arguments[1] && 'headers' in arguments[1] ? arguments[1]['headers'] : {});\n    let err = new Error();\n    RequestInspection.recordFetch(fullUrl, method, body, headers, err.stack);\n    return window._fetch.apply(this, arguments);\n}\n        ";

    @Nullable
    public final RecordedRequest findRecordedRequestForUrl(@NotNull String url) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Iterable iterable = this.recordedRequests;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                RecordedRequest recordedRequest = (RecordedRequest)t;
                boolean bl3 = false;
                if (!StringsKt.contains$default((CharSequence)url, (CharSequence)recordedRequest.getUrl(), (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Unable to fully structure code
     */
    @JavascriptInterface
    public final void recordFormSubmission(@NotNull String url, @NotNull String method, @NotNull String formParameterList, @NotNull String headers, @NotNull String trace, @Nullable String enctype) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)formParameterList, (String)"formParameterList");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        formParameterJsonArray = new JSONArray(formParameterList);
        headerMap = this.getHeadersAsMap(headers);
        var10_9 = enctype;
        if (var10_9 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var10_9.hashCode()) {
            case -655019664: {
                if (var10_9.equals("multipart/form-data")) {
                    tmp = 1;
                }
                break;
            }
            case -1485569826: {
                if (var10_9.equals("application/x-www-form-urlencoded")) {
                    tmp = 2;
                }
                break;
            }
            case 817335912: {
                if (var10_9.equals("text/plain")) {
                    tmp = 3;
                }
                break;
            }
        }
        switch (tmp) {
            case 2: {
                v0 = this.getUrlEncodedFormBody(formParameterJsonArray);
                break;
            }
            case 1: {
                var11_10 = headerMap;
                var12_11 = "content-type";
                var13_12 = "multipart/form-data; boundary=----WebKitFormBoundaryU7CgQs9WnqlZYKs6";
                var14_13 = false;
                var11_10.put(var12_11, var13_12);
                v0 = this.getMultiPartFormBody(formParameterJsonArray);
                break;
            }
            case 3: {
                v0 = this.getPlainTextFormBody(formParameterJsonArray);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                Log.e((String)"RequestInspectorJs", (String)Intrinsics.stringPlus((String)"Incorrect encoding received from JavaScript: ", (Object)enctype));
                v0 = "";
            }
        }
        body = v0;
        Log.i((String)"RequestInspectorJs", (String)"Recorded form submission from JavaScript");
        this.recordedRequests.add(new RecordedRequest(WebViewRequestType.FORM, url, method, body, headerMap, trace, enctype));
    }

    @JavascriptInterface
    public final void recordXhr(@NotNull String url, @NotNull String method, @NotNull String body, @NotNull String headers, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Log.i((String)LOG_TAG, (String)"Recorded XHR from JavaScript");
        Map<String, String> headerMap = this.getHeadersAsMap(headers);
        this.recordedRequests.add(new RecordedRequest(WebViewRequestType.XML_HTTP, url, method, body, headerMap, trace, null));
    }

    @JavascriptInterface
    public final void recordFetch(@NotNull String url, @NotNull String method, @NotNull String body, @NotNull String headers, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Log.i((String)LOG_TAG, (String)"Recorded fetch from JavaScript");
        Map<String, String> headerMap = this.getHeadersAsMap(headers);
        this.recordedRequests.add(new RecordedRequest(WebViewRequestType.FETCH, url, method, body, headerMap, trace, null));
    }

    private final Map<String, String> getHeadersAsMap(String headersString2) {
        JSONObject headersObject = new JSONObject(headersString2);
        HashMap map = new HashMap();
        Iterator iterator = headersObject.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"headersObject.keys()");
        boolean bl = false;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String lowercaseHeader;
            String key = (String)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            Object object = key;
            Object object2 = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getDefault()");
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)((String)object).toLowerCase((Locale)object2), (String)"(this as java.lang.String).toLowerCase(locale)");
            object = map;
            object2 = headersObject.getString(key);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"headersObject.getString(key)");
            bl2 = false;
            object.put(lowercaseHeader, object2);
        }
        return map;
    }

    private final String getUrlEncodedFormBody(JSONArray formParameterJsonArray) {
        StringBuilder resultStringBuilder = new StringBuilder();
        int n = formParameterJsonArray.length();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            int i = n2;
            boolean bl2 = false;
            Object object = formParameterJsonArray.get(i);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.json.JSONObject");
            }
            JSONObject formParameter = (JSONObject)object;
            String name = formParameter.getString("name");
            String value = formParameter.getString("value");
            String encodedValue = URLEncoder.encode(value, "UTF-8");
            if (i != 0) {
                resultStringBuilder.append("&");
            }
            resultStringBuilder.append(name);
            resultStringBuilder.append("=");
            resultStringBuilder.append(encodedValue);
        }
        String string = resultStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultStringBuilder.toString()");
        return string;
    }

    private final String getMultiPartFormBody(JSONArray formParameterJsonArray) {
        StringBuilder resultStringBuilder = new StringBuilder();
        int n = formParameterJsonArray.length();
        boolean bl = false;
        int n2 = 0;
        n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int i = n2++;
            boolean bl2 = false;
            Object object = formParameterJsonArray.get(i);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.json.JSONObject");
            }
            JSONObject formParameter = (JSONObject)object;
            String name = formParameter.getString("name");
            String value = formParameter.getString("value");
            resultStringBuilder.append("--");
            resultStringBuilder.append(MULTIPART_FORM_BOUNDARY);
            resultStringBuilder.append("\n");
            resultStringBuilder.append("Content-Disposition: form-data; name=\"" + name + '\"');
            resultStringBuilder.append("\n\n");
            resultStringBuilder.append(value);
            resultStringBuilder.append("\n");
        }
        resultStringBuilder.append("--");
        resultStringBuilder.append(MULTIPART_FORM_BOUNDARY);
        resultStringBuilder.append("--");
        String string = resultStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultStringBuilder.toString()");
        return string;
    }

    private final String getPlainTextFormBody(JSONArray formParameterJsonArray) {
        StringBuilder resultStringBuilder = new StringBuilder();
        int n = formParameterJsonArray.length();
        boolean bl = false;
        int n2 = 0;
        int n3 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            int i = n2;
            boolean bl2 = false;
            Object object = formParameterJsonArray.get(i);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.json.JSONObject");
            }
            JSONObject formParameter = (JSONObject)object;
            String name = formParameter.getString("name");
            String value = formParameter.getString("value");
            if (i != 0) {
                resultStringBuilder.append("\n");
            }
            resultStringBuilder.append(name);
            resultStringBuilder.append("=");
            resultStringBuilder.append(value);
        }
        String string = resultStringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resultStringBuilder.toString()");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\u0015\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\tH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J]\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020#H\u00d6\u0001J\b\u0010$\u001a\u00020\u0005H\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$RecordedRequest;", "", "type", "Lcom/acsbendi/requestinspectorwebview/WebViewRequestType;", "url", "", "method", "body", "headers", "", "trace", "enctype", "(Lcom/acsbendi/requestinspectorwebview/WebViewRequestType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;)V", "getBody", "()Ljava/lang/String;", "getEnctype", "getHeaders", "()Ljava/util/Map;", "getMethod", "getTrace", "getType", "()Lcom/acsbendi/requestinspectorwebview/WebViewRequestType;", "getUrl", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "app_release"})
    public static final class RecordedRequest {
        @NotNull
        private final WebViewRequestType type;
        @NotNull
        private final String url;
        @NotNull
        private final String method;
        @NotNull
        private final String body;
        @NotNull
        private final Map<String, String> headers;
        @NotNull
        private final String trace;
        @Nullable
        private final String enctype;

        public RecordedRequest(@NotNull WebViewRequestType type, @NotNull String url, @NotNull String method, @NotNull String body, @NotNull Map<String, String> headers, @NotNull String trace, @Nullable String enctype) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            this.type = type;
            this.url = url;
            this.method = method;
            this.body = body;
            this.headers = headers;
            this.trace = trace;
            this.enctype = enctype;
        }

        @NotNull
        public final WebViewRequestType getType() {
            return this.type;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @NotNull
        public final String getBody() {
            return this.body;
        }

        @NotNull
        public final Map<String, String> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final String getTrace() {
            return this.trace;
        }

        @Nullable
        public final String getEnctype() {
            return this.enctype;
        }

        @NotNull
        public String toString() {
            String enctypeString = this.enctype != null ? '\"' + StringsKt.replace$default((String)this.enctype, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + '\"' : "null";
            return "{ \"type\": \"" + StringsKt.replace$default((String)this.type.toString(), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"url\": \"" + StringsKt.replace$default((String)this.url, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"method\": \"" + StringsKt.replace$default((String)this.method, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"body\": \"" + StringsKt.replace$default((String)this.body, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"headers\": \"" + StringsKt.replace$default((String)this.headers.toString(), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"trace\": \"" + StringsKt.replace$default((String)this.trace, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"enctype\": " + enctypeString + " }";
        }

        @NotNull
        public final WebViewRequestType component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final String component3() {
            return this.method;
        }

        @NotNull
        public final String component4() {
            return this.body;
        }

        @NotNull
        public final Map<String, String> component5() {
            return this.headers;
        }

        @NotNull
        public final String component6() {
            return this.trace;
        }

        @Nullable
        public final String component7() {
            return this.enctype;
        }

        @NotNull
        public final RecordedRequest copy(@NotNull WebViewRequestType type, @NotNull String url, @NotNull String method, @NotNull String body, @NotNull Map<String, String> headers, @NotNull String trace, @Nullable String enctype) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter(headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            return new RecordedRequest(type, url, method, body, headers, trace, enctype);
        }

        public static /* synthetic */ RecordedRequest copy$default(RecordedRequest recordedRequest, WebViewRequestType webViewRequestType, String string, String string2, String string3, Map map, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                webViewRequestType = recordedRequest.type;
            }
            if ((n & 2) != 0) {
                string = recordedRequest.url;
            }
            if ((n & 4) != 0) {
                string2 = recordedRequest.method;
            }
            if ((n & 8) != 0) {
                string3 = recordedRequest.body;
            }
            if ((n & 0x10) != 0) {
                map = recordedRequest.headers;
            }
            if ((n & 0x20) != 0) {
                string4 = recordedRequest.trace;
            }
            if ((n & 0x40) != 0) {
                string5 = recordedRequest.enctype;
            }
            return recordedRequest.copy(webViewRequestType, string, string2, string3, map, string4, string5);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.url.hashCode();
            result = result * 31 + this.method.hashCode();
            result = result * 31 + this.body.hashCode();
            result = result * 31 + ((Object)this.headers).hashCode();
            result = result * 31 + this.trace.hashCode();
            result = result * 31 + (this.enctype == null ? 0 : this.enctype.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecordedRequest)) {
                return false;
            }
            RecordedRequest recordedRequest = (RecordedRequest)other;
            if (this.type != recordedRequest.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)recordedRequest.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.method, (Object)recordedRequest.method)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.body, (Object)recordedRequest.body)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.headers, recordedRequest.headers)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.trace, (Object)recordedRequest.trace)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.enctype, (Object)recordedRequest.enctype);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$Companion;", "", "()V", "JAVASCRIPT_INTERCEPTION_CODE", "", "LOG_TAG", "MULTIPART_FORM_BOUNDARY", "enableInterception", "", "webView", "Landroid/webkit/WebView;", "extraJavaScriptToInject", "app_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void enableInterception(@NotNull WebView webView, @NotNull String extraJavaScriptToInject) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            Intrinsics.checkNotNullParameter((Object)extraJavaScriptToInject, (String)"extraJavaScriptToInject");
            webView.evaluateJavascript(Intrinsics.stringPlus((String)"javascript: \nfunction getFullUrl(url) {\n    if (url.startsWith(\"/\")) {\n        return location.protocol + '//' + location.host + url;\n    } else {\n        return url;\n    }\n}\n\nfunction recordFormSubmission(form) {\n    var jsonArr = [];\n    for (i = 0; i < form.elements.length; i++) {\n        var parName = form.elements[i].name;\n        var parValue = form.elements[i].value;\n        var parType = form.elements[i].type;\n\n        jsonArr.push({\n            name: parName,\n            value: parValue,\n            type: parType\n        });\n    }\n\n    const path = form.attributes['action'] === undefined ? \"/\" : form.attributes['action'].nodeValue;\n    const method = form.attributes['method'] === undefined ? \"GET\" : form.attributes['method'].nodeValue;\n    const url = getFullUrl(path);\n    const encType = form.attributes['enctype'] === undefined ? \"application/x-www-form-urlencoded\" : form.attributes['enctype'].nodeValue;\n    const err = new Error();\n    RequestInspection.recordFormSubmission(\n        url,\n        method,\n        JSON.stringify(jsonArr),\n        \"\",\n        err.stack,\n        encType\n    );\n}\n\nfunction handleFormSubmission(e) {\n    const form = e ? e.target : this;\n    recordFormSubmission(form);\n    form._submit();\n}\n\nHTMLFormElement.prototype._submit = HTMLFormElement.prototype.submit;\nHTMLFormElement.prototype.submit = handleFormSubmission;\nwindow.addEventListener('submit', function (submitEvent) {\n    handleFormSubmission(submitEvent);\n}, true);\n\nlet lastXmlhttpRequestPrototypeMethod = null;\nlet xmlhttpRequestHeaders = {};\nlet xmlhttpRequestUrl = null;\nXMLHttpRequest.prototype._open = XMLHttpRequest.prototype.open;\nXMLHttpRequest.prototype.open = function (method, url, async, user, password) {\n    lastXmlhttpRequestPrototypeMethod = method;\n    xmlhttpRequestUrl = url;\n    this._open(method, url, async, user, password);\n};\nXMLHttpRequest.prototype._setRequestHeader = XMLHttpRequest.prototype.setRequestHeader;\nXMLHttpRequest.prototype.setRequestHeader = function (header, value) {\n    xmlhttpRequestHeaders[header] = value;\n    this._setRequestHeader(header, value);\n};\nXMLHttpRequest.prototype._send = XMLHttpRequest.prototype.send;\nXMLHttpRequest.prototype.send = function (body) {\n    const err = new Error();\n    const url = getFullUrl(xmlhttpRequestUrl);\n    RequestInspection.recordXhr(\n        url,\n        lastXmlhttpRequestPrototypeMethod,\n        body,\n        JSON.stringify(xmlhttpRequestHeaders),\n        err.stack\n    );\n    lastXmlhttpRequestPrototypeMethod = null;\n    xmlhttpRequestUrl = null;\n    xmlhttpRequestHeaders = {};\n    this._send(body);\n};\n\nwindow._fetch = window.fetch;\nwindow.fetch = function () {\n    const url = arguments[1] && 'url' in arguments[1] ? arguments[1]['url'] : \"/\";\n    const fullUrl = getFullUrl(url);\n    const method = arguments[1] && 'method' in arguments[1] ? arguments[1]['method'] : \"GET\";\n    const body = arguments[1] && 'body' in arguments[1] ? arguments[1]['body'] : \"\";\n    const headers = JSON.stringify(arguments[1] && 'headers' in arguments[1] ? arguments[1]['headers'] : {});\n    let err = new Error();\n    RequestInspection.recordFetch(fullUrl, method, body, headers, err.stack);\n    return window._fetch.apply(this, arguments);\n}\n        \n", (Object)extraJavaScriptToInject), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

