/*
 * Decompiled with CFR 0.152.
 */
package com.acsbendi.requestinspectorwebview;

import android.util.Log;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0003\u0013\u0014\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\tJ0\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0007J:\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0007J0\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0007R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface;", "", "()V", "recordedRequests", "Ljava/util/ArrayList;", "Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$RecordedRequest;", "Lkotlin/collections/ArrayList;", "findRecordedRequestForUrl", "url", "", "recordFetch", "", "method", "body", "headers", "trace", "recordFormSubmission", "enctype", "recordXhr", "Companion", "RecordedRequest", "RequestType", "app_release"})
public final class RequestInspectorJavaScriptInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArrayList<RecordedRequest> recordedRequests = new ArrayList();
    @NotNull
    private static final String LOG_TAG = "RequestInspectorJs";
    @Language(value="JS")
    @NotNull
    private static final String JAVASCRIPT_INTERCEPTION_CODE = "\nfunction getFullUrl(url) {\n    if (url.startsWith(\"/\")) {\n        return location.protocol + '//' + location.host + url;\n    } else {\n        return url;\n    }\n}\n\nfunction recordFormSubmission(form) {\n    var jsonArr = [];\n    for (i = 0; i < form.elements.length; i++) {\n        var parName = form.elements[i].name;\n        var parValue = form.elements[i].value;\n        var parType = form.elements[i].type;\n\n        jsonArr.push({\n            name: parName,\n            value: parValue,\n            type: parType\n        });\n    }\n\n    const path = form.attributes['action'] === undefined ? \"/\" : form.attributes['action'].nodeValue;\n    const method = form.attributes['method'] === undefined ? \"GET\" : form.attributes['method'].nodeValue;\n    const url = getFullUrl(path);\n    const encType = form.attributes['enctype'] === undefined ? null : form.attributes['enctype'].nodeValue;\n    const err = new Error();\n    RequestInspection.recordFormSubmission(\n        url,\n        method,\n        JSON.stringify(jsonArr),\n        \"\",\n        err.stack,\n        encType\n    );\n}\n\nfunction handleFormSubmission(e) {\n    const form = e ? e.target : this;\n    recordFormSubmission(form);\n    form._submit();\n}\n\nHTMLFormElement.prototype._submit = HTMLFormElement.prototype.submit;\nHTMLFormElement.prototype.submit = handleFormSubmission;\nwindow.addEventListener('submit', function (submitEvent) {\n    handleFormSubmission(submitEvent);\n}, true);\n\nlet lastXmlhttpRequestPrototypeMethod = null;\nlet xmlhttpRequestHeaders = \"\";\nlet xmlhttpRequestUrl = null;\nXMLHttpRequest.prototype._open = XMLHttpRequest.prototype.open;\nXMLHttpRequest.prototype.open = function (method, url, async, user, password) {\n    lastXmlhttpRequestPrototypeMethod = method;\n    xmlhttpRequestUrl = url;\n    this._open(method, url, async, user, password);\n};\nXMLHttpRequest.prototype._setRequestHeader = XMLHttpRequest.prototype.setRequestHeader;\nXMLHttpRequest.prototype.setRequestHeader = function (header, value) {\n    xmlhttpRequestHeaders += (header + \": \" + value + \"\\n\");\n    this._setRequestHeader(header, value);\n};\nXMLHttpRequest.prototype._send = XMLHttpRequest.prototype.send;\nXMLHttpRequest.prototype.send = function (body) {\n    const err = new Error();\n    const url = getFullUrl(xmlhttpRequestUrl);\n    RequestInspection.recordXhr(\n        url,\n        lastXmlhttpRequestPrototypeMethod,\n        body,\n        xmlhttpRequestHeaders,\n        err.stack\n    );\n    lastXmlhttpRequestPrototypeMethod = null;\n    xmlhttpRequestUrl = null;\n    xmlhttpRequestHeaders = \"\";\n    this._send(body);\n};\n\nwindow._fetch = window.fetch;\nwindow.fetch = function () {\n    const url = arguments[1] && 'url' in arguments[1] ? arguments[1]['url'] : \"/\";\n    const fullUrl = getFullUrl(url);\n    const method = arguments[1] && 'method' in arguments[1] ? arguments[1]['method'] : \"GET\";\n    const body = arguments[1] && 'body' in arguments[1] ? arguments[1]['body'] : \"\";\n    const headers = JSON.stringify(arguments[1] && 'headers' in arguments[1] ? arguments[1]['headers'] : {});\n    let err = new Error();\n    RequestInspection.recordFetch(fullUrl, method, body, headers, err.stack);\n    return window._fetch.apply(this, arguments);\n}\n        ";

    @Nullable
    public final RecordedRequest findRecordedRequestForUrl(@NotNull String url) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Iterable iterable = this.recordedRequests;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                RecordedRequest recordedRequest = (RecordedRequest)t;
                boolean bl3 = false;
                if (!StringsKt.contains$default((CharSequence)url, (CharSequence)recordedRequest.getUrl(), (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JavascriptInterface
    public final void recordFormSubmission(@NotNull String url, @NotNull String method, @NotNull String body, @NotNull String headers, @NotNull String trace, @Nullable String enctype) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Log.i((String)LOG_TAG, (String)"Recorded form submission from JavaScript");
        this.recordedRequests.add(new RecordedRequest(RequestType.FORM, url, method, body, headers, trace, enctype));
    }

    @JavascriptInterface
    public final void recordXhr(@NotNull String url, @NotNull String method, @NotNull String body, @NotNull String headers, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Log.i((String)LOG_TAG, (String)"Recorded XHR from JavaScript");
        this.recordedRequests.add(new RecordedRequest(RequestType.XML_HTTP, url, method, body, headers, trace, null));
    }

    @JavascriptInterface
    public final void recordFetch(@NotNull String url, @NotNull String method, @NotNull String body, @NotNull String headers, @NotNull String trace) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        Log.i((String)LOG_TAG, (String)"Recorded fetch from JavaScript");
        this.recordedRequests.add(new RecordedRequest(RequestType.FETCH, url, method, body, headers, trace, null));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$RequestType;", "", "(Ljava/lang/String;I)V", "FETCH", "XML_HTTP", "FORM", "app_release"})
    public static final class RequestType
    extends Enum<RequestType> {
        public static final /* enum */ RequestType FETCH = new RequestType();
        public static final /* enum */ RequestType XML_HTTP = new RequestType();
        public static final /* enum */ RequestType FORM = new RequestType();
        private static final /* synthetic */ RequestType[] $VALUES;

        public static RequestType[] values() {
            return (RequestType[])$VALUES.clone();
        }

        public static RequestType valueOf(String value) {
            return Enum.valueOf(RequestType.class, value);
        }

        static {
            $VALUES = requestTypeArray = new RequestType[]{RequestType.FETCH, RequestType.XML_HTTP, RequestType.FORM};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003JQ\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u00052\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\b\u0010\"\u001a\u00020\u0005H\u0016R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\r\u00a8\u0006#"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$RecordedRequest;", "", "type", "Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$RequestType;", "url", "", "method", "body", "headers", "trace", "enctype", "(Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$RequestType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBody", "()Ljava/lang/String;", "getEnctype", "getHeaders", "getMethod", "getTrace", "getType", "()Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$RequestType;", "getUrl", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "app_release"})
    public static final class RecordedRequest {
        @NotNull
        private final RequestType type;
        @NotNull
        private final String url;
        @NotNull
        private final String method;
        @NotNull
        private final String body;
        @NotNull
        private final String headers;
        @NotNull
        private final String trace;
        @Nullable
        private final String enctype;

        public RecordedRequest(@NotNull RequestType type, @NotNull String url, @NotNull String method, @NotNull String body, @NotNull String headers, @NotNull String trace, @Nullable String enctype) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            this.type = type;
            this.url = url;
            this.method = method;
            this.body = body;
            this.headers = headers;
            this.trace = trace;
            this.enctype = enctype;
        }

        @NotNull
        public final RequestType getType() {
            return this.type;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @NotNull
        public final String getBody() {
            return this.body;
        }

        @NotNull
        public final String getHeaders() {
            return this.headers;
        }

        @NotNull
        public final String getTrace() {
            return this.trace;
        }

        @Nullable
        public final String getEnctype() {
            return this.enctype;
        }

        @NotNull
        public String toString() {
            String enctypeString = this.enctype != null ? '\"' + StringsKt.replace$default((String)this.enctype, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + '\"' : "null";
            return "{ \"type\": \"" + StringsKt.replace$default((String)this.type.toString(), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"url\": \"" + StringsKt.replace$default((String)this.url, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"method\": \"" + StringsKt.replace$default((String)this.method, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"body\": \"" + StringsKt.replace$default((String)this.body, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"headers\": \"" + StringsKt.replace$default((String)this.headers, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"trace\": \"" + StringsKt.replace$default((String)this.trace, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null) + "\", \"enctype\": " + enctypeString + " }";
        }

        @NotNull
        public final RequestType component1() {
            return this.type;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final String component3() {
            return this.method;
        }

        @NotNull
        public final String component4() {
            return this.body;
        }

        @NotNull
        public final String component5() {
            return this.headers;
        }

        @NotNull
        public final String component6() {
            return this.trace;
        }

        @Nullable
        public final String component7() {
            return this.enctype;
        }

        @NotNull
        public final RecordedRequest copy(@NotNull RequestType type, @NotNull String url, @NotNull String method, @NotNull String body, @NotNull String headers, @NotNull String trace, @Nullable String enctype) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
            Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
            return new RecordedRequest(type, url, method, body, headers, trace, enctype);
        }

        public static /* synthetic */ RecordedRequest copy$default(RecordedRequest recordedRequest, RequestType requestType, String string, String string2, String string3, String string4, String string5, String string6, int n, Object object) {
            if ((n & 1) != 0) {
                requestType = recordedRequest.type;
            }
            if ((n & 2) != 0) {
                string = recordedRequest.url;
            }
            if ((n & 4) != 0) {
                string2 = recordedRequest.method;
            }
            if ((n & 8) != 0) {
                string3 = recordedRequest.body;
            }
            if ((n & 0x10) != 0) {
                string4 = recordedRequest.headers;
            }
            if ((n & 0x20) != 0) {
                string5 = recordedRequest.trace;
            }
            if ((n & 0x40) != 0) {
                string6 = recordedRequest.enctype;
            }
            return recordedRequest.copy(requestType, string, string2, string3, string4, string5, string6);
        }

        public int hashCode() {
            int result = this.type.hashCode();
            result = result * 31 + this.url.hashCode();
            result = result * 31 + this.method.hashCode();
            result = result * 31 + this.body.hashCode();
            result = result * 31 + this.headers.hashCode();
            result = result * 31 + this.trace.hashCode();
            result = result * 31 + (this.enctype == null ? 0 : this.enctype.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RecordedRequest)) {
                return false;
            }
            RecordedRequest recordedRequest = (RecordedRequest)other;
            if (this.type != recordedRequest.type) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)recordedRequest.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.method, (Object)recordedRequest.method)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.body, (Object)recordedRequest.body)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.headers, (Object)recordedRequest.headers)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.trace, (Object)recordedRequest.trace)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.enctype, (Object)recordedRequest.enctype);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/acsbendi/requestinspectorwebview/RequestInspectorJavaScriptInterface$Companion;", "", "()V", "JAVASCRIPT_INTERCEPTION_CODE", "", "LOG_TAG", "enableInterception", "", "webView", "Landroid/webkit/WebView;", "extraJavaScriptToInject", "app_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void enableInterception(@NotNull WebView webView, @NotNull String extraJavaScriptToInject) {
            Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
            Intrinsics.checkNotNullParameter((Object)extraJavaScriptToInject, (String)"extraJavaScriptToInject");
            webView.evaluateJavascript(Intrinsics.stringPlus((String)"javascript: \nfunction getFullUrl(url) {\n    if (url.startsWith(\"/\")) {\n        return location.protocol + '//' + location.host + url;\n    } else {\n        return url;\n    }\n}\n\nfunction recordFormSubmission(form) {\n    var jsonArr = [];\n    for (i = 0; i < form.elements.length; i++) {\n        var parName = form.elements[i].name;\n        var parValue = form.elements[i].value;\n        var parType = form.elements[i].type;\n\n        jsonArr.push({\n            name: parName,\n            value: parValue,\n            type: parType\n        });\n    }\n\n    const path = form.attributes['action'] === undefined ? \"/\" : form.attributes['action'].nodeValue;\n    const method = form.attributes['method'] === undefined ? \"GET\" : form.attributes['method'].nodeValue;\n    const url = getFullUrl(path);\n    const encType = form.attributes['enctype'] === undefined ? null : form.attributes['enctype'].nodeValue;\n    const err = new Error();\n    RequestInspection.recordFormSubmission(\n        url,\n        method,\n        JSON.stringify(jsonArr),\n        \"\",\n        err.stack,\n        encType\n    );\n}\n\nfunction handleFormSubmission(e) {\n    const form = e ? e.target : this;\n    recordFormSubmission(form);\n    form._submit();\n}\n\nHTMLFormElement.prototype._submit = HTMLFormElement.prototype.submit;\nHTMLFormElement.prototype.submit = handleFormSubmission;\nwindow.addEventListener('submit', function (submitEvent) {\n    handleFormSubmission(submitEvent);\n}, true);\n\nlet lastXmlhttpRequestPrototypeMethod = null;\nlet xmlhttpRequestHeaders = \"\";\nlet xmlhttpRequestUrl = null;\nXMLHttpRequest.prototype._open = XMLHttpRequest.prototype.open;\nXMLHttpRequest.prototype.open = function (method, url, async, user, password) {\n    lastXmlhttpRequestPrototypeMethod = method;\n    xmlhttpRequestUrl = url;\n    this._open(method, url, async, user, password);\n};\nXMLHttpRequest.prototype._setRequestHeader = XMLHttpRequest.prototype.setRequestHeader;\nXMLHttpRequest.prototype.setRequestHeader = function (header, value) {\n    xmlhttpRequestHeaders += (header + \": \" + value + \"\\n\");\n    this._setRequestHeader(header, value);\n};\nXMLHttpRequest.prototype._send = XMLHttpRequest.prototype.send;\nXMLHttpRequest.prototype.send = function (body) {\n    const err = new Error();\n    const url = getFullUrl(xmlhttpRequestUrl);\n    RequestInspection.recordXhr(\n        url,\n        lastXmlhttpRequestPrototypeMethod,\n        body,\n        xmlhttpRequestHeaders,\n        err.stack\n    );\n    lastXmlhttpRequestPrototypeMethod = null;\n    xmlhttpRequestUrl = null;\n    xmlhttpRequestHeaders = \"\";\n    this._send(body);\n};\n\nwindow._fetch = window.fetch;\nwindow.fetch = function () {\n    const url = arguments[1] && 'url' in arguments[1] ? arguments[1]['url'] : \"/\";\n    const fullUrl = getFullUrl(url);\n    const method = arguments[1] && 'method' in arguments[1] ? arguments[1]['method'] : \"GET\";\n    const body = arguments[1] && 'body' in arguments[1] ? arguments[1]['body'] : \"\";\n    const headers = JSON.stringify(arguments[1] && 'headers' in arguments[1] ? arguments[1]['headers'] : {});\n    let err = new Error();\n    RequestInspection.recordFetch(fullUrl, method, body, headers, err.stack);\n    return window._fetch.apply(this, arguments);\n}\n        \n", (Object)extraJavaScriptToInject), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

