/*
 * Decompiled with CFR 0.152.
 */
package io.unico.unicosdkbase.totp;

import io.unico.unicosdkbase.totp.OTP;
import io.unico.unicosdkbase.totp.TOTPGenerator;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\rB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/unico/unicosdkbase/totp/TOTP;", "Lio/unico/unicosdkbase/totp/OTP;", "Lio/unico/unicosdkbase/totp/TOTPGenerator;", "builder", "Lio/unico/unicosdkbase/totp/TOTP$Builder;", "currentTimeMillis", "", "(Lio/unico/unicosdkbase/totp/TOTP$Builder;J)V", "period", "", "calculateCounter", "now", "", "Builder", "totp_release"})
public final class TOTP
extends OTP
implements TOTPGenerator {
    private final long currentTimeMillis;
    private int period;

    public TOTP(@NotNull Builder builder, long currentTimeMillis) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super(builder);
        this.currentTimeMillis = currentTimeMillis;
        this.period = builder.getPeriod();
    }

    @Override
    @NotNull
    public String now() {
        long counter = this.calculateCounter(this.period);
        return super.generate(counter);
    }

    private final long calculateCounter(int period) {
        return this.currentTimeMillis / TimeUnit.SECONDS.toMillis(period);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 \u00132\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00008TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lio/unico/unicosdkbase/totp/TOTP$Builder;", "Lio/unico/unicosdkbase/totp/OTP$Builder;", "Lio/unico/unicosdkbase/totp/TOTP;", "secret", "", "currentTimeMillis", "", "([BJ)V", "period", "", "getPeriod", "()I", "setPeriod", "(I)V", "topBuilder", "getTopBuilder", "()Lio/unico/unicosdkbase/totp/TOTP$Builder;", "build", "withPeriod", "Companion", "totp_release"})
    public static final class Builder
    extends OTP.Builder<TOTP, Builder> {
        @NotNull
        private static final Companion Companion = new Companion(null);
        private final long currentTimeMillis;
        private int period;
        @Deprecated
        private static final int DEFAULT_PERIOD = 30;

        public Builder(@NotNull byte[] secret, long currentTimeMillis) {
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            super(secret);
            this.currentTimeMillis = currentTimeMillis;
            this.period = 30;
        }

        public /* synthetic */ Builder(byte[] byArray, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = System.currentTimeMillis();
            }
            this(byArray, l);
        }

        public final int getPeriod() {
            return this.period;
        }

        public final void setPeriod(int n) {
            this.period = n;
        }

        @NotNull
        public final Builder withPeriod(int period) {
            if (!(period >= 1)) {
                boolean bl = false;
                String string = "Period must be at least 1 second";
                throw new IllegalArgumentException(string.toString());
            }
            this.period = period;
            return this;
        }

        @Override
        @NotNull
        public TOTP build() {
            return new TOTP(this, this.currentTimeMillis);
        }

        @Override
        @NotNull
        protected Builder getTopBuilder() {
            return this;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/unico/unicosdkbase/totp/TOTP$Builder$Companion;", "", "()V", "DEFAULT_PERIOD", "", "totp_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

