/*
 * Decompiled with CFR 0.152.
 */
package io.unico.logger.data.repository;

import io.unico.logger.domain.entities.LogProvider;
import io.unico.logger.domain.repository.LogProviderRepository;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/unico/logger/data/repository/DefaultLogProviderRepository;", "Lio/unico/logger/domain/repository/LogProviderRepository;", "providers", "", "", "Lio/unico/logger/domain/entities/LogProvider;", "(Ljava/util/Map;)V", "getAll", "", "insert", "provider", "remove", "", "id", "UnicoSdkLogger_release"})
public final class DefaultLogProviderRepository
implements LogProviderRepository {
    @NotNull
    private final Map<String, LogProvider> providers;

    public DefaultLogProviderRepository(@NotNull Map<String, LogProvider> providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        this.providers = providers;
    }

    @Override
    @NotNull
    public LogProvider insert(@NotNull LogProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Map<String, LogProvider> map = this.providers;
        String string = Reflection.getOrCreateKotlinClass(provider.getClass()).getSimpleName();
        if (string == null) {
            string = String.valueOf(provider.hashCode());
        }
        map.put(string, provider);
        return provider;
    }

    @Override
    @NotNull
    public List<LogProvider> getAll() {
        return CollectionsKt.toList((Iterable)this.providers.values());
    }

    @Override
    public boolean remove(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.providers.remove(id) != null;
    }
}

