/*
 * Decompiled with CFR 0.152.
 */
package com.abdeveloper.library;

import android.content.Context;
import android.content.res.ColorStateList;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatCheckBox;
import android.support.v7.widget.RecyclerView;
import android.text.SpannableString;
import android.text.style.TextAppearanceSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.abdeveloper.library.MultiSelectDialog;
import com.abdeveloper.library.MultiSelectModel;
import com.abdeveloper.library.R;
import java.util.ArrayList;

class MutliSelectAdapter
extends RecyclerView.Adapter<MultiSelectDialogViewHolder> {
    private ArrayList<MultiSelectModel> mDataSet = new ArrayList();
    private String mSearchQuery = "";
    private Context mContext;

    MutliSelectAdapter(ArrayList<MultiSelectModel> dataSet, Context context) {
        this.mDataSet = dataSet;
        this.mContext = context;
    }

    public MultiSelectDialogViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.multi_select_item, parent, false);
        return new MultiSelectDialogViewHolder(view);
    }

    public void onBindViewHolder(final MultiSelectDialogViewHolder holder, int position) {
        if (!this.mSearchQuery.equals("") && this.mSearchQuery.length() > 1) {
            this.setHighlightedText(position, holder.dialog_name_item);
        } else {
            holder.dialog_name_item.setText((CharSequence)this.mDataSet.get(position).getName());
        }
        if (this.mDataSet.get(position).getSelected().booleanValue() && !MultiSelectDialog.selectedIdsForCallback.contains(this.mDataSet.get(position).getId())) {
            MultiSelectDialog.selectedIdsForCallback.add(this.mDataSet.get(position).getId());
        }
        if (this.checkForSelection(this.mDataSet.get(position).getId())) {
            holder.dialog_item_checkbox.setChecked(true);
        } else {
            holder.dialog_item_checkbox.setChecked(false);
        }
        holder.main_container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!holder.dialog_item_checkbox.isChecked()) {
                    MultiSelectDialog.selectedIdsForCallback.add(((MultiSelectModel)MutliSelectAdapter.this.mDataSet.get(holder.getAdapterPosition())).getId());
                    holder.dialog_item_checkbox.setChecked(true);
                    ((MultiSelectModel)MutliSelectAdapter.this.mDataSet.get(holder.getAdapterPosition())).setSelected(true);
                    MutliSelectAdapter.this.notifyItemChanged(holder.getAdapterPosition());
                } else {
                    MutliSelectAdapter.this.removeFromSelection(((MultiSelectModel)MutliSelectAdapter.this.mDataSet.get(holder.getAdapterPosition())).getId());
                    holder.dialog_item_checkbox.setChecked(false);
                    ((MultiSelectModel)MutliSelectAdapter.this.mDataSet.get(holder.getAdapterPosition())).setSelected(false);
                    MutliSelectAdapter.this.notifyItemChanged(holder.getAdapterPosition());
                }
            }
        });
    }

    private void setHighlightedText(int position, TextView textview) {
        String name = this.mDataSet.get(position).getName();
        SpannableString str = new SpannableString((CharSequence)name);
        int endLength = name.toLowerCase().indexOf(this.mSearchQuery) + this.mSearchQuery.length();
        ColorStateList highlightedColor = new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{ContextCompat.getColor((Context)this.mContext, (int)R.color.colorAccent)});
        TextAppearanceSpan textAppearanceSpan = new TextAppearanceSpan(null, 0, -1, highlightedColor, null);
        str.setSpan((Object)textAppearanceSpan, name.toLowerCase().indexOf(this.mSearchQuery), endLength, 33);
        textview.setText((CharSequence)str);
    }

    private void removeFromSelection(Integer id2) {
        for (int i = 0; i < MultiSelectDialog.selectedIdsForCallback.size(); ++i) {
            if (id2 != MultiSelectDialog.selectedIdsForCallback.get(i)) continue;
            MultiSelectDialog.selectedIdsForCallback.remove(i);
        }
    }

    private boolean checkForSelection(Integer id2) {
        for (int i = 0; i < MultiSelectDialog.selectedIdsForCallback.size(); ++i) {
            if (id2 != MultiSelectDialog.selectedIdsForCallback.get(i)) continue;
            return true;
        }
        return false;
    }

    public String getDataString() {
        String data = "";
        for (int i = 0; i < this.mDataSet.size(); ++i) {
            if (!this.checkForSelection(this.mDataSet.get(i).getId())) continue;
            data = data + ", " + this.mDataSet.get(i).getName();
        }
        if (data.length() > 0) {
            return data.substring(1);
        }
        return "";
    }

    public ArrayList<String> getSelectedNameList() {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < this.mDataSet.size(); ++i) {
            if (!this.checkForSelection(this.mDataSet.get(i).getId())) continue;
            names.add(this.mDataSet.get(i).getName());
        }
        return names;
    }

    public int getItemCount() {
        return this.mDataSet.size();
    }

    void setData(ArrayList<MultiSelectModel> data, String query, MutliSelectAdapter mutliSelectAdapter) {
        this.mDataSet = data;
        this.mSearchQuery = query;
        mutliSelectAdapter.notifyDataSetChanged();
    }

    class MultiSelectDialogViewHolder
    extends RecyclerView.ViewHolder {
        private TextView dialog_name_item;
        private AppCompatCheckBox dialog_item_checkbox;
        private LinearLayout main_container;

        MultiSelectDialogViewHolder(View view) {
            super(view);
            this.dialog_name_item = (TextView)view.findViewById(R.id.dialog_item_name);
            this.dialog_item_checkbox = (AppCompatCheckBox)view.findViewById(R.id.dialog_item_checkbox);
            this.main_container = (LinearLayout)view.findViewById(R.id.main_container);
        }
    }
}

