/*
 * Decompiled with CFR 0.152.
 */
package com.xtivia.sgdxp.core;

import com.xtivia.sgdxp.core.BaseContext;
import com.xtivia.sgdxp.core.IContext;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ResourceInfo;

public class ResourceContext
extends BaseContext
implements IContext {
    private HttpServletRequest request;
    private HashSet updates = new HashSet();

    public ResourceContext(HttpServletRequest request, Map pathParameters, ResourceInfo resourceInfo) {
        this.request = request;
        super.put("_request_", request);
        super.put("_session_", request.getSession());
        super.put("_servlet_context_", request.getSession().getServletContext());
        super.put("_pathparams_", pathParameters);
        super.put("_resourceclass_", resourceInfo.getClass());
        super.put("_resourcemethod_", resourceInfo.getResourceMethod());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        Object o = super.get(key);
        if (o != null) {
            return o;
        }
        Map pathParameters = (Map)super.get("_pathparams_");
        if (pathParameters != null && (o = pathParameters.get(key)) != null) {
            List list = (List)o;
            if (list.size() > 1) {
                return list;
            }
            return list.get(0);
        }
        o = this.request.getAttribute(key.toString());
        if (o != null) {
            return o;
        }
        o = this.request.getParameterValues(key.toString());
        if (o != null) {
            String[] arr = (String[])o;
            if (arr.length > 1) {
                return arr;
            }
            return arr[0];
        }
        o = this.request.getSession().getAttribute(key.toString());
        if (o != null) {
            return o;
        }
        o = this.request.getSession().getServletContext().getAttribute(key.toString());
        return o;
    }

    @Override
    public Object put(Object key, Object value) {
        this.updates.add(key);
        return super.put(key, value);
    }

    public Set getUpdates() {
        return this.updates;
    }

    public void unload() {
        Set updates = this.getUpdates();
        for (String key : updates) {
            Object value = super.get(key);
            if (value == null) continue;
            this.request.setAttribute(key, value);
        }
    }
}

