/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.easyxls.common;

import com.github.abel533.easyxls.bean.ExcelConfig;
import com.github.abel533.easyxls.bean.Field;
import com.github.abel533.easyxls.common.DateUtil;
import com.github.abel533.easyxls.common.FieldUtil;
import com.github.abel533.easyxls.common.XmlConfig;
import com.github.abel533.easyxls.generater.GenXml;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.DateCell;
import jxl.ErrorCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;

public class XlsUtil {
    public static final String EXCEL = ".xls";
    private static Map<String, ExcelConfig> cache = new HashMap<String, ExcelConfig>();

    private static ExcelConfig getEasyExcel(String xmlPath) {
        ExcelConfig easyExcel = cache.get(xmlPath);
        if (easyExcel == null) {
            easyExcel = XmlConfig.getXmlConfig(xmlPath);
        }
        if (easyExcel == null) {
            throw new RuntimeException("\u65e0\u6cd5\u83b7\u53d6xml\u914d\u7f6e\u6587\u4ef6!");
        }
        if (easyExcel.getCache() == null || easyExcel.getCache().booleanValue()) {
            cache.put(xmlPath, easyExcel);
        }
        return easyExcel;
    }

    public static void openGenerater() {
        GenXml.run();
    }

    public static List<?> xls2List(String xmlPath, File xlsFile) throws Exception {
        Workbook wb = null;
        List<?> list = null;
        try {
            wb = Workbook.getWorkbook((File)xlsFile);
            list = XlsUtil.workbook2List(xmlPath, wb);
        }
        catch (Exception e) {
            throw new Exception("\u8f6c\u6362xls\u51fa\u9519:" + e.getMessage());
        }
        finally {
            if (wb != null) {
                wb.close();
            }
        }
        return list;
    }

    public static List<?> xls2List(ExcelConfig config, File xlsFile) throws Exception {
        Workbook wb = null;
        List<?> list = null;
        try {
            wb = Workbook.getWorkbook((File)xlsFile);
            list = XlsUtil.workbook2List(config, wb);
        }
        catch (Exception e) {
            throw new Exception("\u8f6c\u6362xls\u51fa\u9519:" + e.getMessage());
        }
        finally {
            if (wb != null) {
                wb.close();
            }
        }
        return list;
    }

    public static List<?> xls2List(String xmlPath, InputStream inputStream) throws Exception {
        Workbook wb = null;
        List<?> list = null;
        try {
            wb = Workbook.getWorkbook((InputStream)inputStream);
            list = XlsUtil.workbook2List(xmlPath, wb);
        }
        catch (Exception e) {
            throw new Exception("\u8f6c\u6362xls\u51fa\u9519:" + e.getMessage());
        }
        finally {
            if (wb != null) {
                wb.close();
            }
        }
        return list;
    }

    public static List<?> xls2List(ExcelConfig config, InputStream inputStream) throws Exception {
        Workbook wb = null;
        List<?> list = null;
        try {
            wb = Workbook.getWorkbook((InputStream)inputStream);
            list = XlsUtil.workbook2List(config, wb);
        }
        catch (Exception e) {
            throw new Exception("\u8f6c\u6362xls\u51fa\u9519:" + e.getMessage());
        }
        finally {
            if (wb != null) {
                wb.close();
            }
        }
        return list;
    }

    public static List<?> workbook2List(String xmlPath, Workbook wb) throws Exception {
        ExcelConfig config = XlsUtil.getEasyExcel(xmlPath);
        return XlsUtil.workbook2List(config, wb);
    }

    public static List<?> workbook2List(ExcelConfig config, Workbook wb) throws Exception {
        int length;
        String[] names = config.getNames();
        String[] types = config.getTypes();
        Field key = config.getKey();
        ArrayList list = new ArrayList();
        Sheet sheet = wb.getSheet(config.getSheetNum());
        int n = length = sheet.getColumns() < names.length ? sheet.getColumns() : names.length;
        int rowLength = sheet.getRows() < config.getMaxRow() ? sheet.getRows() : (config.getMaxRow() > 0 ? config.getMaxRow() + config.getStartRow() : sheet.getRows());
        for (int i = config.getStartRow(); i < rowLength; ++i) {
            Class<?> clazz = Class.forName(config.getClazz());
            HashMap obj = null;
            obj = Map.class.isAssignableFrom(clazz) ? new HashMap() : (HashMap)clazz.newInstance();
            for (int j = 0; j < length; ++j) {
                XlsUtil.setValue(obj, names[j], types[j], sheet.getCell(j, i));
            }
            if (key != null && (key.get(obj) == null || "".equals(String.valueOf(key.get(obj))))) break;
            list.add(obj);
        }
        return list;
    }

    private static Object getCellValue(Cell cell) throws Exception {
        Object value = null;
        value = cell instanceof ErrorCell ? null : (cell instanceof LabelCell ? ((LabelCell)cell).getString() : (cell instanceof NumberCell ? Double.valueOf(((NumberCell)cell).getValue()) : (cell instanceof DateCell ? ((DateCell)cell).getDate() : (cell instanceof BooleanCell ? Boolean.valueOf(((BooleanCell)cell).getValue()) : cell.getContents()))));
        return value;
    }

    private static void setValue(Object obj, String fieldName, String type, Cell cell) throws Exception {
        Field field;
        Object val = null;
        Object v = XlsUtil.getCellValue(cell);
        if (v != null) {
            if (Object.class.getCanonicalName().equals(type)) {
                val = v;
            } else if (v.getClass().getName().equals(type)) {
                val = v;
            } else {
                String value = v.toString();
                if (value != null && !value.trim().equals("")) {
                    value = value.trim();
                    if (type.equals("int")) {
                        val = new BigDecimal(value).intValue();
                    } else if (type.equals("long")) {
                        val = new BigDecimal(value).longValue();
                    } else if (type.equals("float")) {
                        val = Float.valueOf(new BigDecimal(value).floatValue());
                    } else if (type.equals("double")) {
                        val = new BigDecimal(value).doubleValue();
                    } else if (type.equals("boolean")) {
                        val = Boolean.parseBoolean(value);
                    } else {
                        Class<?> clazz = Class.forName(type);
                        if (!clazz.equals(String.class)) {
                            if (clazz.equals(Date.class)) {
                                val = DateUtil.smartFormat(value);
                            } else if (clazz.equals(Integer.class)) {
                                val = new BigDecimal(value).intValue();
                            } else if (clazz.equals(Long.class)) {
                                val = new BigDecimal(value).longValue();
                            } else if (clazz.equals(Float.class)) {
                                val = Float.valueOf(new BigDecimal(value).floatValue());
                            } else if (clazz.equals(Double.class)) {
                                val = new BigDecimal(value).doubleValue();
                            } else if (clazz.equals(Boolean.class)) {
                                val = Boolean.parseBoolean(value);
                            } else if (clazz.equals(BigDecimal.class)) {
                                val = new BigDecimal(value);
                            }
                        } else {
                            val = value;
                        }
                    }
                }
            }
        }
        if ((field = FieldUtil.getField(obj, fieldName)) != null) {
            field.set(obj, val);
        }
    }

    public static boolean list2Xls(List<?> list, String xmlPath, String filePath, String fileName) throws Exception {
        File file = new File(filePath);
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("\u521b\u5efa\u5bfc\u51fa\u76ee\u5f55\u5931\u8d25!");
        }
        try {
            ExcelConfig config = XlsUtil.getEasyExcel(xmlPath);
            XlsUtil.list2Xls(config, list, filePath, fileName);
        }
        catch (Exception e1) {
            return false;
        }
        return true;
    }

    public static boolean list2Xls(ExcelConfig config, List<?> list, String filePath, String fileName) throws Exception {
        File file = new File(filePath);
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("\u521b\u5efa\u5bfc\u51fa\u76ee\u5f55\u5931\u8d25!");
        }
        try {
            String[] header = config.getHeaders();
            String[] names = config.getNames();
            if (!fileName.toLowerCase().endsWith(EXCEL)) {
                fileName = fileName + EXCEL;
            }
            File excelFile = new File(filePath + "/" + fileName);
            WritableWorkbook wb = Workbook.createWorkbook((File)excelFile);
            String sheetName = config.getSheet() != null && !config.getSheet().equals("") ? config.getSheet() : "sheet" + config.getSheetNum();
            WritableSheet sheet = wb.createSheet(sheetName, 0);
            int row = 0;
            int column = 0;
            int rowadd = 0;
            if (config.getHeader().booleanValue()) {
                for (column = 0; column < header.length; ++column) {
                    sheet.addCell((WritableCell)new Label(column, row + rowadd, header[column]));
                    if (config.getColumn(column).getWidth() == null) continue;
                    sheet.setColumnView(column, config.getColumn(column).getWidth() / 7);
                }
                ++rowadd;
            }
            for (row = 0; row < list.size(); ++row) {
                Object rowData = list.get(row);
                String[] values = XlsUtil.getObjValues(rowData, names);
                for (column = 0; column < values.length; ++column) {
                    sheet.addCell((WritableCell)new Label(column, row + rowadd, values[column]));
                }
            }
            wb.write();
            wb.close();
        }
        catch (Exception e1) {
            return false;
        }
        return true;
    }

    private static String[] getObjValues(Object source, String ... fieldnames) throws Exception {
        String[] results = new String[fieldnames.length];
        for (int i = 0; i < fieldnames.length; ++i) {
            Field field = FieldUtil.getField(source, fieldnames[i]);
            if (field == null) continue;
            Object obj = field.get(source);
            String value = obj == null ? "" : (obj instanceof Date ? DateUtil.smartFormat((Date)obj) : String.valueOf(obj));
            results[i] = value;
        }
        return results;
    }
}

