/*
 * Decompiled with CFR 0.152.
 */
package com.github.abel533.easyxls.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateUtil {
    public static final String Y_M_D = "yyyy-MM-dd";
    public static final String Y_M_D_HM = "yyyy-MM-dd HH:mm";
    public static final String Y_M_D_HMS = "yyyy-MM-dd HH:mm:ss";
    public static final String YMD = "yyyyMMdd";
    public static final String YMDHM = "yyyyMMddHHmm";
    public static final String YMDHMS = "yyyyMMddHHmmss";
    public static final String ymd = "yyyy/MM/dd";
    public static final String ymd_HM = "yyyy/MM/dd HH:mm";
    public static final String ymd_HMS = "yyyy/MM/dd HH:mm:ss";

    public static String smartFormat(Date date) {
        String dateStr = null;
        if (date == null) {
            dateStr = "";
        } else {
            try {
                dateStr = DateUtil.formatDate(date, Y_M_D_HMS);
                if (dateStr.endsWith(" 00:00:00")) {
                    dateStr = dateStr.substring(0, 10);
                } else if (dateStr.endsWith("00:00")) {
                    dateStr = dateStr.substring(0, 16);
                } else if (dateStr.endsWith(":00")) {
                    dateStr = dateStr.substring(0, 16);
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("\u8f6c\u6362\u65e5\u671f\u5931\u8d25: " + ex.getMessage(), ex);
            }
        }
        return dateStr;
    }

    public static Date smartFormat(String text) {
        Date date;
        block15: {
            date = null;
            try {
                if (text == null || text.length() == 0) {
                    date = null;
                    break block15;
                }
                int length = text.length();
                if (text.indexOf("-") > 0) {
                    if (length == 10) {
                        date = DateUtil.formatStringToDate(text, Y_M_D);
                        break block15;
                    }
                    if (length == 16) {
                        date = DateUtil.formatStringToDate(text, Y_M_D_HM);
                        break block15;
                    }
                    if (length == 19) {
                        date = DateUtil.formatStringToDate(text, Y_M_D_HMS);
                        break block15;
                    }
                    throw new IllegalArgumentException("\u65e5\u671f\u957f\u5ea6\u4e0d\u7b26\u5408\u8981\u6c42!");
                }
                if (text.indexOf("/") > 0) {
                    if (length == 10) {
                        date = DateUtil.formatStringToDate(text, ymd);
                        break block15;
                    }
                    if (length == 16) {
                        date = DateUtil.formatStringToDate(text, ymd_HM);
                        break block15;
                    }
                    if (length == 19) {
                        date = DateUtil.formatStringToDate(text, ymd_HMS);
                        break block15;
                    }
                    throw new IllegalArgumentException("\u65e5\u671f\u957f\u5ea6\u4e0d\u7b26\u5408\u8981\u6c42!");
                }
                if (length == 10) {
                    date = DateUtil.formatStringToDate(text, YMD);
                    break block15;
                }
                if (length == 13) {
                    date = new Date(Long.parseLong(text));
                    break block15;
                }
                if (length == 16) {
                    date = DateUtil.formatStringToDate(text, YMDHM);
                    break block15;
                }
                if (length == 19) {
                    date = DateUtil.formatStringToDate(text, YMDHMS);
                    break block15;
                }
                throw new IllegalArgumentException("\u65e5\u671f\u957f\u5ea6\u4e0d\u7b26\u5408\u8981\u6c42!");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("\u65e5\u671f\u683c\u5f0f\u9519\u8bef!");
            }
        }
        return date;
    }

    public static String getNow(String format) throws Exception {
        return DateUtil.formatDate(new Date(), format);
    }

    public static String formatDate(Date argDate, String argFormat) throws Exception {
        if (argDate == null) {
            throw new Exception("\u53c2\u6570[\u65e5\u671f]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (argFormat == null || argFormat.length() == 0) {
            argFormat = Y_M_D;
        }
        SimpleDateFormat sdfFrom = new SimpleDateFormat(argFormat);
        return sdfFrom.format(argDate).toString();
    }

    public static Date formatStringToDate(String argDateStr, String argFormat) throws Exception {
        if (argDateStr == null || argDateStr.trim().length() < 1) {
            throw new Exception("\u53c2\u6570[\u65e5\u671f]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String strFormat = argFormat;
        if (strFormat == null || strFormat.length() == 0) {
            strFormat = Y_M_D;
            if (argDateStr.length() > 16) {
                strFormat = Y_M_D_HMS;
            } else if (argDateStr.length() > 10) {
                strFormat = Y_M_D_HM;
            }
        }
        SimpleDateFormat sdfFormat = new SimpleDateFormat(strFormat);
        sdfFormat.setLenient(false);
        try {
            return sdfFormat.parse(argDateStr);
        }
        catch (ParseException e) {
            throw new Exception(e);
        }
    }
}

