/*
 * Decompiled with CFR 0.152.
 */
package com.github.aakira.compoundicontextview;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.Dimension;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.text.TextUtilsCompat;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import com.github.aakira.compoundicontextview.R;
import java.util.Locale;

public class CompoundIconTextView
extends AppCompatTextView {
    public static final int UNDEFINED_RESOURCE = 43981;
    private static final int INDEX_LEFT = 0;
    private static final int INDEX_TOP = 1;
    private static final int INDEX_RIGHT = 2;
    private static final int INDEX_BOTTOM = 3;
    private static final String VECTOR_DRAWABLE_CLAZZ_NAME = "android.graphics.drawable.VectorDrawable";
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private static final int[] EMPTY_STATE_SET = new int[0];
    private int iconWidth = 43981;
    private int iconHeight = 43981;
    private int iconColor = 43981;
    private Drawable[] drawables = new Drawable[4];
    private int[] drawableResIds = new int[4];

    public CompoundIconTextView(Context context) {
        this(context, null);
    }

    public CompoundIconTextView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompoundIconTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray a = null;
        try {
            a = context.obtainStyledAttributes(attrs, R.styleable.CompoundIconTextView, defStyleAttr, 0);
            this.drawableResIds[0] = a.getResourceId(R.styleable.CompoundIconTextView_cit_drawableLeft, 43981);
            this.drawableResIds[1] = a.getResourceId(R.styleable.CompoundIconTextView_cit_drawableTop, 43981);
            this.drawableResIds[2] = a.getResourceId(R.styleable.CompoundIconTextView_cit_drawableRight, 43981);
            this.drawableResIds[3] = a.getResourceId(R.styleable.CompoundIconTextView_cit_drawableBottom, 43981);
            if (a.hasValue(R.styleable.CompoundIconTextView_cit_drawableStart)) {
                this.drawableResIds[this.isRtl() ? 2 : 0] = a.getResourceId(R.styleable.CompoundIconTextView_cit_drawableStart, 43981);
            }
            if (a.hasValue(R.styleable.CompoundIconTextView_cit_drawableEnd)) {
                this.drawableResIds[this.isRtl() ? 0 : 2] = a.getResourceId(R.styleable.CompoundIconTextView_cit_drawableEnd, 43981);
            }
            this.iconWidth = a.getDimensionPixelSize(R.styleable.CompoundIconTextView_cit_iconWidth, 43981);
            this.iconHeight = a.getDimensionPixelSize(R.styleable.CompoundIconTextView_cit_iconHeight, 43981);
            this.iconColor = a.getColor(R.styleable.CompoundIconTextView_cit_iconColor, 43981);
        }
        finally {
            if (a != null) {
                a.recycle();
            }
        }
        if (this.drawableResIds[0] == 43981 && this.drawableResIds[1] == 43981 && this.drawableResIds[2] == 43981 && this.drawableResIds[3] == 43981) {
            return;
        }
        this.checkHasIconSize();
        this.makeDrawableIcons();
        this.updateIcons();
    }

    public void setVectorDrawableLeft(@DrawableRes int resourceId) {
        this.setVectorDrawable(0, resourceId);
    }

    public void setVectorDrawableTop(@DrawableRes int resourceId) {
        this.setVectorDrawable(1, resourceId);
    }

    public void setVectorDrawableRight(@DrawableRes int resourceId) {
        this.setVectorDrawable(2, resourceId);
    }

    public void setVectorDrawableBottom(@DrawableRes int resourceId) {
        this.setVectorDrawable(3, resourceId);
    }

    public void setVectorDrawableStart(@DrawableRes int resourceId) {
        this.setVectorDrawable(this.isRtl() ? 2 : 0, resourceId);
    }

    public void setVectorDrawableEnd(@DrawableRes int resourceId) {
        this.setVectorDrawable(this.isRtl() ? 0 : 2, resourceId);
    }

    public void setIconColorResource(@ColorRes int resId) {
        this.setIconColor(ContextCompat.getColor((Context)this.getContext(), (int)resId));
    }

    public void setIconColor(@ColorInt int color) {
        for (int i = 0; i < this.drawables.length; ++i) {
            this.setColorFilter(i, color);
        }
        this.iconColor = color;
        this.updateIcons();
    }

    public void setIconSizeResource(@DimenRes int widthRes, @DimenRes int heightRes) {
        this.setIconSize(this.getContext().getResources().getDimensionPixelSize(widthRes), this.getContext().getResources().getDimensionPixelSize(heightRes));
    }

    public void setIconSize(@Dimension int width, @Dimension int height) {
        this.iconWidth = width;
        this.iconHeight = height;
        this.makeDrawableIcons();
        this.updateIcons();
    }

    private void checkHasIconSize() {
        if (this.iconWidth == 43981 || this.iconHeight == 43981) {
            throw new IllegalStateException("You must set the 'iconSize'");
        }
    }

    private void makeDrawableIcons() {
        for (int i = 0; i < this.drawables.length; ++i) {
            if (this.drawableResIds[i] == 43981) continue;
            this.setDrawable(i, this.drawableResIds[i]);
        }
    }

    private void setColorFilter(int index, @ColorInt int color) {
        if (this.drawables[index] != null) {
            this.drawables[index].setColorFilter(color, PorterDuff.Mode.SRC_IN);
        }
    }

    private void setVectorDrawable(int index, @DrawableRes int resourceId) {
        if (resourceId == 43981) {
            this.drawables[index] = null;
            this.drawableResIds[index] = 43981;
            this.updateIcons();
        } else {
            this.checkHasIconSize();
            this.setDrawable(index, resourceId);
            this.drawableResIds[index] = resourceId;
            this.updateIcons();
        }
    }

    private void updateIcons() {
        this.setCompoundDrawablesWithIntrinsicBounds(this.drawables[0], this.drawables[1], this.drawables[2], this.drawables[3]);
    }

    private void setDrawable(int index, @DrawableRes int resourceId) {
        this.drawables[index] = this.resource2VectorDrawable(resourceId, this.iconColor, this.iconWidth, this.iconHeight);
    }

    private Drawable resource2VectorDrawable(@DrawableRes int resourceId, @ColorInt int iconColor, int iconWidth, int iconHeight) {
        Context context = this.getContext();
        Drawable drawable = AppCompatResources.getDrawable((Context)context, (int)resourceId);
        if (drawable == null) {
            throw new Resources.NotFoundException("Resource not found : %s." + resourceId);
        }
        CompoundIconTextView.fixDrawable(drawable);
        if (iconColor != 43981) {
            DrawableCompat.setTint((Drawable)drawable, (int)iconColor);
            DrawableCompat.setTintMode((Drawable)drawable, (PorterDuff.Mode)PorterDuff.Mode.SRC_IN);
        }
        return new BitmapDrawable(context.getResources(), Bitmap.createScaledBitmap((Bitmap)CompoundIconTextView.drawable2Bitmap(drawable, iconWidth, iconHeight), (int)iconWidth, (int)iconHeight, (boolean)true));
    }

    private static Bitmap drawable2Bitmap(Drawable drawable, int iconWidth, int iconHeight) {
        Bitmap bitmap = Bitmap.createBitmap((int)iconWidth, (int)iconHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    private static void fixDrawable(@NonNull Drawable drawable) {
        if (Build.VERSION.SDK_INT == 21 && VECTOR_DRAWABLE_CLAZZ_NAME.equals(drawable.getClass().getName())) {
            CompoundIconTextView.fixVectorDrawableTinting(drawable);
        }
    }

    private static void fixVectorDrawableTinting(Drawable drawable) {
        int[] originalState = drawable.getState();
        if (originalState.length == 0) {
            drawable.setState(CHECKED_STATE_SET);
        } else {
            drawable.setState(EMPTY_STATE_SET);
        }
        drawable.setState(originalState);
    }

    private boolean isRtl() {
        Resources resources = this.getContext().getResources();
        Locale locale = Build.VERSION.SDK_INT >= 24 ? resources.getConfiguration().getLocales().getFirstMatch(resources.getAssets().getLocales()) : resources.getConfiguration().locale;
        return TextUtilsCompat.getLayoutDirectionFromLocale((Locale)locale) == 1;
    }
}

