/*
 * Decompiled with CFR 0.152.
 */
package in.aabhasjindal.otptextview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.res.ResourcesCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import in.aabhasjindal.otptextview.R;
import in.aabhasjindal.otptextview.Utils;

public class ItemView
extends FrameLayout {
    public static final int ACTIVE = 1;
    public static final int INACTIVE = 0;
    public static final int ERROR = -1;
    public static final int SUCCESS = 2;
    private static final float DEFAULT_BAR_HEIGHT = 2.0f;
    private static final float DEFAULT_OTP_TEXT_SIZE = 24.0f;
    private static final int DEFAULT_BAR_PADDING = 2;
    private Context context;
    private TextView textView;
    private View view;
    private int barActiveColor;
    private int barInactiveColor;
    private int barErrorColor;
    private int barSuccessColor;

    public ItemView(@NonNull Context context) {
        super(context);
        this.context = context;
        this.init(null);
    }

    public ItemView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init(attrs);
    }

    public ItemView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.init(attrs);
    }

    @SuppressLint(value={"CustomViewStyleable"})
    private void init(AttributeSet attrs) {
        TypedArray styles = this.getContext().obtainStyledAttributes(attrs, R.styleable.OtpTextView);
        this.generateViews(styles);
        styles.recycle();
    }

    private void generateViews(TypedArray styles) {
        int margin;
        float defaultHeight = Utils.getPixels(this.context, 2.0f);
        float defaultOtpTextSize = Utils.getPixels(this.context, 24.0f);
        int textColor = styles.getColor(R.styleable.OtpTextView_android_textColor, ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.black, null));
        float barHeight = styles.getDimension(R.styleable.OtpTextView_bar_height, defaultHeight);
        int barPadding = styles.getInt(R.styleable.OtpTextView_bar_padding, 2);
        Float otpTextSize = Float.valueOf(styles.getDimension(R.styleable.OtpTextView_otp_text_size, defaultOtpTextSize));
        this.barActiveColor = styles.getColor(R.styleable.OtpTextView_bar_active_color, ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.black, null));
        this.barInactiveColor = styles.getColor(R.styleable.OtpTextView_bar_inactive_color, ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.grey, null));
        this.barErrorColor = styles.getColor(R.styleable.OtpTextView_bar_error_color, ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.red, null));
        this.barSuccessColor = styles.getColor(R.styleable.OtpTextView_bar_success_color, ResourcesCompat.getColor((Resources)this.context.getResources(), (int)R.color.black, null));
        FrameLayout.LayoutParams textViewParams = new FrameLayout.LayoutParams(-1, -1);
        textViewParams.gravity = 17;
        this.textView = new TextView(this.context);
        this.textView.setGravity(17);
        this.textView.setTextColor(textColor);
        this.textView.setTextSize(0, otpTextSize.floatValue());
        this.addView((View)this.textView, (ViewGroup.LayoutParams)textViewParams);
        FrameLayout.LayoutParams barViewParams = new FrameLayout.LayoutParams(-1, (int)barHeight);
        barViewParams.gravity = 80;
        barViewParams.leftMargin = margin = Utils.getPixels(this.context, barPadding);
        barViewParams.rightMargin = margin;
        this.view = new View(this.context);
        this.addView(this.view, (ViewGroup.LayoutParams)barViewParams);
    }

    public void setText(String value) {
        if (this.textView != null) {
            this.textView.setText((CharSequence)value);
        }
    }

    public void setViewState(int state) {
        if (this.view != null) {
            switch (state) {
                case 1: {
                    this.view.setBackgroundColor(this.barActiveColor);
                    break;
                }
                case 0: {
                    this.view.setBackgroundColor(this.barInactiveColor);
                    break;
                }
                case -1: {
                    this.view.setBackgroundColor(this.barErrorColor);
                    break;
                }
                case 2: {
                    this.view.setBackgroundColor(this.barSuccessColor);
                }
            }
        }
    }
}

