/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.utils;

import android.app.Activity;
import android.net.Uri;
import android.util.Log;
import androidx.core.util.Pair;
import com.gowtham.library.utils.TrimmerUtils;
import com.gowtham.library.utils.VideoRes;
import java.util.ArrayList;
import java.util.List;
import java.util.SequencedCollection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u001a\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t\u00a8\u0006\u000e"}, d2={"fromDisplayName", "Lcom/gowtham/library/utils/VideoRes;", "name", "", "getDownScaleRatio", "", "context", "Landroid/app/Activity;", "fileUri", "Landroid/net/Uri;", "targetRes", "getVideoResNames", "", "inputUri", "library_release"})
@SourceDebugExtension(value={"SMAP\nVideoRes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoRes.kt\ncom/gowtham/library/utils/VideoResKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,66:1\n1282#2,2:67\n*S KotlinDebug\n*F\n+ 1 VideoRes.kt\ncom/gowtham/library/utils/VideoResKt\n*L\n13#1:67,2\n*E\n"})
public final class VideoResKt {
    @Nullable
    public static final VideoRes fromDisplayName(@NotNull String name) {
        VideoRes videoRes;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            VideoRes[] $this$firstOrNull$iv = VideoRes.values();
            boolean $i$f$firstOrNull = false;
            int n = $this$firstOrNull$iv.length;
            for (int i = 0; i < n; ++i) {
                VideoRes element$iv;
                VideoRes it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)name)) continue;
                videoRes = element$iv;
                break block1;
            }
            videoRes = null;
        }
        return videoRes;
    }

    @NotNull
    public static final List<String> getVideoResNames(@NotNull Activity context, @NotNull Uri inputUri) {
        Pair<Integer, Integer> wh;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)inputUri, (String)"inputUri");
        Pair<Integer, Integer> pair = wh = TrimmerUtils.getVideoRes(context, inputUri);
        Intrinsics.checkNotNull(pair);
        Object object = pair.first;
        Intrinsics.checkNotNull((Object)object);
        int n = ((Number)object).intValue();
        Object object2 = wh.second;
        Intrinsics.checkNotNull((Object)object2);
        VideoRes inputRes = TrimmerUtils.classifyResolution(n, ((Number)object2).intValue());
        if (inputRes != VideoRes.LOWER_SD) {
            ArrayList<String> list = new ArrayList<String>();
            for (VideoRes res : VideoRes.values()) {
                if (res.ordinal() > inputRes.ordinal() || res == VideoRes.LOWER_SD) continue;
                list.add(res.getDisplayName());
            }
            SequencedCollection sequencedCollection = list.reversed();
            Intrinsics.checkNotNullExpressionValue((Object)sequencedCollection, (String)"list.reversed()");
            return sequencedCollection;
        }
        Object[] objectArray = new String[]{inputRes.getDisplayName()};
        return CollectionsKt.arrayListOf((Object[])objectArray);
    }

    public static final float getDownScaleRatio(@NotNull Activity context, @NotNull Uri fileUri, @NotNull VideoRes targetRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fileUri, (String)"fileUri");
        Intrinsics.checkNotNullParameter((Object)((Object)targetRes), (String)"targetRes");
        Pair<Integer, Integer> widthHeightPair = TrimmerUtils.getVideoRes(context, fileUri);
        Object object = widthHeightPair.first;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"widthHeightPair.first");
        int n = ((Number)object).intValue();
        Object object2 = widthHeightPair.second;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"widthHeightPair.second");
        int resolution = RangesKt.coerceAtMost((int)n, (int)((Number)object2).intValue());
        Log.e((String)"TAG", (String)("trimVideo: resolution: " + resolution));
        Log.e((String)"TAG", (String)("trimVideo: targetRes: " + targetRes.getRes()));
        if (resolution == targetRes.getRes()) {
            return 1.0f;
        }
        float value = (float)resolution - (float)targetRes.getRes();
        return RangesKt.coerceIn((float)(value / (float)resolution), (float)0.0f, (float)1.0f);
    }
}

