/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.webkit.MimeTypeMap;
import android.widget.ImageView;
import android.widget.PopupMenu;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.Insets;
import androidx.core.util.Pair;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.effect.Presentation;
import androidx.media3.transformer.Codec;
import androidx.media3.transformer.Composition;
import androidx.media3.transformer.DefaultEncoderFactory;
import androidx.media3.transformer.EditedMediaItem;
import androidx.media3.transformer.Effects;
import androidx.media3.transformer.ExportException;
import androidx.media3.transformer.ExportResult;
import androidx.media3.transformer.ProgressHolder;
import androidx.media3.transformer.Transformer;
import androidx.media3.transformer.VideoEncoderSettings;
import com.akexorcist.localizationactivity.ui.LocalizationActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.ui.StyledPlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultDataSource;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.gowtham.library.R;
import com.gowtham.library.ui.seekbar.widgets.CrystalRangeSeekbar;
import com.gowtham.library.ui.seekbar.widgets.CrystalSeekbar;
import com.gowtham.library.utils.CompressOption;
import com.gowtham.library.utils.CustomProgressView;
import com.gowtham.library.utils.FileUtilKt;
import com.gowtham.library.utils.LocaleHelper;
import com.gowtham.library.utils.LogMessage;
import com.gowtham.library.utils.TrimVideoOptions;
import com.gowtham.library.utils.TrimmerUtils;
import com.gowtham.library.utils.VideoRes;
import com.gowtham.library.utils.VideoResKt;
import com.gowtham.library.utils.ViewUtil;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

@UnstableApi
public class ActVideoTrimmer
extends LocalizationActivity {
    private static final int PER_REQ_CODE = 115;
    private StyledPlayerView playerView;
    private ExoPlayer videoPlayer;
    private ImageView imagePlayPause;
    private ImageView[] imageViews;
    private long totalDuration;
    private Dialog dialog;
    private Uri fileUri;
    private TextView txtStartDuration;
    private TextView txtEndDuration;
    private CrystalRangeSeekbar seekbar;
    private long lastMinValue = 0L;
    private long lastMaxValue = 0L;
    private MenuItem menuDone;
    private CrystalSeekbar seekbarController;
    private boolean isValidVideo = true;
    private boolean isVideoEnded;
    private Handler seekHandler;
    private Bundle bundle;
    private ProgressBar progressBar;
    private TrimVideoOptions trimVideoOptions;
    private long currentDuration;
    private long lastClickedTime;
    private VideoRes selectedRes;
    Runnable updateSeekbar = new Runnable(){

        @Override
        public void run() {
            try {
                ActVideoTrimmer.this.currentDuration = ActVideoTrimmer.this.videoPlayer.getCurrentPosition() / 1000L;
                if (!ActVideoTrimmer.this.videoPlayer.getPlayWhenReady()) {
                    return;
                }
                if (ActVideoTrimmer.this.currentDuration <= ActVideoTrimmer.this.lastMaxValue) {
                    ActVideoTrimmer.this.seekbarController.setMinStartValue((int)ActVideoTrimmer.this.currentDuration).apply();
                } else {
                    ActVideoTrimmer.this.videoPlayer.setPlayWhenReady(false);
                }
            }
            finally {
                ActVideoTrimmer.this.seekHandler.postDelayed(ActVideoTrimmer.this.updateSeekbar, 1000L);
            }
        }
    };
    private CompressOption compressOption;
    private String outputPath;
    private String local;
    private int trimType;
    private long fixedGap;
    private long minGap;
    private long minFromGap;
    private long maxToGap;
    private boolean hidePlayerSeek;
    private boolean isAccurateCut;
    private boolean showFileLocationAlert;
    private CustomProgressView progressView;
    private String fileName;
    private TextView resChangeSpinner;
    private TextView txtFileSize;
    private boolean isCompressionEnabled;
    Transformer transformer;
    Runnable progressRunnable;
    Transformer.Listener transformerListener = new Transformer.Listener(){

        public void onCompleted(Composition composition, ExportResult result) {
            ActVideoTrimmer.this.dialog.dismiss();
            if (ActVideoTrimmer.this.showFileLocationAlert) {
                ActVideoTrimmer.this.showLocationAlert();
            } else {
                Intent intent = new Intent();
                intent.putExtra("trimmed_video_path", ActVideoTrimmer.this.outputPath);
                ActVideoTrimmer.this.setResult(-1, intent);
                ActVideoTrimmer.this.finish();
            }
        }

        public void onError(Composition composition, ExportResult result, ExportException exception) {
            if (ActVideoTrimmer.this.dialog.isShowing()) {
                ActVideoTrimmer.this.dialog.dismiss();
            }
            Log.e((String)"ActVideoTrimmer:: ", (String)("Composition onError: " + composition));
            Log.e((String)"ActVideoTrimmer:: ", (String)("ExportResult onError: " + result));
            Log.e((String)"ActVideoTrimmer:: ", (String)"ExportException onError: ", (Throwable)exception);
            ActVideoTrimmer.this.runOnUiThread(() -> Toast.makeText((Context)ActVideoTrimmer.this, (CharSequence)"Failed to trim", (int)0).show());
        }
    };
    private TextView txtProgress;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        WindowCompat.setDecorFitsSystemWindows((Window)this.getWindow(), (boolean)false);
        this.setContentView(R.layout.act_video_trimmer);
        final Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.bundle = this.getIntent().getExtras();
        Gson gson = new Gson();
        String videoOption = this.bundle.getString("trim_video_option");
        this.trimVideoOptions = (TrimVideoOptions)gson.fromJson(videoOption, TrimVideoOptions.class);
        toolbar.getNavigationIcon().setTint(ContextCompat.getColor((Context)this, (int)R.color.colorWhite));
        this.setUpToolBar(this.getSupportActionBar(), this.trimVideoOptions.title);
        toolbar.setNavigationOnClickListener(v -> this.finish());
        this.progressView = new CustomProgressView((Context)this);
        final View viewThumbnails = this.findViewById(R.id.view_thumbnails);
        final View viewTimer = this.findViewById(R.id.view_timer);
        if (Build.VERSION.SDK_INT >= 29) {
            this.getWindow().setNavigationBarContrastEnforced(false);
        }
        final View rootView = this.findViewById(0x1020002);
        ViewCompat.setOnApplyWindowInsetsListener((View)toolbar, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            @NonNull
            public WindowInsetsCompat onApplyWindowInsets(@NonNull View v, @NonNull WindowInsetsCompat insets) {
                Insets topInsets = insets.getInsets(WindowInsetsCompat.Type.displayCutout() | WindowInsetsCompat.Type.statusBars());
                Insets btmInsets = insets.getInsets(WindowInsetsCompat.Type.navigationBars());
                int left = topInsets.left != 0 ? topInsets.left : btmInsets.left;
                int right = topInsets.right != 0 ? topInsets.right : btmInsets.right;
                rootView.setPadding(left, 0, right, 0);
                toolbar.setPadding(toolbar.getPaddingLeft(), topInsets.top, toolbar.getPaddingRight(), toolbar.getPaddingBottom());
                ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)viewThumbnails.getLayoutParams();
                params.bottomMargin = btmInsets.bottom + ViewUtil.dpToPx(80);
                viewThumbnails.setLayoutParams((ViewGroup.LayoutParams)params);
                ViewGroup.MarginLayoutParams endDurationLayoutParams = (ViewGroup.MarginLayoutParams)viewTimer.getLayoutParams();
                endDurationLayoutParams.bottomMargin = btmInsets.bottom + ViewUtil.dpToPx(58);
                viewTimer.setLayoutParams((ViewGroup.LayoutParams)endDurationLayoutParams);
                return insets;
            }
        });
    }

    protected void attachBaseContext(@NotNull Context base) {
        super.attachBaseContext(LocaleHelper.onAttach(base, "en"));
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        String selectVideoRes;
        super.onPostCreate(savedInstanceState);
        this.playerView = (StyledPlayerView)this.findViewById(R.id.player_view_lib);
        this.imagePlayPause = (ImageView)this.findViewById(R.id.image_play_pause);
        this.seekbar = (CrystalRangeSeekbar)this.findViewById(R.id.range_seek_bar);
        this.txtStartDuration = (TextView)this.findViewById(R.id.txt_start_duration);
        this.txtEndDuration = (TextView)this.findViewById(R.id.txt_end_duration);
        this.seekbarController = (CrystalSeekbar)this.findViewById(R.id.seekbar_controller);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_circular);
        ImageView imageOne = (ImageView)this.findViewById(R.id.image_one);
        ImageView imageTwo = (ImageView)this.findViewById(R.id.image_two);
        ImageView imageThree = (ImageView)this.findViewById(R.id.image_three);
        ImageView imageFour = (ImageView)this.findViewById(R.id.image_four);
        ImageView imageFive = (ImageView)this.findViewById(R.id.image_five);
        ImageView imageSix = (ImageView)this.findViewById(R.id.image_six);
        ImageView imageSeven = (ImageView)this.findViewById(R.id.image_seven);
        ImageView imageEight = (ImageView)this.findViewById(R.id.image_eight);
        ImageView imageNine = (ImageView)this.findViewById(R.id.image_nine);
        ImageView imageTen = (ImageView)this.findViewById(R.id.image_ten);
        this.resChangeSpinner = (TextView)this.findViewById(R.id.txt_change_res);
        this.txtFileSize = (TextView)this.findViewById(R.id.txt_file_size);
        View viewThumbnails = this.findViewById(R.id.view_thumbnails);
        ViewUtil.systemGestureExclusionRects(this.findViewById(R.id.root_view), viewThumbnails);
        this.imageViews = new ImageView[]{imageOne, imageTwo, imageThree, imageFour, imageFive, imageSix, imageSeven, imageEight, imageNine, imageTen};
        this.seekHandler = new Handler();
        this.initPlayer();
        this.fileUri = Uri.parse((String)this.bundle.getString("trim_video_uri"));
        this.isCompressionEnabled = this.bundle.getBoolean("is_compression_enabled", true);
        if (!this.isCompressionEnabled) {
            this.resChangeSpinner.setVisibility(8);
        }
        String string2 = selectVideoRes = savedInstanceState != null ? savedInstanceState.getString("selectedRes") : "";
        if (this.checkStoragePermission()) {
            this.setDataInView(selectVideoRes);
        }
    }

    private double bitsToMbs(long bits) {
        return (double)bits / 8.0 / 1024.0 / 1024.0;
    }

    protected void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("selectedRes", this.selectedRes.getDisplayName());
    }

    private void setUpToolBar(ActionBar actionBar, String title) {
        try {
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setDisplayShowHomeEnabled(true);
            actionBar.setTitle((CharSequence)(title != null ? title : this.getString(R.string.txt_edt_video)));
        }
        catch (Exception e) {
            Log.e((String)"TAG", (String)"initPlayer: ", (Throwable)e);
        }
    }

    private void initPlayer() {
        try {
            this.videoPlayer = new ExoPlayer.Builder((Context)this).build();
            this.playerView.setResizeMode(0);
            this.playerView.setPlayer((Player)this.videoPlayer);
            AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(3).build();
            this.videoPlayer.setAudioAttributes(audioAttributes, true);
        }
        catch (Exception e) {
            Log.e((String)"TAG", (String)"initPlayer: ", (Throwable)e);
        }
    }

    private void setDataInView(String selectVideoRes) {
        try {
            this.setSelectedVideoRes(selectVideoRes);
            Runnable fileUriRunnable = () -> this.runOnUiThread(() -> {
                LogMessage.v("VideoPath:: fileUri: " + this.fileUri);
                this.progressBar.setVisibility(8);
                this.totalDuration = TrimmerUtils.getDuration((Activity)this, this.fileUri);
                this.imagePlayPause.setOnClickListener(v -> this.onVideoClicked());
                Objects.requireNonNull(this.playerView.getVideoSurfaceView()).setOnClickListener(v -> this.onVideoClicked());
                this.initTrimData();
                this.buildMediaSource();
                this.loadThumbnails();
                this.setUpSeekBar();
                this.setUpResChanger();
            });
            Executors.newSingleThreadExecutor().execute(fileUriRunnable);
        }
        catch (Exception e) {
            Log.e((String)"VideoTrimmer", (String)"", (Throwable)e);
        }
    }

    private void setSelectedVideoRes(String selectVideoRes) {
        try {
            Pair<Integer, Integer> wh = TrimmerUtils.getVideoRes((Activity)this, this.fileUri);
            this.selectedRes = selectVideoRes != null && !selectVideoRes.isEmpty() ? VideoResKt.fromDisplayName(selectVideoRes) : TrimmerUtils.classifyResolution((Integer)wh.first, (Integer)wh.second);
            this.resChangeSpinner.setText((CharSequence)this.selectedRes.getDisplayName());
        }
        catch (Exception e) {
            Log.e((String)"VideoTrimmer", (String)"", (Throwable)e);
        }
    }

    private void setUpResChanger() {
        this.resChangeSpinner.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ActVideoTrimmer.this.showResolutionMenu(ActVideoTrimmer.this.resChangeSpinner);
            }
        });
    }

    private void showResolutionMenu(TextView anchorView) {
        ContextThemeWrapper wrapperContext = new ContextThemeWrapper((Context)this, R.style.AppTheme_PopupMenu);
        PopupMenu popupMenu = new PopupMenu((Context)wrapperContext, (View)anchorView);
        Log.e((String)"TAG", (String)("showResolutionMenu: " + popupMenu.getGravity()));
        List<String> resolutions = VideoResKt.getVideoResNames((Activity)this, this.fileUri);
        for (String resolution : resolutions) {
            popupMenu.getMenu().add((CharSequence)resolution);
        }
        popupMenu.setOnMenuItemClickListener(menuItem -> {
            Log.e((String)"TAG", (String)("showResolutionMenu: " + menuItem.getTitle().toString()));
            this.selectedRes = VideoResKt.fromDisplayName(menuItem.getTitle().toString());
            anchorView.setText((CharSequence)this.selectedRes.getDisplayName());
            return true;
        });
        popupMenu.show();
    }

    private void initTrimData() {
        try {
            assert (this.trimVideoOptions != null);
            this.trimType = TrimmerUtils.getTrimType(this.trimVideoOptions.trimType);
            this.fileName = this.trimVideoOptions.fileName;
            this.hidePlayerSeek = this.trimVideoOptions.hideSeekBar;
            this.local = this.trimVideoOptions.local;
            this.compressOption = this.trimVideoOptions.compressOption;
            this.showFileLocationAlert = this.trimVideoOptions.showFileLocationAlert;
            this.fixedGap = this.trimVideoOptions.fixedDuration;
            this.fixedGap = this.fixedGap != 0L ? this.fixedGap : this.totalDuration;
            this.minGap = this.trimVideoOptions.minDuration;
            long l = this.minGap = this.minGap != 0L ? this.minGap : this.totalDuration;
            if (this.trimType == 3) {
                this.minFromGap = this.trimVideoOptions.minToMax[0];
                this.maxToGap = this.trimVideoOptions.minToMax[1];
                this.minFromGap = this.minFromGap != 0L ? this.minFromGap : this.totalDuration;
                this.maxToGap = this.maxToGap != 0L ? this.maxToGap : this.totalDuration;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.setLanguage(new Locale(this.local != null ? this.local : "en"));
    }

    private void onVideoClicked() {
        try {
            if (this.isVideoEnded) {
                this.seekTo(this.lastMinValue);
                this.videoPlayer.setPlayWhenReady(true);
                return;
            }
            if (this.currentDuration - this.lastMaxValue > 0L) {
                this.seekTo(this.lastMinValue);
            }
            this.videoPlayer.setPlayWhenReady(!this.videoPlayer.getPlayWhenReady());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void seekTo(long sec) {
        if (this.videoPlayer != null) {
            this.videoPlayer.seekTo(sec * 1000L);
        }
    }

    private void buildMediaSource() {
        try {
            DefaultDataSource.Factory dataSourceFactory = new DefaultDataSource.Factory((Context)this);
            ProgressiveMediaSource mediaSource = new ProgressiveMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(MediaItem.fromUri((Uri)this.fileUri));
            this.videoPlayer.addMediaSource((MediaSource)mediaSource);
            this.videoPlayer.prepare();
            this.videoPlayer.setPlayWhenReady(true);
            this.videoPlayer.addListener(new Player.Listener(){

                public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
                    ActVideoTrimmer.this.imagePlayPause.setVisibility(playWhenReady ? 8 : 0);
                }

                public void onPlaybackStateChanged(int state) {
                    switch (state) {
                        case 4: {
                            LogMessage.v("onPlayerStateChanged: Video ended.");
                            ActVideoTrimmer.this.imagePlayPause.setVisibility(0);
                            ActVideoTrimmer.this.isVideoEnded = true;
                            break;
                        }
                        case 3: {
                            ActVideoTrimmer.this.isVideoEnded = false;
                            ActVideoTrimmer.this.imagePlayPause.setVisibility(8);
                            ActVideoTrimmer.this.startProgress();
                            LogMessage.v("onPlayerStateChanged: Ready to play.");
                            break;
                        }
                        default: {
                            break;
                        }
                        case 2: {
                            LogMessage.v("onPlayerStateChanged: STATE_BUFFERING.");
                            break;
                        }
                        case 1: {
                            LogMessage.v("onPlayerStateChanged: STATE_IDLE.");
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadThumbnails() {
        try {
            long diff = this.totalDuration / (long)this.imageViews.length;
            int sec = 1;
            for (ImageView img : this.imageViews) {
                long interval = diff * (long)sec * 1000000L;
                RequestOptions options = (RequestOptions)new RequestOptions().frame(interval);
                Glide.with((FragmentActivity)this).load(this.fileUri).apply((BaseRequestOptions)options).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade((int)300)).into(img);
                if ((long)sec >= this.totalDuration) continue;
                ++sec;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpSeekBar() {
        this.seekbar.setVisibility(0);
        this.txtStartDuration.setVisibility(0);
        this.txtEndDuration.setVisibility(0);
        this.seekbarController.setMaxValue(this.totalDuration).apply();
        this.seekbar.setMaxValue(this.totalDuration).apply();
        this.seekbar.setMaxStartValue(this.totalDuration).apply();
        if (this.trimType == 1) {
            this.seekbar.setFixGap(this.fixedGap).apply();
            this.lastMaxValue = this.totalDuration;
        } else if (this.trimType == 2) {
            this.seekbar.setMaxStartValue(this.minGap);
            this.seekbar.setGap(this.minGap).apply();
            this.lastMaxValue = this.totalDuration;
        } else if (this.trimType == 3) {
            this.seekbar.setMaxStartValue(this.maxToGap);
            this.seekbar.setGap(this.minFromGap).apply();
            this.lastMaxValue = this.maxToGap;
        } else {
            this.seekbar.setGap(2.0f).apply();
            this.lastMaxValue = this.totalDuration;
        }
        if (this.hidePlayerSeek) {
            this.seekbarController.setVisibility(8);
        }
        this.seekbar.setOnRangeSeekbarFinalValueListener((minValue, maxValue) -> {
            if (!this.hidePlayerSeek) {
                this.seekbarController.setVisibility(0);
            }
        });
        this.seekbar.setOnRangeSeekbarChangeListener((minValue, maxValue) -> {
            long minVal = (Long)minValue;
            long maxVal = (Long)maxValue;
            if (this.lastMinValue != minVal) {
                this.seekTo((Long)minValue);
                if (!this.hidePlayerSeek) {
                    this.seekbarController.setVisibility(4);
                }
            }
            this.lastMinValue = minVal;
            this.lastMaxValue = maxVal;
            this.txtStartDuration.setText((CharSequence)TrimmerUtils.formatSeconds(minVal));
            this.txtEndDuration.setText((CharSequence)TrimmerUtils.formatSeconds(maxVal));
            if (this.trimType == 3) {
                this.setDoneColor(minVal, maxVal);
            }
        });
        this.seekbarController.setOnSeekbarFinalValueListener(value -> {
            long value1 = (Long)value;
            if (value1 < this.lastMaxValue && value1 > this.lastMinValue) {
                this.seekTo(value1);
                return;
            }
            if (value1 > this.lastMaxValue) {
                this.seekbarController.setMinStartValue((int)this.lastMaxValue).apply();
            } else if (value1 < this.lastMinValue) {
                this.seekbarController.setMinStartValue((int)this.lastMinValue).apply();
                if (this.videoPlayer.getPlayWhenReady()) {
                    this.seekTo(this.lastMinValue);
                }
            }
        });
    }

    private void setDoneColor(long minVal, long maxVal) {
        try {
            if (this.menuDone == null) {
                return;
            }
            if (maxVal - minVal <= this.maxToGap) {
                this.menuDone.getIcon().setColorFilter((ColorFilter)new PorterDuffColorFilter(ContextCompat.getColor((Context)this, (int)R.color.colorWhite), PorterDuff.Mode.SRC_IN));
                this.isValidVideo = true;
            } else {
                this.menuDone.getIcon().setColorFilter((ColorFilter)new PorterDuffColorFilter(ContextCompat.getColor((Context)this, (int)R.color.colorWhiteLt), PorterDuff.Mode.SRC_IN));
                this.isValidVideo = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 115) {
            if (this.isPermissionOk(grantResults)) {
                this.setDataInView("");
            } else {
                Toast.makeText((Context)this, (CharSequence)"Storage permission denied", (int)0).show();
                this.finish();
            }
        }
    }

    protected void onPause() {
        super.onPause();
        this.videoPlayer.setPlayWhenReady(false);
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            File f;
            if (this.videoPlayer != null) {
                this.videoPlayer.release();
            }
            if (this.progressView != null && this.progressView.isShowing()) {
                this.progressView.dismiss();
            }
            if ((f = new File(this.getCacheDir(), "temp_video_file")).exists()) {
                f.delete();
            }
            this.stopRepeatingTask();
            this.transformer.cancel();
        }
        catch (Exception e) {
            LogMessage.e(Log.getStackTraceString((Throwable)e));
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_done, menu2);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        this.menuDone = menu2.findItem(R.id.action_done);
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_done) {
            if (SystemClock.elapsedRealtime() - this.lastClickedTime < 800L) {
                return true;
            }
            this.lastClickedTime = SystemClock.elapsedRealtime();
            this.trimVideo();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @UnstableApi
    private void trimVideo() {
        if (this.isValidVideo) {
            this.outputPath = this.getFileName();
            LogMessage.v("outputPath::" + this.outputPath + new File(this.outputPath).exists());
            LogMessage.v("sourcePath::" + this.fileUri);
            this.videoPlayer.setPlayWhenReady(false);
            this.showProcessingDialog();
            androidx.media3.common.MediaItem mediaItem = new MediaItem.Builder().setUri(this.fileUri).setClippingConfiguration(new MediaItem.ClippingConfiguration.Builder().setStartPositionMs(this.lastMinValue * 1000L).setEndPositionMs(this.lastMaxValue * 1000L).build()).build();
            Pair<Integer, Integer> videoRes = TrimmerUtils.getVideoRes((Activity)this, this.fileUri);
            int width = (Integer)videoRes.first;
            int height = (Integer)videoRes.second;
            EditedMediaItem editedMediaItem = new EditedMediaItem.Builder(mediaItem).setEffects(new Effects((List)ImmutableList.of(), (List)ImmutableList.of((Object)Presentation.createForWidthAndHeight((int)width, (int)height, (int)0)))).build();
            long bitRate = TrimmerUtils.getBitRate((Activity)this, this.fileUri);
            if (this.isCompressionEnabled) {
                HashMap<VideoRes, Long> videoResMap = TrimmerUtils.getResBitRate((Activity)this, this.fileUri);
                Long compressionBitRate = videoResMap.get((Object)this.selectedRes);
                bitRate = compressionBitRate != null ? compressionBitRate : bitRate;
            }
            this.transformer = new Transformer.Builder((Context)this).addListener(this.transformerListener).setEncoderFactory((Codec.EncoderFactory)new DefaultEncoderFactory.Builder((Context)this).setRequestedVideoEncoderSettings(new VideoEncoderSettings.Builder().setBitrate(Math.toIntExact(bitRate)).build()).build()).build();
            this.transformer.getProgress(new ProgressHolder());
            this.transformer.start(editedMediaItem, this.outputPath);
            final ProgressHolder progressHolder = new ProgressHolder();
            final Handler mainHandler = new Handler(Looper.getMainLooper());
            if (this.progressRunnable != null) {
                mainHandler.removeCallbacks(this.progressRunnable);
            }
            this.progressRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        int progressState = ActVideoTrimmer.this.transformer.getProgress(progressHolder);
                        if (progressState == 2) {
                            String progress = ActVideoTrimmer.this.getString(R.string.txt_trimming_video) + " " + progressHolder.progress + "%";
                            if (ActVideoTrimmer.this.txtProgress != null) {
                                ActVideoTrimmer.this.txtProgress.setText((CharSequence)progress);
                            }
                        }
                        if (progressState != 0) {
                            mainHandler.postDelayed((Runnable)this, 300L);
                        }
                    }
                    catch (Exception e) {
                        Log.e((String)"TAG", (String)"run: ", (Throwable)e);
                    }
                }
            };
            mainHandler.post(this.progressRunnable);
        } else {
            Toast.makeText((Context)this, (CharSequence)(this.getString(R.string.txt_smaller) + " " + TrimmerUtils.getLimitedTimeFormatted(this.maxToGap)), (int)0).show();
        }
    }

    private String getFileName() {
        String path = this.getExternalFilesDir("TrimmedVideo").getPath();
        Calendar calender = Calendar.getInstance();
        String fileDateTime = calender.get(1) + "_" + calender.get(2) + "_" + calender.get(5) + "_" + calender.get(11) + "_" + calender.get(12) + "_" + calender.get(13);
        String fName = "trimmed_video_";
        if (this.fileName != null && !this.fileName.isEmpty()) {
            fName = this.fileName;
        }
        String extension = null;
        String mimeType = this.getContentResolver().getType(this.fileUri);
        if (mimeType != null) {
            extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
        }
        File newFile = new File(path + File.separator + fName + fileDateTime + "." + extension);
        return String.valueOf(newFile);
    }

    private void showLocationAlert() {
        AlertDialog openFileLocationDialog = new AlertDialog.Builder((Context)this).create();
        openFileLocationDialog.setTitle((CharSequence)this.getString(R.string.open_file_location));
        openFileLocationDialog.setCancelable(true);
        openFileLocationDialog.setButton(-1, (CharSequence)this.getString(R.string.yes), (dialogInterface, i) -> {
            Intent chooser = new Intent("android.intent.action.GET_CONTENT");
            Uri uriFile = Uri.parse((String)this.outputPath);
            chooser.addCategory("android.intent.category.OPENABLE");
            chooser.setDataAndType(uriFile, "*/*");
            this.startActivity(chooser);
        });
        openFileLocationDialog.setButton(-2, (CharSequence)this.getString(R.string.no), (dialogInterface, i) -> openFileLocationDialog.dismiss());
        openFileLocationDialog.setOnDismissListener(dialogInterface -> {
            Intent intent = new Intent();
            intent.putExtra("trimmed_video_path", this.outputPath);
            this.setResult(-1, intent);
            this.finish();
        });
        openFileLocationDialog.show();
    }

    private void showProcessingDialog() {
        try {
            this.dialog = new Dialog((Context)this);
            this.dialog.setCancelable(false);
            this.dialog.setContentView(R.layout.alert_convert);
            TextView txtCancel = (TextView)this.dialog.findViewById(R.id.txt_cancel);
            this.txtProgress = (TextView)this.dialog.findViewById(R.id.txt_process);
            this.dialog.setCancelable(false);
            this.dialog.getWindow().setLayout(-1, -2);
            txtCancel.setOnClickListener(v -> {
                this.dialog.dismiss();
                this.transformer.cancel();
            });
            this.dialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkStoragePermission() {
        String uri = FileUtilKt.getActualFileUri((Context)this, this.fileUri);
        if (uri != null && new File(uri).canRead()) {
            Log.e((String)"VideoTrimmer", (String)"checkStoragePermission: has no permission");
            return true;
        }
        if (Build.VERSION.SDK_INT >= 34) {
            boolean hasPermission;
            boolean bl = hasPermission = ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_MEDIA_VISUAL_USER_SELECTED") == 0 || ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_MEDIA_VIDEO") == 0;
            if (hasPermission) {
                return true;
            }
            return this.checkPermission("android.permission.READ_MEDIA_VIDEO");
        }
        if (Build.VERSION.SDK_INT == 33) {
            return this.checkPermission("android.permission.READ_MEDIA_VIDEO");
        }
        if (Build.VERSION.SDK_INT >= 29) {
            return this.checkPermission("android.permission.READ_EXTERNAL_STORAGE");
        }
        return this.checkPermission("android.permission.READ_EXTERNAL_STORAGE");
    }

    private boolean checkPermission(String ... permissions) {
        boolean allPermitted = false;
        for (String permission2 : permissions) {
            boolean bl = allPermitted = ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0;
            if (!allPermitted) break;
        }
        if (allPermitted) {
            return true;
        }
        ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)115);
        return false;
    }

    private boolean isPermissionOk(int ... results) {
        boolean isAllGranted = true;
        for (int result : results) {
            if (0 == result) continue;
            isAllGranted = false;
            break;
        }
        return isAllGranted;
    }

    void startProgress() {
        this.updateSeekbar.run();
    }

    void stopRepeatingTask() {
        this.seekHandler.removeCallbacks(this.updateSeekbar);
    }
}

