/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.utils;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.util.Log;
import com.gowtham.library.utils.FileCacheHandler;
import com.gowtham.library.utils.LogMessage;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\r"}, d2={"Lcom/gowtham/library/utils/FileUtilKt;", "", "()V", "getActualFileUri", "", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "getFileUriFromContentProvider", "getFileUriFromContentProviderBySplit", "id", "getValidatedFileUri", "library_release"})
public final class FileUtilKt {
    @NotNull
    public static final FileUtilKt INSTANCE = new FileUtilKt();

    private FileUtilKt() {
    }

    @JvmStatic
    @Nullable
    public static final String getValidatedFileUri(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String actualUri = FileUtilKt.getActualFileUri(context, uri);
        return actualUri != null && new File(actualUri).canRead() ? actualUri : FileCacheHandler.putFileInCache(context, context.getContentResolver().openInputStream(uri));
    }

    @JvmStatic
    @Nullable
    public static final String getActualFileUri(@NotNull Context context, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        try {
            String string;
            String actualPath = INSTANCE.getFileUriFromContentProvider(context, uri);
            if (actualPath != null) {
                string = actualPath;
            } else {
                String[] stringArray;
                String id;
                Object object = uri.getPath();
                String string2 = id = object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{":"}), (boolean)false, (int)0, (int)6, null)) != null ? (String)CollectionsKt.last((List)object) : null;
                if (string2 != null) {
                    String realUri;
                    String it = string2;
                    boolean bl = false;
                    string = realUri = INSTANCE.getFileUriFromContentProviderBySplit(context, id);
                } else {
                    string = null;
                }
            }
            return string;
        }
        catch (Exception e) {
            LogMessage.e(Log.getStackTraceString((Throwable)e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFileUriFromContentProvider(Context context, Uri uri) {
        String[] stringArray;
        block3: {
            String string;
            Cursor cursor = null;
            try {
                stringArray = new String[]{"_data"};
                String[] proj = stringArray;
                cursor = context.getContentResolver().query(uri, proj, null, null, null);
                if (cursor == null) break block3;
                int columnIndex = cursor.getColumnIndexOrThrow("_data");
                cursor.moveToFirst();
                string = cursor.getString(columnIndex);
            }
            catch (Throwable throwable) {
                block4: {
                    Cursor cursor2 = cursor;
                    if (cursor2 == null) break block4;
                    cursor2.close();
                }
                throw throwable;
            }
            cursor.close();
            return string;
        }
        stringArray = null;
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getFileUriFromContentProviderBySplit(Context context, String id) {
        Cursor cursor;
        block4: {
            cursor = null;
            Uri queryUri = MediaStore.Files.getContentUri((String)"external");
            String[] stringArray = new String[]{"_id", "_data"};
            String[] projection = stringArray;
            stringArray = new String[]{id};
            cursor = context.getContentResolver().query(queryUri, projection, "(_id IN (?))", stringArray, null);
            if (cursor == null) break block4;
            int columnIndex = cursor.getColumnIndexOrThrow("_data");
            if (!cursor.moveToNext()) break block4;
            String string = cursor.getString(columnIndex);
            cursor.close();
            return string;
        }
        try {
            String string = null;
            return string;
        }
        finally {
            block5: {
                Cursor cursor2 = cursor;
                if (cursor2 == null) break block5;
                cursor2.close();
            }
        }
    }
}

