/*
 * Decompiled with CFR 0.152.
 */
package com.gowtham.library.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.akexorcist.localizationactivity.ui.LocalizationActivity;
import com.arthenica.ffmpegkit.FFmpegKit;
import com.bumptech.glide.Glide;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.ui.StyledPlayerView;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultDataSource;
import com.google.gson.Gson;
import com.gowtham.library.R;
import com.gowtham.library.ui.seekbar.widgets.CrystalRangeSeekbar;
import com.gowtham.library.ui.seekbar.widgets.CrystalSeekbar;
import com.gowtham.library.utils.CompressOption;
import com.gowtham.library.utils.CustomProgressView;
import com.gowtham.library.utils.FileUtilKt;
import com.gowtham.library.utils.LocaleHelper;
import com.gowtham.library.utils.LogMessage;
import com.gowtham.library.utils.TrimVideoOptions;
import com.gowtham.library.utils.TrimmerUtils;
import java.io.File;
import java.util.Calendar;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;

public class ActVideoTrimmer
extends LocalizationActivity {
    private static final int PER_REQ_CODE = 115;
    private StyledPlayerView playerView;
    private ExoPlayer videoPlayer;
    private ImageView imagePlayPause;
    private ImageView[] imageViews;
    private long totalDuration;
    private Dialog dialog;
    private Uri filePath;
    private TextView txtStartDuration;
    private TextView txtEndDuration;
    private CrystalRangeSeekbar seekbar;
    private long lastMinValue = 0L;
    private long lastMaxValue = 0L;
    private MenuItem menuDone;
    private CrystalSeekbar seekbarController;
    private boolean isValidVideo = true;
    private boolean isVideoEnded;
    private Handler seekHandler;
    private Bundle bundle;
    private ProgressBar progressBar;
    private TrimVideoOptions trimVideoOptions;
    private long currentDuration;
    private long lastClickedTime;
    Runnable updateSeekbar = new Runnable(){

        @Override
        public void run() {
            try {
                ActVideoTrimmer.this.currentDuration = ActVideoTrimmer.this.videoPlayer.getCurrentPosition() / 1000L;
                if (!ActVideoTrimmer.this.videoPlayer.getPlayWhenReady()) {
                    return;
                }
                if (ActVideoTrimmer.this.currentDuration <= ActVideoTrimmer.this.lastMaxValue) {
                    ActVideoTrimmer.this.seekbarController.setMinStartValue((int)ActVideoTrimmer.this.currentDuration).apply();
                } else {
                    ActVideoTrimmer.this.videoPlayer.setPlayWhenReady(false);
                }
            }
            finally {
                ActVideoTrimmer.this.seekHandler.postDelayed(ActVideoTrimmer.this.updateSeekbar, 1000L);
            }
        }
    };
    private CompressOption compressOption;
    private String outputPath;
    private String local;
    private int trimType;
    private long fixedGap;
    private long minGap;
    private long minFromGap;
    private long maxToGap;
    private boolean hidePlayerSeek;
    private boolean isAccurateCut;
    private boolean showFileLocationAlert;
    private CustomProgressView progressView;
    private String fileName;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.act_video_trimmer);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setSupportActionBar(toolbar);
        this.bundle = this.getIntent().getExtras();
        Gson gson = new Gson();
        String videoOption = this.bundle.getString("trim_video_option");
        this.trimVideoOptions = (TrimVideoOptions)gson.fromJson(videoOption, TrimVideoOptions.class);
        this.setUpToolBar(this.getSupportActionBar(), this.trimVideoOptions.title);
        toolbar.setNavigationOnClickListener(v -> this.finish());
        this.progressView = new CustomProgressView((Context)this);
    }

    protected void attachBaseContext(@NotNull Context base) {
        super.attachBaseContext(LocaleHelper.onAttach(base, "en"));
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.playerView = (StyledPlayerView)this.findViewById(R.id.player_view_lib);
        this.imagePlayPause = (ImageView)this.findViewById(R.id.image_play_pause);
        this.seekbar = (CrystalRangeSeekbar)this.findViewById(R.id.range_seek_bar);
        this.txtStartDuration = (TextView)this.findViewById(R.id.txt_start_duration);
        this.txtEndDuration = (TextView)this.findViewById(R.id.txt_end_duration);
        this.seekbarController = (CrystalSeekbar)this.findViewById(R.id.seekbar_controller);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progress_circular);
        ImageView imageOne = (ImageView)this.findViewById(R.id.image_one);
        ImageView imageTwo = (ImageView)this.findViewById(R.id.image_two);
        ImageView imageThree = (ImageView)this.findViewById(R.id.image_three);
        ImageView imageFour = (ImageView)this.findViewById(R.id.image_four);
        ImageView imageFive = (ImageView)this.findViewById(R.id.image_five);
        ImageView imageSix = (ImageView)this.findViewById(R.id.image_six);
        ImageView imageSeven = (ImageView)this.findViewById(R.id.image_seven);
        ImageView imageEight = (ImageView)this.findViewById(R.id.image_eight);
        this.imageViews = new ImageView[]{imageOne, imageTwo, imageThree, imageFour, imageFive, imageSix, imageSeven, imageEight};
        this.seekHandler = new Handler();
        this.initPlayer();
        if (this.checkStoragePermission()) {
            this.setDataInView();
        }
    }

    private void setUpToolBar(ActionBar actionBar, String title) {
        try {
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setDisplayShowHomeEnabled(true);
            actionBar.setTitle((CharSequence)(title != null ? title : this.getString(R.string.txt_edt_video)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initPlayer() {
        try {
            this.videoPlayer = new ExoPlayer.Builder((Context)this).build();
            this.playerView.setResizeMode(0);
            this.playerView.setPlayer((Player)this.videoPlayer);
            if (Build.VERSION.SDK_INT >= 21) {
                AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(1).setContentType(3).build();
                this.videoPlayer.setAudioAttributes(audioAttributes, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDataInView() {
        try {
            Runnable fileUriRunnable = () -> {
                Uri uri = Uri.parse((String)this.bundle.getString("trim_video_uri"));
                String path = FileUtilKt.getValidatedFileUri((Context)this, uri);
                this.filePath = Uri.parse((String)path);
                this.runOnUiThread(() -> {
                    LogMessage.v("VideoUri:: " + uri);
                    LogMessage.v("VideoPath:: " + this.filePath);
                    this.progressBar.setVisibility(8);
                    this.totalDuration = TrimmerUtils.getDuration((Activity)this, this.filePath);
                    this.imagePlayPause.setOnClickListener(v -> this.onVideoClicked());
                    Objects.requireNonNull(this.playerView.getVideoSurfaceView()).setOnClickListener(v -> this.onVideoClicked());
                    this.initTrimData();
                    this.buildMediaSource();
                    this.loadThumbnails();
                    this.setUpSeekBar();
                });
            };
            Executors.newSingleThreadExecutor().execute(fileUriRunnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTrimData() {
        try {
            assert (this.trimVideoOptions != null);
            this.trimType = TrimmerUtils.getTrimType(this.trimVideoOptions.trimType);
            this.fileName = this.trimVideoOptions.fileName;
            this.hidePlayerSeek = this.trimVideoOptions.hideSeekBar;
            this.isAccurateCut = this.trimVideoOptions.accurateCut;
            this.local = this.trimVideoOptions.local;
            this.compressOption = this.trimVideoOptions.compressOption;
            this.showFileLocationAlert = this.trimVideoOptions.showFileLocationAlert;
            this.fixedGap = this.trimVideoOptions.fixedDuration;
            this.fixedGap = this.fixedGap != 0L ? this.fixedGap : this.totalDuration;
            this.minGap = this.trimVideoOptions.minDuration;
            long l = this.minGap = this.minGap != 0L ? this.minGap : this.totalDuration;
            if (this.trimType == 3) {
                this.minFromGap = this.trimVideoOptions.minToMax[0];
                this.maxToGap = this.trimVideoOptions.minToMax[1];
                this.minFromGap = this.minFromGap != 0L ? this.minFromGap : this.totalDuration;
                this.maxToGap = this.maxToGap != 0L ? this.maxToGap : this.totalDuration;
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        this.setLanguage(new Locale(this.local != null ? this.local : "en"));
    }

    private void onVideoClicked() {
        try {
            if (this.isVideoEnded) {
                this.seekTo(this.lastMinValue);
                this.videoPlayer.setPlayWhenReady(true);
                return;
            }
            if (this.currentDuration - this.lastMaxValue > 0L) {
                this.seekTo(this.lastMinValue);
            }
            this.videoPlayer.setPlayWhenReady(!this.videoPlayer.getPlayWhenReady());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void seekTo(long sec) {
        if (this.videoPlayer != null) {
            this.videoPlayer.seekTo(sec * 1000L);
        }
    }

    private void buildMediaSource() {
        try {
            DefaultDataSource.Factory dataSourceFactory = new DefaultDataSource.Factory((Context)this);
            ProgressiveMediaSource mediaSource = new ProgressiveMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(MediaItem.fromUri((Uri)this.filePath));
            this.videoPlayer.addMediaSource((MediaSource)mediaSource);
            this.videoPlayer.prepare();
            this.videoPlayer.setPlayWhenReady(true);
            this.videoPlayer.addListener(new Player.Listener(){

                public void onPlayWhenReadyChanged(boolean playWhenReady, int reason) {
                    ActVideoTrimmer.this.imagePlayPause.setVisibility(playWhenReady ? 8 : 0);
                }

                public void onPlaybackStateChanged(int state) {
                    switch (state) {
                        case 4: {
                            LogMessage.v("onPlayerStateChanged: Video ended.");
                            ActVideoTrimmer.this.imagePlayPause.setVisibility(0);
                            ActVideoTrimmer.this.isVideoEnded = true;
                            break;
                        }
                        case 3: {
                            ActVideoTrimmer.this.isVideoEnded = false;
                            ActVideoTrimmer.this.imagePlayPause.setVisibility(8);
                            ActVideoTrimmer.this.startProgress();
                            LogMessage.v("onPlayerStateChanged: Ready to play.");
                            break;
                        }
                        default: {
                            break;
                        }
                        case 2: {
                            LogMessage.v("onPlayerStateChanged: STATE_BUFFERING.");
                            break;
                        }
                        case 1: {
                            LogMessage.v("onPlayerStateChanged: STATE_IDLE.");
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadThumbnails() {
        try {
            long diff = this.totalDuration / 8L;
            int sec = 1;
            File videoFile = new File(this.filePath.toString());
            for (ImageView img : this.imageViews) {
                long interval = diff * (long)sec * 1000000L;
                RequestOptions options = (RequestOptions)new RequestOptions().frame(interval);
                Glide.with((FragmentActivity)this).load(videoFile).apply((BaseRequestOptions)options).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade((int)300)).into(img);
                if ((long)sec >= this.totalDuration) continue;
                ++sec;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setUpSeekBar() {
        this.seekbar.setVisibility(0);
        this.txtStartDuration.setVisibility(0);
        this.txtEndDuration.setVisibility(0);
        this.seekbarController.setMaxValue(this.totalDuration).apply();
        this.seekbar.setMaxValue(this.totalDuration).apply();
        this.seekbar.setMaxStartValue(this.totalDuration).apply();
        if (this.trimType == 1) {
            this.seekbar.setFixGap(this.fixedGap).apply();
            this.lastMaxValue = this.totalDuration;
        } else if (this.trimType == 2) {
            this.seekbar.setMaxStartValue(this.minGap);
            this.seekbar.setGap(this.minGap).apply();
            this.lastMaxValue = this.totalDuration;
        } else if (this.trimType == 3) {
            this.seekbar.setMaxStartValue(this.maxToGap);
            this.seekbar.setGap(this.minFromGap).apply();
            this.lastMaxValue = this.maxToGap;
        } else {
            this.seekbar.setGap(2.0f).apply();
            this.lastMaxValue = this.totalDuration;
        }
        if (this.hidePlayerSeek) {
            this.seekbarController.setVisibility(8);
        }
        this.seekbar.setOnRangeSeekbarFinalValueListener((minValue, maxValue) -> {
            if (!this.hidePlayerSeek) {
                this.seekbarController.setVisibility(0);
            }
        });
        this.seekbar.setOnRangeSeekbarChangeListener((minValue, maxValue) -> {
            long minVal = (Long)minValue;
            long maxVal = (Long)maxValue;
            if (this.lastMinValue != minVal) {
                this.seekTo((Long)minValue);
                if (!this.hidePlayerSeek) {
                    this.seekbarController.setVisibility(4);
                }
            }
            this.lastMinValue = minVal;
            this.lastMaxValue = maxVal;
            this.txtStartDuration.setText((CharSequence)TrimmerUtils.formatSeconds(minVal));
            this.txtEndDuration.setText((CharSequence)TrimmerUtils.formatSeconds(maxVal));
            if (this.trimType == 3) {
                this.setDoneColor(minVal, maxVal);
            }
        });
        this.seekbarController.setOnSeekbarFinalValueListener(value -> {
            long value1 = (Long)value;
            if (value1 < this.lastMaxValue && value1 > this.lastMinValue) {
                this.seekTo(value1);
                return;
            }
            if (value1 > this.lastMaxValue) {
                this.seekbarController.setMinStartValue((int)this.lastMaxValue).apply();
            } else if (value1 < this.lastMinValue) {
                this.seekbarController.setMinStartValue((int)this.lastMinValue).apply();
                if (this.videoPlayer.getPlayWhenReady()) {
                    this.seekTo(this.lastMinValue);
                }
            }
        });
    }

    private void setDoneColor(long minVal, long maxVal) {
        try {
            if (this.menuDone == null) {
                return;
            }
            if (maxVal - minVal <= this.maxToGap) {
                this.menuDone.getIcon().setColorFilter((ColorFilter)new PorterDuffColorFilter(ContextCompat.getColor((Context)this, (int)R.color.colorWhite), PorterDuff.Mode.SRC_IN));
                this.isValidVideo = true;
            } else {
                this.menuDone.getIcon().setColorFilter((ColorFilter)new PorterDuffColorFilter(ContextCompat.getColor((Context)this, (int)R.color.colorWhiteLt), PorterDuff.Mode.SRC_IN));
                this.isValidVideo = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 115) {
            if (this.isPermissionOk(grantResults)) {
                this.setDataInView();
            } else {
                Toast.makeText((Context)this, (CharSequence)"Storage permission denied", (int)0).show();
                this.finish();
            }
        }
    }

    protected void onPause() {
        super.onPause();
        this.videoPlayer.setPlayWhenReady(false);
    }

    protected void onDestroy() {
        super.onDestroy();
        try {
            File f;
            if (this.videoPlayer != null) {
                this.videoPlayer.release();
            }
            if (this.progressView != null && this.progressView.isShowing()) {
                this.progressView.dismiss();
            }
            if ((f = new File(this.getCacheDir(), "temp_video_file")).exists()) {
                f.delete();
            }
            this.stopRepeatingTask();
            FFmpegKit.cancel();
        }
        catch (Exception e) {
            LogMessage.e(Log.getStackTraceString((Throwable)e));
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_done, menu2);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        this.menuDone = menu2.findItem(R.id.action_done);
        return super.onPrepareOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == R.id.action_done) {
            if (SystemClock.elapsedRealtime() - this.lastClickedTime < 800L) {
                return true;
            }
            this.lastClickedTime = SystemClock.elapsedRealtime();
            this.trimVideo();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void trimVideo() {
        if (this.isValidVideo) {
            this.outputPath = this.getFileName();
            LogMessage.v("outputPath::" + this.outputPath + new File(this.outputPath).exists());
            LogMessage.v("sourcePath::" + this.filePath);
            this.videoPlayer.setPlayWhenReady(false);
            this.showProcessingDialog();
            String[] complexCommand = this.compressOption != null ? this.getCompressionCmd() : (this.isAccurateCut ? this.getAccurateCmd() : new String[]{"-ss", TrimmerUtils.formatCSeconds(this.lastMinValue), "-i", String.valueOf(this.filePath), "-t", TrimmerUtils.formatCSeconds(this.lastMaxValue - this.lastMinValue), "-async", "1", "-strict", "-2", "-c", "copy", this.outputPath});
            this.execFFmpegBinary(complexCommand, true);
        } else {
            Toast.makeText((Context)this, (CharSequence)(this.getString(R.string.txt_smaller) + " " + TrimmerUtils.getLimitedTimeFormatted(this.maxToGap)), (int)0).show();
        }
    }

    private String getFileName() {
        String path = this.getExternalFilesDir("TrimmedVideo").getPath();
        Calendar calender = Calendar.getInstance();
        String fileDateTime = calender.get(1) + "_" + calender.get(2) + "_" + calender.get(5) + "_" + calender.get(11) + "_" + calender.get(12) + "_" + calender.get(13);
        String fName = "trimmed_video_";
        if (this.fileName != null && !this.fileName.isEmpty()) {
            fName = this.fileName;
        }
        File newFile = new File(path + File.separator + fName + fileDateTime + "." + TrimmerUtils.getFileExtension((Context)this, this.filePath));
        return String.valueOf(newFile);
    }

    private String[] getCompressionCmd() {
        MediaMetadataRetriever metaRetriever = new MediaMetadataRetriever();
        metaRetriever.setDataSource(String.valueOf(this.filePath));
        String height = metaRetriever.extractMetadata(19);
        String width = metaRetriever.extractMetadata(18);
        int w = TrimmerUtils.clearNull(width).isEmpty() ? 0 : Integer.parseInt(width);
        int h = Integer.parseInt(height);
        int rotation = TrimmerUtils.getVideoRotation((Activity)this, this.filePath);
        if (rotation == 90 || rotation == 270) {
            int temp = w;
            w = h;
            h = temp;
        }
        if (this.compressOption.getWidth() != 0 || this.compressOption.getHeight() != 0 || !this.compressOption.getBitRate().equals("0k")) {
            return new String[]{"-ss", TrimmerUtils.formatCSeconds(this.lastMinValue), "-i", String.valueOf(this.filePath), "-s", this.compressOption.getWidth() + "x" + this.compressOption.getHeight(), "-r", String.valueOf(this.compressOption.getFrameRate()), "-vcodec", "mpeg4", "-b:v", this.compressOption.getBitRate(), "-b:a", "48000", "-ac", "2", "-ar", "22050", "-t", TrimmerUtils.formatCSeconds(this.lastMaxValue - this.lastMinValue), this.outputPath};
        }
        if (w >= 800) {
            return new String[]{"-ss", TrimmerUtils.formatCSeconds(this.lastMinValue), "-i", String.valueOf(this.filePath), "-s", (w /= 2) + "x" + (h /= 2), "-r", "30", "-vcodec", "mpeg4", "-b:v", "1M", "-b:a", "48000", "-ac", "2", "-ar", "22050", "-t", TrimmerUtils.formatCSeconds(this.lastMaxValue - this.lastMinValue), this.outputPath};
        }
        return new String[]{"-ss", TrimmerUtils.formatCSeconds(this.lastMinValue), "-i", String.valueOf(this.filePath), "-s", w + "x" + h, "-r", "30", "-vcodec", "mpeg4", "-b:v", "400K", "-b:a", "48000", "-ac", "2", "-ar", "22050", "-t", TrimmerUtils.formatCSeconds(this.lastMaxValue - this.lastMinValue), this.outputPath};
    }

    private void execFFmpegBinary(String[] command, boolean retry) {
        try {
            FFmpegKit.executeWithArgumentsAsync((String[])command, session -> {
                int result = session.getReturnCode().getValue();
                if (result == 0) {
                    this.dialog.dismiss();
                    if (this.showFileLocationAlert) {
                        this.showLocationAlert();
                    } else {
                        Intent intent = new Intent();
                        intent.putExtra("trimmed_video_path", this.outputPath);
                        this.setResult(-1, intent);
                        this.finish();
                    }
                } else if (result == 255) {
                    LogMessage.v("Command cancelled");
                    if (this.dialog.isShowing()) {
                        this.dialog.dismiss();
                    }
                } else if (retry && !this.isAccurateCut && this.compressOption == null) {
                    File newFile = new File(this.outputPath);
                    if (newFile.exists()) {
                        newFile.delete();
                    }
                    this.execFFmpegBinary(this.getAccurateCmd(), false);
                } else {
                    if (this.dialog.isShowing()) {
                        this.dialog.dismiss();
                    }
                    this.runOnUiThread(() -> Toast.makeText((Context)this, (CharSequence)"Failed to trim", (int)0).show());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showLocationAlert() {
        AlertDialog openFileLocationDialog = new AlertDialog.Builder((Context)this).create();
        openFileLocationDialog.setTitle((CharSequence)this.getString(R.string.open_file_location));
        openFileLocationDialog.setCancelable(true);
        openFileLocationDialog.setButton(-1, (CharSequence)this.getString(R.string.yes), (dialogInterface, i) -> {
            Intent chooser = new Intent("android.intent.action.GET_CONTENT");
            Uri uriFile = Uri.parse((String)this.outputPath);
            chooser.addCategory("android.intent.category.OPENABLE");
            chooser.setDataAndType(uriFile, "*/*");
            this.startActivity(chooser);
        });
        openFileLocationDialog.setButton(-2, (CharSequence)this.getString(R.string.no), (dialogInterface, i) -> openFileLocationDialog.dismiss());
        openFileLocationDialog.setOnDismissListener(dialogInterface -> {
            Intent intent = new Intent();
            intent.putExtra("trimmed_video_path", this.outputPath);
            this.setResult(-1, intent);
            this.finish();
        });
        openFileLocationDialog.show();
    }

    private String[] getAccurateCmd() {
        return new String[]{"-ss", TrimmerUtils.formatCSeconds(this.lastMinValue), "-i", String.valueOf(this.filePath), "-t", TrimmerUtils.formatCSeconds(this.lastMaxValue - this.lastMinValue), "-async", "1", this.outputPath};
    }

    private void showProcessingDialog() {
        try {
            this.dialog = new Dialog((Context)this);
            this.dialog.setCancelable(false);
            this.dialog.setContentView(R.layout.alert_convert);
            TextView txtCancel = (TextView)this.dialog.findViewById(R.id.txt_cancel);
            this.dialog.setCancelable(false);
            this.dialog.getWindow().setLayout(-1, -2);
            txtCancel.setOnClickListener(v -> {
                this.dialog.dismiss();
                FFmpegKit.cancel();
            });
            this.dialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean checkStoragePermission() {
        if (Build.VERSION.SDK_INT >= 33) {
            return this.checkPermission("android.permission.READ_MEDIA_VIDEO", "android.permission.ACCESS_MEDIA_LOCATION");
        }
        if (Build.VERSION.SDK_INT >= 29) {
            return this.checkPermission("android.permission.READ_EXTERNAL_STORAGE", "android.permission.ACCESS_MEDIA_LOCATION");
        }
        return this.checkPermission("android.permission.READ_EXTERNAL_STORAGE");
    }

    private boolean checkPermission(String ... permissions) {
        boolean allPermitted = false;
        for (String permission2 : permissions) {
            boolean bl = allPermitted = ContextCompat.checkSelfPermission((Context)this, (String)permission2) == 0;
            if (!allPermitted) break;
        }
        if (allPermitted) {
            return true;
        }
        ActivityCompat.requestPermissions((Activity)this, (String[])permissions, (int)115);
        return false;
    }

    private boolean isPermissionOk(int ... results) {
        boolean isAllGranted = true;
        for (int result : results) {
            if (0 == result) continue;
            isAllGranted = false;
            break;
        }
        return isAllGranted;
    }

    void startProgress() {
        this.updateSeekbar.run();
    }

    void stopRepeatingTask() {
        this.seekHandler.removeCallbacks(this.updateSeekbar);
    }
}

