/*
 * Decompiled with CFR 0.152.
 */
package top.wuhaojie.installerlibrary;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import top.wuhaojie.installerlibrary.InstallAccessibilityService;
import top.wuhaojie.installerlibrary.utils.Utils;

public class AutoInstaller
extends Handler {
    private static final String TAG = "AutoInstaller";
    private static volatile AutoInstaller mAutoInstaller;
    private Context mContext;
    private String mTempPath = Environment.getExternalStorageDirectory().getAbsolutePath();
    private MODE mMode = MODE.BOTH;
    private OnStateChangedListener mOnStateChangedListener;

    private AutoInstaller(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AutoInstaller getDefault(Context context) {
        if (mAutoInstaller != null) return mAutoInstaller;
        Class<AutoInstaller> clazz = AutoInstaller.class;
        synchronized (AutoInstaller.class) {
            if (mAutoInstaller != null) return mAutoInstaller;
            mAutoInstaller = new AutoInstaller(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mAutoInstaller;
        }
    }

    public void setOnStateChangedListener(OnStateChangedListener onStateChangedListener) {
        this.mOnStateChangedListener = onStateChangedListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean installUseRoot(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            throw new IllegalArgumentException("Please check apk file path!");
        }
        boolean result = false;
        Process process = null;
        OutputStream outputStream = null;
        BufferedReader errorStream = null;
        try {
            String line;
            process = Runtime.getRuntime().exec("su");
            outputStream = process.getOutputStream();
            String command = "pm install -r " + filePath + "\n";
            outputStream.write(command.getBytes());
            outputStream.flush();
            outputStream.write("exit\n".getBytes());
            outputStream.flush();
            process.waitFor();
            errorStream = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringBuilder msg = new StringBuilder();
            while ((line = errorStream.readLine()) != null) {
                msg.append(line);
            }
            Log.d((String)TAG, (String)("install msg is " + msg));
            if (!msg.toString().contains("Failure")) {
                result = true;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (errorStream != null) {
                    errorStream.close();
                }
            }
            catch (IOException e) {
                outputStream = null;
                errorStream = null;
                process.destroy();
            }
        }
        return result;
    }

    private void installUseAS(String filePath) {
        Uri uri = Uri.fromFile((File)new File(filePath));
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(uri, "application/vnd.android.package-archive");
        this.mContext.startActivity(intent);
        if (!this.isAccessibilitySettingsOn(this.mContext)) {
            this.toAccessibilityService();
            this.sendEmptyMessage(3);
        }
    }

    private void toAccessibilityService() {
        Intent intent = new Intent("android.settings.ACCESSIBILITY_SETTINGS");
        this.mContext.startActivity(intent);
    }

    private boolean isAccessibilitySettingsOn(Context mContext) {
        int accessibilityEnabled = 0;
        String service = mContext.getPackageName() + "/" + InstallAccessibilityService.class.getCanonicalName();
        try {
            accessibilityEnabled = Settings.Secure.getInt((ContentResolver)mContext.getApplicationContext().getContentResolver(), (String)"accessibility_enabled");
            Log.v((String)TAG, (String)("accessibilityEnabled = " + accessibilityEnabled));
        }
        catch (Settings.SettingNotFoundException e) {
            Log.e((String)TAG, (String)("Error finding setting, default accessibility to not found: " + e.getMessage()));
        }
        TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
        if (accessibilityEnabled == 1) {
            Log.v((String)TAG, (String)"***ACCESSIBILITY IS ENABLED*** -----------------");
            String settingValue = Settings.Secure.getString((ContentResolver)mContext.getApplicationContext().getContentResolver(), (String)"enabled_accessibility_services");
            if (settingValue != null) {
                mStringColonSplitter.setString(settingValue);
                while (mStringColonSplitter.hasNext()) {
                    String accessibilityService = mStringColonSplitter.next();
                    Log.v((String)TAG, (String)("-------------- > accessibilityService :: " + accessibilityService + " " + service));
                    if (!accessibilityService.equalsIgnoreCase(service)) continue;
                    Log.v((String)TAG, (String)"We've found the correct setting - accessibility is switched on!");
                    return true;
                }
            }
        } else {
            Log.v((String)TAG, (String)"***ACCESSIBILITY IS DISABLED***");
        }
        return false;
    }

    public void install(final String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath) || !filePath.endsWith(".apk")) {
            throw new IllegalArgumentException("not a correct apk file path");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                AutoInstaller.this.sendEmptyMessage(1);
                switch (AutoInstaller.this.mMode) {
                    case BOTH: {
                        if (Utils.checkRooted() && AutoInstaller.this.installUseRoot(filePath)) break;
                        AutoInstaller.this.installUseAS(filePath);
                        break;
                    }
                    case ROOT_ONLY: {
                        AutoInstaller.this.installUseRoot(filePath);
                        break;
                    }
                    case AUTO_ONLY: {
                        AutoInstaller.this.installUseAS(filePath);
                    }
                }
                AutoInstaller.this.sendEmptyMessage(0);
            }
        }).start();
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        switch (msg.what) {
            case 0: {
                if (this.mOnStateChangedListener == null) break;
                this.mOnStateChangedListener.onComplete();
                break;
            }
            case 1: {
                if (this.mOnStateChangedListener == null) break;
                this.mOnStateChangedListener.onStart();
                break;
            }
            case 3: {
                if (this.mOnStateChangedListener == null) break;
                this.mOnStateChangedListener.onNeed2OpenService();
            }
        }
    }

    public void install(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        this.install(file.getAbsolutePath());
    }

    public void installFromUrl(final String httpUrl) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                AutoInstaller.this.sendEmptyMessage(1);
                File file = AutoInstaller.this.downLoadFile(httpUrl);
                AutoInstaller.this.install(file);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downLoadFile(String httpUrl) {
        if (TextUtils.isEmpty((CharSequence)httpUrl)) {
            throw new IllegalArgumentException();
        }
        File file = new File(this.mTempPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        file = new File(this.mTempPath + File.separator + "update.apk");
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        HttpURLConnection connection = null;
        try {
            URL url = new URL(httpUrl);
            connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.connect();
            inputStream = connection.getInputStream();
            outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (connection != null) {
                    connection.disconnect();
                }
            }
            catch (IOException e) {
                inputStream = null;
                outputStream = null;
            }
        }
        return file;
    }

    public static class Builder {
        private MODE mode = MODE.BOTH;
        private Context context;
        private OnStateChangedListener onStateChangedListener;
        private String directory = Environment.getExternalStorageDirectory().getAbsolutePath();

        public Builder(Context c) {
            this.context = c;
        }

        public Builder setMode(MODE m) {
            this.mode = m;
            return this;
        }

        public Builder setOnStateChangedListener(OnStateChangedListener o) {
            this.onStateChangedListener = o;
            return this;
        }

        public Builder setCacheDirectory(String path) {
            this.directory = path;
            return this;
        }

        public AutoInstaller build() {
            AutoInstaller autoInstaller = new AutoInstaller(this.context);
            autoInstaller.mMode = this.mode;
            autoInstaller.mOnStateChangedListener = this.onStateChangedListener;
            autoInstaller.mTempPath = this.directory;
            return autoInstaller;
        }
    }

    public static interface OnStateChangedListener {
        public void onStart();

        public void onComplete();

        public void onNeed2OpenService();
    }

    public static enum MODE {
        ROOT_ONLY,
        AUTO_ONLY,
        BOTH;

    }
}

