/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.webdav.pathresolver;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Properties;
import org.aarboard.nextcloud.api.exception.NextcloudApiException;
import org.aarboard.nextcloud.api.webdav.pathresolver.WebDavPathResolverBuilder;

public class NextcloudVersion {
    private static final String PROPERTIES_PATH_PATTERN = "/org/aarboard/nextcloud/api/webdav/pathresolver/webdavpathresolver_{0}.properties";
    private static final String APPEND_USERNAME_PATTERN = "nextcloud.webdav.base.{0}.suffix.append.username";
    private final String versionValue;
    private Integer compatibleVersion = 20;
    private String major = "0";
    private String minor = "0";
    private String patch = "0";
    private String revision = "0";
    private Properties configProperties = new Properties();
    private WebDavPathResolverBuilder.TYPE webdavType = WebDavPathResolverBuilder.TYPE.FILES;

    NextcloudVersion(String versionValue) {
        this.versionValue = versionValue;
        this.paresVersionString(versionValue);
        this.loadValues();
    }

    public static NextcloudVersion get(String value) {
        if (null == value) {
            throw new IllegalArgumentException("Version value cannot be null !");
        }
        if (value.trim().isEmpty()) {
            throw new IllegalArgumentException("Version value cannot be empty !");
        }
        return new NextcloudVersion(value);
    }

    public NextcloudVersion ofType(WebDavPathResolverBuilder.TYPE _type) {
        this.webdavType = _type;
        return this;
    }

    public String getWebdavBasePath() {
        return this.configProperties.getProperty("nextcloud.webdav.base.path");
    }

    public boolean isAppendUserName() {
        return Boolean.parseBoolean(this.configProperties.getProperty(MessageFormat.format(APPEND_USERNAME_PATTERN, this.webdavType.name().toLowerCase()), "false"));
    }

    public boolean isAppendSuffix() {
        return Boolean.parseBoolean(this.configProperties.getProperty(MessageFormat.format(APPEND_USERNAME_PATTERN, this.webdavType.name().toLowerCase()), "false"));
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch + "." + this.revision + ", compatible with [" + this.compatibleVersion + "]";
    }

    private void paresVersionString(String value) {
        String[] values = value.split("\\.");
        if (values.length > 0) {
            this.major = values[0];
            this.compatibleVersion = Integer.parseInt(this.major);
        }
        if (values.length > 1) {
            this.minor = values[1];
        }
        if (values.length > 2) {
            this.patch = values[2];
        }
        if (values.length > 3) {
            this.revision = values[3];
        }
        this.compatibleVersion = this.compatibleVersion > 14 ? Integer.valueOf(20) : Integer.valueOf(14);
    }

    private void loadValues() {
        try (InputStream inStream = this.getClass().getResourceAsStream(MessageFormat.format(PROPERTIES_PATH_PATTERN, this.compatibleVersion.toString()));){
            this.configProperties.load(inStream);
        }
        catch (IOException ex) {
            throw new NextcloudApiException(ex);
        }
    }
}

