/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.webdav;

import com.github.sardine.DavResource;
import com.github.sardine.Sardine;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.aarboard.nextcloud.api.ServerConfig;
import org.aarboard.nextcloud.api.exception.NextcloudApiException;
import org.aarboard.nextcloud.api.webdav.AWebdavHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Folders
extends AWebdavHandler {
    private static final Logger LOG = LoggerFactory.getLogger(Folders.class);

    public Folders(ServerConfig serverConfig) {
        super(serverConfig);
    }

    @Deprecated
    public List<String> getFolders(String remotePath) {
        return this.listFolderContent(remotePath);
    }

    public List<String> listFolderContent(String remotePath) {
        return this.listFolderContent(remotePath, 1);
    }

    public List<String> listFolderContent(String remotePath, int depth) {
        return this.listFolderContent(remotePath, depth, false, false);
    }

    public List<String> listFolderContent(String remotePath, int depth, boolean excludeFolderNames, boolean returnFullPath) {
        List resources;
        String pathPrefix = this.getWebdavPathPrefix();
        String path = this.buildWebdavPath(remotePath);
        LinkedList<String> retVal = new LinkedList<String>();
        Sardine sardine = this.buildAuthSardine();
        try {
            resources = sardine.list(path, depth);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn("error in closing sardine connector", (Throwable)ex);
            }
        }
        for (DavResource res : resources) {
            if (excludeFolderNames && res.isDirectory()) continue;
            if (returnFullPath) {
                if (res.getPath().startsWith(pathPrefix)) {
                    retVal.add(res.getPath().substring(pathPrefix.length()));
                    continue;
                }
                LOG.error("Unhandled edge case, path prefix {} does not match built prefix {}", (Object)res.getPath(), (Object)path);
                retVal.add(res.getPath());
                continue;
            }
            retVal.add(res.getName());
        }
        return retVal;
    }

    public boolean exists(String remotePath) {
        return this.pathExists(remotePath);
    }

    public void createFolder(String remotePath) {
        String path = this.buildWebdavPath(remotePath);
        Sardine sardine = this.buildAuthSardine();
        try {
            sardine.createDirectory(path);
        }
        catch (IOException e) {
            throw new NextcloudApiException(e);
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn("error in closing sardine connector", (Throwable)ex);
            }
        }
    }

    public void deleteFolder(String remotePath) {
        this.deletePath(remotePath);
    }

    public void renameFolder(String oldPath, String newPath, boolean overwriteExisting) {
        this.renamePath(oldPath, newPath, overwriteExisting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadFolder(String remotePath, String rootDownloadDirPath) throws IOException {
        int depth = 1;
        String[] segments = remotePath.split("/");
        String folderName = segments[segments.length - 1];
        String newDownloadDir = rootDownloadDirPath + "/" + folderName;
        File nefile1 = new File(newDownloadDir);
        if (!nefile1.exists()) {
            LOG.info("Creating new download directory: " + newDownloadDir);
            nefile1.mkdir();
        }
        String listPathURL = this.buildWebdavPath(remotePath);
        int count = 0;
        LinkedList<String> retVal = new LinkedList<String>();
        Sardine sardine = this.buildAuthSardine();
        try {
            List resources;
            try {
                resources = sardine.list(listPathURL, depth);
            }
            catch (IOException e) {
                throw new NextcloudApiException(e);
            }
            for (DavResource res : resources) {
                System.out.println(res.getName());
                if (count != 0) {
                    String fileName;
                    if (res.isDirectory()) {
                        fileName = res.getName();
                        String pathtosend = remotePath + "/" + fileName;
                        this.downloadFolder(pathtosend, newDownloadDir);
                    } else {
                        fileName = res.getName();
                        String filePath = this.buildWebdavPath(remotePath + "/" + fileName);
                        retVal.add(res.getName());
                        InputStream in = null;
                        if (sardine.exists(filePath)) {
                            in = sardine.get(filePath);
                            byte[] buffer = new byte[4096];
                            File targetFile = new File(newDownloadDir + "/" + fileName);
                            try (FileOutputStream outStream = new FileOutputStream(targetFile);){
                                int bytesRead;
                                while ((bytesRead = in.read(buffer)) != -1) {
                                    ((OutputStream)outStream).write(buffer, 0, bytesRead);
                                }
                                outStream.flush();
                                ((OutputStream)outStream).close();
                            }
                        }
                    }
                }
                ++count;
            }
        }
        finally {
            try {
                sardine.shutdown();
            }
            catch (IOException ex) {
                LOG.warn("error in closing sardine connector", (Throwable)ex);
            }
        }
    }
}

