/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api.filesharing;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.aarboard.nextcloud.api.ServerConfig;
import org.aarboard.nextcloud.api.exception.MoreThanOneShareFoundException;
import org.aarboard.nextcloud.api.filesharing.Share;
import org.aarboard.nextcloud.api.filesharing.SharePermissions;
import org.aarboard.nextcloud.api.filesharing.ShareType;
import org.aarboard.nextcloud.api.filesharing.SharesXMLAnswer;
import org.aarboard.nextcloud.api.filesharing.SingleShareXMLAnswer;
import org.aarboard.nextcloud.api.provisioning.ShareData;
import org.aarboard.nextcloud.api.utils.ConnectorCommon;
import org.aarboard.nextcloud.api.utils.NextcloudResponseHelper;
import org.aarboard.nextcloud.api.utils.XMLAnswer;
import org.aarboard.nextcloud.api.utils.XMLAnswerParser;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class FilesharingConnector {
    private static final String ROOT_PART = "ocs/v1.php/apps/files_sharing/api/v1/";
    private static final String SHARES_PART = "ocs/v1.php/apps/files_sharing/api/v1/shares";
    private final ConnectorCommon connectorCommon;

    public FilesharingConnector(ServerConfig serverConfig) {
        this.connectorCommon = new ConnectorCommon(serverConfig);
    }

    public List<Share> getShares() {
        return this.getShares(null, false, false);
    }

    public CompletableFuture<SharesXMLAnswer> getSharesAsync() {
        return this.getSharesAsync(null, false, false);
    }

    public List<Share> getShares(String path, boolean reShares, boolean subShares) {
        return NextcloudResponseHelper.getAndCheckStatus(this.getSharesAsync(path, reShares, subShares)).getShares();
    }

    public CompletableFuture<SharesXMLAnswer> getSharesAsync(String path, boolean reShares, boolean subShares) {
        LinkedList<NameValuePair> queryParams = new LinkedList<NameValuePair>();
        if (path != null) {
            queryParams.add((NameValuePair)new BasicNameValuePair("path", path));
        }
        if (reShares) {
            queryParams.add((NameValuePair)new BasicNameValuePair("reshares", "true"));
        }
        if (subShares) {
            queryParams.add((NameValuePair)new BasicNameValuePair("subfiles", "true"));
        }
        return this.connectorCommon.executeGet(SHARES_PART, queryParams, XMLAnswerParser.getInstance(SharesXMLAnswer.class));
    }

    public Share getShareInfo(int shareId) {
        SharesXMLAnswer xa = NextcloudResponseHelper.getAndCheckStatus(this.getShareInfoAsync(shareId));
        if (xa.getShares() == null) {
            return null;
        }
        if (xa.getShares().size() == 1) {
            return xa.getShares().get(0);
        }
        throw new MoreThanOneShareFoundException(shareId);
    }

    public CompletableFuture<SharesXMLAnswer> getShareInfoAsync(int shareId) {
        return this.connectorCommon.executeGet("ocs/v1.php/apps/files_sharing/api/v1/shares/" + Integer.toString(shareId), null, XMLAnswerParser.getInstance(SharesXMLAnswer.class));
    }

    public Share doShare(String path, ShareType shareType, String shareWithUserOrGroupIdOrEmail, Boolean publicUpload, String password, SharePermissions permissions) {
        return NextcloudResponseHelper.getAndCheckStatus(this.doShareAsync(path, shareType, shareWithUserOrGroupIdOrEmail, publicUpload, password, permissions)).getShare();
    }

    public CompletableFuture<SingleShareXMLAnswer> doShareAsync(String path, ShareType shareType, String shareWithUserOrGroupIdOrEmail, Boolean publicUpload, String password, SharePermissions permissions) {
        LinkedList<NameValuePair> postParams = new LinkedList<NameValuePair>();
        postParams.add((NameValuePair)new BasicNameValuePair("path", path));
        postParams.add((NameValuePair)new BasicNameValuePair("shareType", Integer.toString(shareType.getIntValue())));
        postParams.add((NameValuePair)new BasicNameValuePair("shareWith", shareWithUserOrGroupIdOrEmail));
        if (publicUpload != null) {
            postParams.add((NameValuePair)new BasicNameValuePair("publicUpload", publicUpload != false ? "true" : "false"));
        }
        if (password != null) {
            postParams.add((NameValuePair)new BasicNameValuePair("password", password));
        }
        if (permissions != null) {
            postParams.add((NameValuePair)new BasicNameValuePair("permissions", Integer.toString(permissions.getCurrentPermission())));
        }
        return this.connectorCommon.executePost(SHARES_PART, postParams, XMLAnswerParser.getInstance(SingleShareXMLAnswer.class));
    }

    public boolean editShare(int shareId, ShareData key, String value) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.editShareAsync(shareId, key, value));
    }

    public CompletableFuture<XMLAnswer> editShareAsync(int shareId, ShareData key, String value) {
        List<BasicNameValuePair> queryParams = Collections.singletonList(new BasicNameValuePair(key.parameterName, value));
        return this.connectorCommon.executePut(SHARES_PART, Integer.toString(shareId), queryParams, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public boolean editShare(int shareId, Map<ShareData, String> values) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.editShareAsync(shareId, values));
    }

    public CompletableFuture<XMLAnswer> editShareAsync(int shareId, Map<ShareData, String> values) {
        List<NameValuePair> queryParams = values.entrySet().stream().map(e -> new BasicNameValuePair(((ShareData)((Object)((Object)e.getKey()))).parameterName, (String)e.getValue())).collect(Collectors.toList());
        return this.connectorCommon.executePut(SHARES_PART, Integer.toString(shareId), queryParams, XMLAnswerParser.getInstance(XMLAnswer.class));
    }

    public boolean deleteShare(int shareId) {
        return NextcloudResponseHelper.isStatusCodeOkay(this.deleteShareAsync(shareId));
    }

    public CompletableFuture<XMLAnswer> deleteShareAsync(int shareId) {
        return this.connectorCommon.executeDelete(SHARES_PART, Integer.toString(shareId), null, XMLAnswerParser.getInstance(XMLAnswer.class));
    }
}

