/*
 * Decompiled with CFR 0.152.
 */
package org.aarboard.nextcloud.api;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.aarboard.nextcloud.api.AuthenticationConfig;
import org.aarboard.nextcloud.api.ServerConfig;
import org.aarboard.nextcloud.api.config.ConfigConnector;
import org.aarboard.nextcloud.api.filesharing.FilesharingConnector;
import org.aarboard.nextcloud.api.filesharing.Share;
import org.aarboard.nextcloud.api.filesharing.SharePermissions;
import org.aarboard.nextcloud.api.filesharing.ShareType;
import org.aarboard.nextcloud.api.filesharing.SharesXMLAnswer;
import org.aarboard.nextcloud.api.filesharing.SingleShareXMLAnswer;
import org.aarboard.nextcloud.api.provisioning.GroupListAnswer;
import org.aarboard.nextcloud.api.provisioning.ProvisionConnector;
import org.aarboard.nextcloud.api.provisioning.ShareData;
import org.aarboard.nextcloud.api.provisioning.User;
import org.aarboard.nextcloud.api.provisioning.UserData;
import org.aarboard.nextcloud.api.provisioning.UserDetailsAnswer;
import org.aarboard.nextcloud.api.provisioning.UserDetailsListAnswer;
import org.aarboard.nextcloud.api.provisioning.UserListAnswer;
import org.aarboard.nextcloud.api.utils.ConnectorCommon;
import org.aarboard.nextcloud.api.utils.JsonListAnswer;
import org.aarboard.nextcloud.api.utils.JsonVoidAnswer;
import org.aarboard.nextcloud.api.utils.NextcloudResponseHelper;
import org.aarboard.nextcloud.api.utils.XMLAnswer;
import org.aarboard.nextcloud.api.webdav.Files;
import org.aarboard.nextcloud.api.webdav.Folders;
import org.aarboard.nextcloud.api.webdav.ResourceProperties;
import org.aarboard.nextcloud.api.webdav.pathresolver.NextcloudVersion;
import org.aarboard.nextcloud.api.webdav.pathresolver.WebDavPathResolver;
import org.aarboard.nextcloud.api.webdav.pathresolver.WebDavPathResolverBuilder;

public class NextcloudConnector {
    private final ServerConfig _serverConfig;
    private final ProvisionConnector pc;
    private final FilesharingConnector fc;
    private final ConfigConnector cc;
    private final Folders fd;
    private final Files fl;

    public NextcloudConnector(String serverName, boolean useHTTPS, int port, String loginName, String password) {
        this(serverName, useHTTPS, port, new AuthenticationConfig(loginName, password));
    }

    public NextcloudConnector(String serverName, boolean useHTTPS, int port, String bearerToken) {
        this(serverName, useHTTPS, port, new AuthenticationConfig(bearerToken));
    }

    public NextcloudConnector(String serviceUrl, String loginName, String password) {
        this(serviceUrl, new AuthenticationConfig(loginName, password));
    }

    public NextcloudConnector(String serviceUrl, String bearerToken) {
        this(serviceUrl, new AuthenticationConfig(bearerToken));
    }

    public NextcloudConnector(String serviceUrl, AuthenticationConfig authenticationConfig) {
        try {
            URL _serviceUrl = new URL(serviceUrl);
            boolean useHTTPS = serviceUrl.startsWith("https");
            this._serverConfig = new ServerConfig(_serviceUrl.getHost(), useHTTPS, _serviceUrl.getPort(), authenticationConfig);
            if (!_serviceUrl.getPath().isEmpty()) {
                this._serverConfig.setSubPathPrefix(_serviceUrl.getPath());
            }
            this.pc = new ProvisionConnector(this._serverConfig);
            this.fc = new FilesharingConnector(this._serverConfig);
            this.cc = new ConfigConnector(this._serverConfig);
            this.fd = new Folders(this._serverConfig);
            this.fl = new Files(this._serverConfig);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public NextcloudConnector(String serverName, boolean useHTTPS, int port, AuthenticationConfig authenticationConfig) {
        this._serverConfig = new ServerConfig(serverName, useHTTPS, port, authenticationConfig);
        this.pc = new ProvisionConnector(this._serverConfig);
        this.fc = new FilesharingConnector(this._serverConfig);
        this.cc = new ConfigConnector(this._serverConfig);
        this.fd = new Folders(this._serverConfig);
        this.fl = new Files(this._serverConfig);
    }

    public String getServerVersion() {
        return this.fl.getServerVersion();
    }

    public void setWebDavPathResolver(WebDavPathResolver resolver) {
        this.fd.setWebDavPathResolver(resolver);
        this.fl.setWebDavPathResolver(resolver);
    }

    public void setWebDavPathResolverAsType(WebDavPathResolverBuilder.TYPE type) {
        WebDavPathResolver resolver = WebDavPathResolverBuilder.get(type).ofVersion(NextcloudVersion.get(this.getServerVersion())).withUserName(this.getCurrentUser().getId()).withBasePathPrefix(this._serverConfig.getSubPathPrefix()).build();
        this.fd.setWebDavPathResolver(resolver);
        this.fl.setWebDavPathResolver(resolver);
    }

    public void shutdown() throws IOException {
        ConnectorCommon.shutdown();
    }

    public void trustAllCertificates(boolean trustAllCertificates) {
        this._serverConfig.setTrustAllCertificates(trustAllCertificates);
    }

    public void setSubpathPrefix(String subpathPrefix) {
        this._serverConfig.setSubPathPrefix(subpathPrefix);
    }

    public boolean createUser(String userId, String password) {
        CompletableFuture<JsonVoidAnswer> result = this.createUserAsync(userId, password);
        return NextcloudResponseHelper.isStatusCodeOkay(result);
    }

    public boolean createUser(String userId, String password, String displayName, String email, String quota, String language, List<String> groups) {
        CompletableFuture<JsonVoidAnswer> result = this.createUserAsync(userId, password, Optional.of(displayName), Optional.of(email), Optional.of(quota), Optional.of(language), groups);
        return NextcloudResponseHelper.isStatusCodeOkay(result);
    }

    public CompletableFuture<JsonVoidAnswer> createUserAsync(String userId, String password) {
        return this.pc.createUserAsync(userId, password, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Collections.emptyList());
    }

    public CompletableFuture<JsonVoidAnswer> createUserAsync(String userId, String password, Optional<String> displayName, Optional<String> email, Optional<String> quota, Optional<String> language, List<String> groups) {
        return this.pc.createUserAsync(userId, password, displayName, email, quota, language, groups);
    }

    public boolean deleteUser(String userId) {
        return this.pc.deleteUser(userId);
    }

    public CompletableFuture<JsonVoidAnswer> deleteUserAsync(String userId) {
        return this.pc.deleteUserAsync(userId);
    }

    public boolean enableUser(String userId) {
        return this.pc.enableUser(userId);
    }

    public CompletableFuture<JsonVoidAnswer> enableUserAsync(String userId) {
        return this.pc.enableUserAsync(userId);
    }

    public boolean disableUser(String userId) {
        return this.pc.disableUser(userId);
    }

    public CompletableFuture<JsonVoidAnswer> disableUserAsync(String userId) {
        return this.pc.disableUserAsync(userId);
    }

    public List<String> getGroupsOfUser(String userId) {
        return this.pc.getGroupsOfUser(userId);
    }

    public CompletableFuture<GroupListAnswer> getGroupsOfUserAsync(String userId) {
        return this.pc.getGroupsOfUserAsync(userId);
    }

    public boolean addUserToGroup(String userId, String groupId) {
        return this.pc.addUserToGroup(userId, groupId);
    }

    public CompletableFuture<JsonVoidAnswer> addUserToGroupAsync(String userId, String groupId) {
        return this.pc.addUserToGroupAsync(userId, groupId);
    }

    public boolean removeUserFromGroup(String userId, String groupId) {
        return this.pc.removeUserFromGroup(userId, groupId);
    }

    public CompletableFuture<JsonVoidAnswer> removeUserFromGroupAsync(String userId, String groupId) {
        return this.pc.removeUserFromGroupAsync(userId, groupId);
    }

    public List<String> getSubadminGroupsOfUser(String userId) {
        return this.pc.getSubadminGroupsOfUser(userId);
    }

    public CompletableFuture<JsonListAnswer> getSubadminGroupsOfUserAsync(String userId) {
        return this.pc.getSubadminGroupsOfUserAsync(userId);
    }

    public boolean promoteToSubadmin(String userId, String groupId) {
        return this.pc.promoteToSubadmin(userId, groupId);
    }

    public CompletableFuture<JsonVoidAnswer> promoteToSubadminAsync(String userId, String groupId) {
        return this.pc.promoteToSubadminAsync(userId, groupId);
    }

    public boolean demoteSubadmin(String userId, String groupId) {
        return this.pc.demoteSubadmin(userId, groupId);
    }

    public CompletableFuture<JsonVoidAnswer> demoteSubadminAsync(String userId, String groupId) {
        return this.pc.demoteSubadminAsync(userId, groupId);
    }

    public boolean sendWelcomeMail(String userId) {
        return this.pc.sendWelcomeMail(userId);
    }

    public CompletableFuture<JsonVoidAnswer> sendWelcomeMailAsync(String userId) {
        return this.pc.sendWelcomeMailAsync(userId);
    }

    public List<String> getMembersOfGroup(String groupId) {
        return this.pc.getMembersOfGroup(groupId);
    }

    public CompletableFuture<UserListAnswer> getMembersOfGroupAsync(String groupId) {
        return this.pc.getMembersOfGroupAsync(groupId);
    }

    public List<User> getMembersDetailsOfGroup(String groupId) {
        return this.pc.getMembersDetailsOfGroup(groupId);
    }

    public CompletableFuture<UserDetailsListAnswer> getMembersDetailsOfGroupAsync(String groupId) {
        return this.pc.getMembersDetailsOfGroupAsync(groupId);
    }

    public List<String> getSubadminsOfGroup(String groupId) {
        return this.pc.getSubadminsOfGroup(groupId);
    }

    public CompletableFuture<JsonListAnswer> getSubadminsOfGroupAsync(String groupId) {
        return this.pc.getSubadminsOfGroupAsync(groupId);
    }

    public boolean createGroup(String groupId) {
        return this.pc.createGroup(groupId);
    }

    public CompletableFuture<JsonVoidAnswer> createGroupAsync(String groupId) {
        return this.pc.createGroupAsync(groupId);
    }

    public List<String> getUsers() {
        return this.pc.getAllUsers();
    }

    public List<String> getUsers(String search, int limit, int offset) {
        return this.pc.getAllUsers(search, limit, offset);
    }

    public CompletableFuture<UserListAnswer> getUsersAsync() {
        return this.pc.getAllUsersAsync();
    }

    public CompletableFuture<UserListAnswer> getUsersAsync(String search, int limit, int offset) {
        return this.pc.getAllUsersAsync(search, limit, offset);
    }

    public List<User> getUsersDetails() {
        return this.pc.getAllUserDetails();
    }

    public List<User> getUsersDetails(String search, int limit, int offset) {
        return this.pc.getAllUserDetails(search, limit, offset);
    }

    public CompletableFuture<UserDetailsListAnswer> getUsersDetailsAsync() {
        return this.pc.getAllUserDetailsAsync();
    }

    public CompletableFuture<UserDetailsListAnswer> getUsersDetailsAsync(String search, int limit, int offset) {
        return this.pc.getAllUserDetailsAsync(search, limit, offset);
    }

    public User getUser(String userId) {
        return this.pc.getUser(userId);
    }

    public CompletableFuture<UserDetailsAnswer> getUserAsync(String userId) {
        return this.pc.getUserAsync(userId);
    }

    public User getCurrentUser() {
        return this.pc.getCurrentUser();
    }

    public boolean editUser(String userId, UserData key, String value) {
        return this.pc.editUser(userId, key, value);
    }

    public CompletableFuture<JsonVoidAnswer> editUserAsync(String userId, UserData key, String value) {
        return this.pc.editUserAsync(userId, key, value);
    }

    public boolean deleteGroup(String groupId) {
        return this.pc.deleteGroup(groupId);
    }

    public CompletableFuture<JsonVoidAnswer> deleteGroupAsync(String groupId) {
        return this.pc.deleteGroupAsync(groupId);
    }

    public CompletableFuture<GroupListAnswer> getGroupsAsync() {
        return this.pc.getGroupsAsync();
    }

    public List<String> getGroups() {
        return this.pc.getGroups();
    }

    public List<String> getGroups(String search, int limit, int offset) {
        return this.pc.getGroups(search, limit, offset);
    }

    public CompletableFuture<GroupListAnswer> getGroupsAsync(String search, int limit, int offset) {
        return this.pc.getGroupsAsync(search, limit, offset);
    }

    @Deprecated
    public List<String> getFolders(String path) {
        return this.fd.getFolders(path);
    }

    public List<String> listFolderContent(String path) {
        return this.fd.listFolderContent(path);
    }

    public List<String> listFolderContent(String path, int depth) {
        return this.fd.listFolderContent(path, depth);
    }

    public List<String> listFolderContent(String path, int depth, boolean excludeFolderNames) {
        return this.fd.listFolderContent(path, depth, excludeFolderNames, false);
    }

    public List<String> listFolderContent(String path, int depth, boolean excludeFolderNames, boolean returnFullPath) {
        return this.fd.listFolderContent(path, depth, excludeFolderNames, returnFullPath);
    }

    public boolean folderExists(String path) {
        return this.fd.exists(path);
    }

    public void createFolder(String path) {
        this.fd.createFolder(path);
    }

    public void deleteFolder(String path) {
        this.fd.deleteFolder(path);
    }

    public void renameFile(String oldPath, String newPath, boolean overwriteExisting) {
        this.fd.renamePath(oldPath, newPath, overwriteExisting);
    }

    public Share doShare(String path, ShareType shareType, String shareWithUserOrGroupId, Boolean publicUpload, String password, SharePermissions permissions) {
        return this.fc.doShare(path, shareType, shareWithUserOrGroupId, publicUpload, password, permissions);
    }

    public CompletableFuture<SingleShareXMLAnswer> doShareAsync(String path, ShareType shareType, String shareWithUserOrGroupId, Boolean publicUpload, String password, SharePermissions permissions) {
        return this.fc.doShareAsync(path, shareType, shareWithUserOrGroupId, publicUpload, password, permissions);
    }

    public boolean deleteShare(int shareId) {
        return this.fc.deleteShare(shareId);
    }

    public CompletableFuture<XMLAnswer> deleteShareAsync(int shareId) {
        return this.fc.deleteShareAsync(shareId);
    }

    public List<Share> getShares() {
        return this.fc.getShares();
    }

    public CompletableFuture<SharesXMLAnswer> getSharesAsync() {
        return this.fc.getSharesAsync();
    }

    public void uploadFile(File srcFile, String remotePath) {
        this.fl.uploadFile(srcFile, remotePath);
    }

    public void uploadFile(InputStream inputStream, String remotePath) {
        this.fl.uploadFile(inputStream, remotePath);
    }

    public void uploadFile(InputStream inputStream, String remotePath, boolean continueHeader) {
        this.fl.uploadFile(inputStream, remotePath, continueHeader);
    }

    public void removeFile(String path) {
        this.fl.removeFile(path);
    }

    public boolean fileExists(String path) {
        return this.fl.fileExists(path);
    }

    public ResourceProperties getProperties(String path, boolean allProperties) throws IOException {
        return this.fl.getProperties(path, allProperties);
    }

    public Collection<Share> getShares(String path, boolean reShares, boolean subShares) {
        return this.fc.getShares(path, reShares, subShares);
    }

    public CompletableFuture<SharesXMLAnswer> getSharesAsync(String path, boolean reShares, boolean subShares) {
        return this.fc.getSharesAsync(path, reShares, subShares);
    }

    public Share getShareInfo(int shareId) {
        return this.fc.getShareInfo(shareId);
    }

    public CompletableFuture<SharesXMLAnswer> getShareInfoAsync(int shareId) {
        return this.fc.getShareInfoAsync(shareId);
    }

    public boolean editShare(int shareId, ShareData key, String value) {
        return this.fc.editShare(shareId, key, value);
    }

    public CompletableFuture<XMLAnswer> editShareAsync(int shareId, ShareData key, String value) {
        return this.fc.editShareAsync(shareId, key, value);
    }

    public boolean editShare(int shareId, Map<ShareData, String> values) {
        return this.fc.editShare(shareId, values);
    }

    public CompletableFuture<XMLAnswer> editShareAsync(int shareId, Map<ShareData, String> values) {
        return this.fc.editShareAsync(shareId, values);
    }

    public boolean downloadFile(String remotepath, String downloadpath) throws IOException {
        return this.fl.downloadFile(remotepath, downloadpath);
    }

    public InputStream downloadFile(String remotepath) throws IOException {
        return this.fl.downloadFile(remotepath);
    }

    public void downloadFolder(String remotepath, String downloadpath) throws IOException {
        this.fd.downloadFolder(remotepath, downloadpath);
    }

    public List<String> getAppConfigApps() {
        return this.cc.getAppConfigApps();
    }

    public List<String> getAppConfigAppKeys(String appConfigApp) {
        return this.cc.getAppConfigAppKeys(appConfigApp);
    }

    public String getAppConfigAppKeyValue(String appConfigApp, String appConfigAppKey) {
        return this.cc.getAppConfigAppKeyValue(appConfigApp, appConfigAppKey);
    }

    public String getAppConfigAppKeyValue(String appConfigAppKeyPath) {
        return this.cc.getAppConfigAppKeyValue(appConfigAppKeyPath);
    }

    public boolean setAppConfigAppKeyValue(String appConfigApp, String appConfigAppKey, Object value) {
        return this.cc.setAppConfigAppKeyValue(appConfigApp, appConfigAppKey, value);
    }

    public boolean setAppConfigAppKeyValue(String appConfigAppKeyPath, Object value) {
        return this.cc.setAppConfigAppKeyValue(appConfigAppKeyPath, value);
    }

    public boolean deleteAppConfigAppKeyEntry(String appConfigApp, String appConfigAppkey) {
        return this.cc.deleteAppConfigAppKeyEntry(appConfigApp, appConfigAppkey);
    }
}

