/*
 * Copyright 2017 Gabor Varadi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.zhuinden.simplestack;

import android.os.Parcelable;

/**
 * Default key parceler implementation that assumes your keys are Parcelable.
 */
public class DefaultKeyParceler
        implements KeyParceler {
    @Override
    public Parcelable toParcelable(Object object) {
        return (Parcelable) object;
    }

    @Override
    public Object fromParcelable(Parcelable parcelable) {
        return parcelable;
    }
}
