/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.content.Context;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.History;
import com.zhuinden.simplestack.KeyContextWrapper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StateChange {
    public static final int REPLACE = 0;
    public static final int BACKWARD = -1;
    public static final int FORWARD = 1;
    Backstack backstack;
    List<Object> previousKeys;
    List<Object> newKeys;
    int direction;

    StateChange(Backstack backstack, List<Object> previousKeys, List<Object> newKeys, int direction) {
        this.backstack = backstack;
        this.previousKeys = previousKeys;
        this.newKeys = newKeys;
        this.direction = direction;
    }

    @Nonnull
    public Backstack getBackstack() {
        return this.backstack;
    }

    public final boolean isTopNewKeyEqualToPrevious() {
        return this.topNewKey().equals(this.topPreviousKey());
    }

    private <T> History<T> createParametricCopyList(List<Object> list) {
        LinkedList<Object> copyList = new LinkedList<Object>();
        for (Object key : list) {
            copyList.add(key);
        }
        return History.from(copyList);
    }

    @Nonnull
    public <T> History<T> getPreviousKeys() {
        return this.createParametricCopyList(this.previousKeys);
    }

    @Nonnull
    public <T> History<T> getNewKeys() {
        return this.createParametricCopyList(this.newKeys);
    }

    public int getDirection() {
        return this.direction;
    }

    @Nullable
    public <T> T topPreviousKey() {
        if (this.previousKeys.size() > 0) {
            return (T)this.previousKeys.get(this.previousKeys.size() - 1);
        }
        return null;
    }

    @Nonnull
    public <T> T topNewKey() {
        return (T)this.newKeys.get(this.newKeys.size() - 1);
    }

    @Nonnull
    public Context createContext(@Nonnull Context base, @Nonnull Object key) {
        return new KeyContextWrapper(base, key);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface StateChangeDirection {
    }
}

