/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack.navigator;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.ViewGroup;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.GlobalServices;
import com.zhuinden.simplestack.KeyFilter;
import com.zhuinden.simplestack.KeyParceler;
import com.zhuinden.simplestack.ScopedServices;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.simplestack.navigator.Navigator;
import com.zhuinden.statebundle.StateBundle;
import java.util.Collections;
import java.util.List;

@TargetApi(value=11)
public final class BackstackHost
extends Fragment {
    StateChanger stateChanger;
    KeyFilter keyFilter;
    KeyParceler keyParceler;
    Backstack.StateClearStrategy stateClearStrategy;
    ScopedServices scopedServices;
    GlobalServices globalServices;
    GlobalServices.Factory globalServiceFactory;
    List<Backstack.CompletionListener> stateChangeCompletionListeners;
    boolean shouldPersistContainerChild;
    Backstack backstack;
    List<?> initialKeys = Collections.emptyList();
    ViewGroup container;
    Bundle savedInstanceState;

    public BackstackHost() {
        this.setRetainInstance(true);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.savedInstanceState = savedInstanceState;
    }

    Backstack initialize(boolean isInitializeDeferred) {
        if (this.backstack == null) {
            this.backstack = new Backstack();
            this.backstack.setKeyFilter(this.keyFilter);
            this.backstack.setKeyParceler(this.keyParceler);
            this.backstack.setStateClearStrategy(this.stateClearStrategy);
            if (this.scopedServices != null) {
                this.backstack.setScopedServices(this.scopedServices);
            }
            if (this.globalServices != null) {
                this.backstack.setGlobalServices(this.globalServices);
            }
            if (this.globalServiceFactory != null) {
                this.backstack.setGlobalServices(this.globalServiceFactory);
            }
            this.backstack.setup(this.initialKeys);
            for (Backstack.CompletionListener completionListener : this.stateChangeCompletionListeners) {
                this.backstack.addStateChangeCompletionListener(completionListener);
            }
            if (this.savedInstanceState != null) {
                this.backstack.fromBundle((StateBundle)this.savedInstanceState.getParcelable("NAVIGATOR_STATE_BUNDLE"));
            }
        }
        if (!isInitializeDeferred) {
            this.backstack.setStateChanger(this.stateChanger);
        }
        return this.backstack;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.shouldPersistContainerChild) {
            Navigator.persistViewToState(this.container.getChildAt(0));
        }
        outState.putParcelable("NAVIGATOR_STATE_BUNDLE", (Parcelable)this.backstack.toBundle());
    }

    public void onResume() {
        super.onResume();
        this.backstack.reattachStateChanger();
    }

    public void onPause() {
        this.backstack.detachStateChanger();
        super.onPause();
    }

    public void onDestroyView() {
        this.backstack.executePendingStateChange();
        this.stateChanger = null;
        this.container = null;
        super.onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        this.backstack.finalizeScopes();
    }

    public Backstack getBackstack() {
        return this.backstack;
    }
}

