/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.support.annotation.NonNull;
import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;

public class SimpleStateChanger
implements StateChanger {
    private final NavigationHandler navigationHandler;

    public SimpleStateChanger(@NonNull NavigationHandler navigationHandler) {
        if (navigationHandler == null) {
            throw new NullPointerException("navigationHandler should not be null!");
        }
        this.navigationHandler = navigationHandler;
    }

    @Override
    public void handleStateChange(@NonNull StateChange stateChange, @NonNull StateChanger.Callback completionCallback) {
        if (stateChange.isTopNewKeyEqualToPrevious()) {
            completionCallback.stateChangeComplete();
            return;
        }
        this.navigationHandler.onNavigationEvent(stateChange);
        completionCallback.stateChangeComplete();
    }

    public static interface NavigationHandler {
        public void onNavigationEvent(@NonNull StateChange var1);
    }
}

