/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.DefaultKeyFilter;
import com.zhuinden.simplestack.DefaultKeyParceler;
import com.zhuinden.simplestack.DefaultStateClearStrategy;
import com.zhuinden.simplestack.GlobalServices;
import com.zhuinden.simplestack.KeyFilter;
import com.zhuinden.simplestack.KeyParceler;
import com.zhuinden.simplestack.SavedState;
import com.zhuinden.simplestack.ScopeKey;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopedServices;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.statebundle.StateBundle;
import java.util.LinkedList;
import java.util.List;

@Deprecated
public class BackstackDelegate {
    private Backstack backstack;
    private static final String UNINITIALIZED = "";
    private String persistenceTag = "";
    private boolean activityWasDestroyed = false;
    private static final String HISTORY = "simplestack.HISTORY";
    private Activity activity;
    private StateChanger stateChanger;
    private KeyFilter keyFilter = new DefaultKeyFilter();
    private KeyParceler keyParceler = new DefaultKeyParceler();
    private ScopedServices scopedServices = null;
    private GlobalServices globalServices = null;
    private GlobalServices.Factory globalServiceFactory = null;
    private Backstack.StateClearStrategy stateClearStrategy = new DefaultStateClearStrategy();
    private List<Backstack.CompletionListener> stateChangeCompletionListeners = new LinkedList<Backstack.CompletionListener>();

    public void setKeyFilter(@NonNull KeyFilter keyFilter) {
        if (this.backstack != null && this.backstack.isInitialized()) {
            throw new IllegalStateException("If set, key filter must be set before calling `onCreate()`");
        }
        if (keyFilter == null) {
            throw new IllegalArgumentException("Specified custom key filter should not be null!");
        }
        this.keyFilter = keyFilter;
    }

    public void setKeyParceler(@NonNull KeyParceler keyParceler) {
        if (this.backstack != null && this.backstack.isInitialized()) {
            throw new IllegalStateException("If set, key parceler must set before calling `onCreate()`");
        }
        if (keyParceler == null) {
            throw new IllegalArgumentException("Specified custom key parceler should not be null!");
        }
        this.keyParceler = keyParceler;
    }

    public void setStateClearStrategy(@NonNull Backstack.StateClearStrategy stateClearStrategy) {
        if (this.backstack != null && this.backstack.isInitialized()) {
            throw new IllegalStateException("If set, state clear strategy must be set before calling `onCreate()`");
        }
        if (stateClearStrategy == null) {
            throw new IllegalArgumentException("Specified state clear strategy should not be null!");
        }
        this.stateClearStrategy = stateClearStrategy;
    }

    public void setScopedServices(@Nullable Activity activity, @NonNull ScopedServices scopedServices) {
        this.activity = activity;
        if (scopedServices == null) {
            throw new IllegalArgumentException("Specified scoped services should not be null!");
        }
        if (!this.activityWasDestroyed && this.backstack != null && this.backstack.isInitialized()) {
            throw new IllegalStateException("If set, scoped services must set before calling `onCreate()`");
        }
        this.activityWasDestroyed = false;
        this.scopedServices = scopedServices;
    }

    public void setGlobalServices(@Nullable Activity activity, @NonNull GlobalServices globalServices) {
        this.activity = activity;
        if (globalServices == null) {
            throw new IllegalArgumentException("Specified global services should not be null!");
        }
        if (!this.activityWasDestroyed && this.backstack != null && this.backstack.isInitialized()) {
            throw new IllegalStateException("If set, global services must set before calling `onCreate()`");
        }
        this.activityWasDestroyed = false;
        this.globalServices = globalServices;
    }

    public void setGlobalServices(@Nullable Activity activity, @NonNull GlobalServices.Factory globalServiceFactory) {
        this.activity = activity;
        if (globalServiceFactory == null) {
            throw new IllegalArgumentException("Specified global service factory should not be null!");
        }
        if (!this.activityWasDestroyed && this.backstack != null && this.backstack.isInitialized()) {
            throw new IllegalStateException("If set, global service factory must set before calling `onCreate()`");
        }
        this.activityWasDestroyed = false;
        this.globalServiceFactory = globalServiceFactory;
    }

    public void addStateChangeCompletionListener(@NonNull Backstack.CompletionListener stateChangeCompletionListener) {
        if (this.backstack != null && this.backstack.isInitialized()) {
            throw new IllegalStateException("If adding, completion listener must be added before calling `onCreate()`");
        }
        if (stateChangeCompletionListener == null) {
            throw new IllegalArgumentException("Specified state change completion listener should not be null!");
        }
        this.stateChangeCompletionListeners.add(stateChangeCompletionListener);
    }

    public void setPersistenceTag(@NonNull String persistenceTag) {
        if (this.backstack != null && this.backstack.isInitialized()) {
            throw new IllegalStateException("Persistence tag should be set before calling `onCreate()`");
        }
        if (persistenceTag == null) {
            throw new IllegalArgumentException("Null persistence tag is not allowed!");
        }
        if (this.persistenceTag == UNINITIALIZED) {
            this.persistenceTag = persistenceTag;
        } else if (!this.persistenceTag.equals(persistenceTag)) {
            throw new IllegalStateException("The persistence tag cannot be set to a new value once it's already set!");
        }
    }

    String getHistoryTag() {
        return UNINITIALIZED.equals(this.persistenceTag) ? HISTORY : HISTORY + this.persistenceTag;
    }

    public BackstackDelegate() {
        this(null);
    }

    public BackstackDelegate(@Nullable StateChanger stateChanger) {
        this.stateChanger = stateChanger;
    }

    @TargetApi(value=14)
    public void registerForLifecycleCallbacks(final @NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("Activity is null");
        }
        Backstack backstack = this.getBackstack();
        final Application application = activity.getApplication();
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity a, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity a) {
                if (activity == a) {
                    // empty if block
                }
            }

            public void onActivityResumed(Activity a) {
                if (activity == a) {
                    BackstackDelegate.this.onPostResume();
                }
            }

            public void onActivityPaused(Activity a) {
                if (activity == a) {
                    BackstackDelegate.this.onPause();
                }
            }

            public void onActivityStopped(Activity a) {
                if (activity == a) {
                    // empty if block
                }
            }

            public void onActivitySaveInstanceState(Activity a, Bundle outState) {
                if (activity == a) {
                    BackstackDelegate.this.onSaveInstanceState(outState);
                }
            }

            public void onActivityDestroyed(Activity a) {
                if (activity == a) {
                    BackstackDelegate.this.onDestroy();
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
                }
            }
        });
    }

    public void onCreate(@Nullable Bundle savedInstanceState, @Nullable Object nonConfigurationInstance, @NonNull List<?> initialKeys) {
        if (nonConfigurationInstance != null && !(nonConfigurationInstance instanceof NonConfigurationInstance)) {
            throw new IllegalArgumentException("The provided non configuration instance must be of type BackstackDelegate.NonConfigurationInstance!");
        }
        NonConfigurationInstance nonConfig = (NonConfigurationInstance)nonConfigurationInstance;
        if (nonConfig != null) {
            this.backstack = nonConfig.getBackstack();
        }
        if (this.backstack == null) {
            this.backstack = new Backstack();
            this.backstack.setKeyFilter(this.keyFilter);
            this.backstack.setKeyParceler(this.keyParceler);
            this.backstack.setStateClearStrategy(this.stateClearStrategy);
            if (this.scopedServices != null) {
                this.backstack.setScopedServices(this.scopedServices);
            }
            if (this.globalServices != null) {
                this.backstack.setGlobalServices(this.globalServices);
            }
            if (this.globalServiceFactory != null) {
                this.backstack.setGlobalServices(this.globalServiceFactory);
            }
            this.backstack.setup(initialKeys);
            for (Backstack.CompletionListener completionListener : this.stateChangeCompletionListeners) {
                this.backstack.addStateChangeCompletionListener(completionListener);
            }
            if (savedInstanceState != null) {
                this.backstack.fromBundle((StateBundle)savedInstanceState.getParcelable(this.getHistoryTag()));
            }
        }
        this.backstack.setStateChanger(this.stateChanger);
    }

    public void setStateChanger(@Nullable StateChanger stateChanger) {
        this.stateChanger = stateChanger;
        if (this.backstack != null) {
            this.backstack.setStateChanger(stateChanger);
        }
    }

    public NonConfigurationInstance onRetainCustomNonConfigurationInstance() {
        return new NonConfigurationInstance(this.backstack);
    }

    public boolean onBackPressed() {
        return this.getBackstack().goBack();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        Backstack backstack = this.getBackstack();
        outState.putParcelable(this.getHistoryTag(), (Parcelable)backstack.toBundle());
    }

    public void onPostResume() {
        if (this.stateChanger == null) {
            throw new IllegalStateException("State changer is still not set in `onPostResume`!");
        }
        this.getBackstack().reattachStateChanger();
    }

    public void onPause() {
        this.getBackstack().detachStateChanger();
    }

    public void onDestroy() {
        this.activityWasDestroyed = true;
        this.getBackstack().executePendingStateChange();
        if (this.activity == null || this.activity != null && this.activity.isFinishing()) {
            this.getBackstack().finalizeScopes();
        }
        this.activity = null;
    }

    public void persistViewToState(@Nullable View view) {
        this.getBackstack().persistViewToState(view);
    }

    public void restoreViewFromState(@NonNull View view) {
        this.getBackstack().restoreViewFromState(view);
    }

    @NonNull
    public SavedState getSavedState(@NonNull Object key) {
        return this.getBackstack().getSavedState(key);
    }

    public boolean hasScope(@NonNull String scopeTag) {
        return this.getBackstack().hasScope(scopeTag);
    }

    public boolean hasService(@NonNull ScopeKey scopeKey, @NonNull String serviceTag) {
        return this.getBackstack().hasService(scopeKey, serviceTag);
    }

    public boolean hasService(@NonNull String scopeTag, @NonNull String serviceTag) {
        return this.getBackstack().hasService(scopeTag, serviceTag);
    }

    @NonNull
    public <T> T getService(@NonNull ScopeKey scopeKey, @NonNull String serviceTag) {
        return this.getBackstack().getService(scopeKey, serviceTag);
    }

    @NonNull
    public <T> T getService(@NonNull String scopeTag, @NonNull String serviceTag) {
        return this.getBackstack().getService(scopeTag, serviceTag);
    }

    public boolean canFindService(@NonNull String serviceTag) {
        return this.getBackstack().canFindService(serviceTag);
    }

    @NonNull
    public <T> T lookupService(@NonNull String serviceTag) {
        return this.getBackstack().lookupService(serviceTag);
    }

    @NonNull
    public List<String> findScopesForKey(@NonNull Object key, @NonNull ScopeLookupMode lookupMode) {
        return this.getBackstack().findScopesForKey(key, lookupMode);
    }

    public boolean canFindFromScope(@NonNull String scopeTag, @NonNull String serviceTag) {
        return this.getBackstack().canFindFromScope(scopeTag, serviceTag);
    }

    public boolean canFindFromScope(@NonNull String scopeTag, @NonNull String serviceTag, @NonNull ScopeLookupMode lookupMode) {
        return this.getBackstack().canFindFromScope(scopeTag, serviceTag, lookupMode);
    }

    @NonNull
    public <T> T lookupFromScope(@NonNull String scopeTag, @NonNull String serviceTag) {
        return this.getBackstack().lookupFromScope(scopeTag, serviceTag);
    }

    @NonNull
    public <T> T lookupFromScope(@NonNull String scopeTag, @NonNull String serviceTag, @NonNull ScopeLookupMode lookupMode) {
        return this.getBackstack().lookupFromScope(scopeTag, serviceTag, lookupMode);
    }

    @NonNull
    public Backstack getBackstack() {
        if (this.backstack == null) {
            throw new IllegalStateException("This method can only be called after calling `onCreate()`");
        }
        return this.backstack;
    }

    public static class NonConfigurationInstance {
        private Backstack backstack;

        NonConfigurationInstance(Backstack backstack) {
            this.backstack = backstack;
        }

        Backstack getBackstack() {
            return this.backstack;
        }
    }
}

