/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.Bundleable;
import com.zhuinden.simplestack.GlobalServices;
import com.zhuinden.simplestack.ScopeKey;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopeNode;
import com.zhuinden.simplestack.ScopedServices;
import com.zhuinden.simplestack.ServiceBinder;
import com.zhuinden.statebundle.StateBundle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ScopeManager {
    static final String GLOBAL_SCOPE_TAG = "__SIMPLE_STACK_INTERNAL_GLOBAL_SCOPE__";
    private static final GlobalServices EMPTY_GLOBAL_SERVICES = GlobalServices.builder().build();
    private final IdentityHashMap<Object, Set<String>> scopeEnteredServices = new IdentityHashMap();
    private final IdentityHashMap<Object, Set<String>> scopeActivatedServices = new IdentityHashMap();
    private final IdentityHashMap<Object, Integer> untrackEventInvocationTracker = new IdentityHashMap();
    private boolean isGlobalScopePendingActivation = true;
    private GlobalServices globalServices = EMPTY_GLOBAL_SERVICES;
    private ScopedServices scopedServices = new AssertingScopedServices();
    private Backstack backstack;
    private final Map<String, ScopeNode> scopes = new LinkedHashMap<String, ScopeNode>();
    private final StateBundle rootBundle = new StateBundle();
    private List<Object> latestKeys = null;
    private boolean isFinalized = false;

    void activateGlobalScope() {
        this.notifyScopeActivation(GLOBAL_SCOPE_TAG, this.globalServices.getScope());
    }

    void deactivateGlobalScope() {
        this.notifyScopeDeactivation(GLOBAL_SCOPE_TAG, this.globalServices.getScope());
    }

    ScopeManager() {
    }

    void setBackstack(Backstack backstack) {
        this.backstack = backstack;
    }

    Backstack getBackstack() {
        return this.backstack;
    }

    private List<String> getActiveScopesReverse() {
        ArrayList<String> activeScopes = new ArrayList<String>(this.scopes.keySet());
        Collections.reverse(activeScopes);
        return activeScopes;
    }

    void setScopedServices(ScopedServices scopedServices) {
        this.scopedServices = scopedServices;
    }

    void setGlobalServices(GlobalServices globalServices) {
        this.globalServices = globalServices;
    }

    private void buildGlobalScope() {
        if (!this.scopes.containsKey(GLOBAL_SCOPE_TAG)) {
            ScopeNode scope = this.globalServices.getScope();
            this.scopes.put(GLOBAL_SCOPE_TAG, scope);
            this.restoreAndNotifyServices(GLOBAL_SCOPE_TAG, scope);
        }
    }

    private void buildScope(Object key, String scopeTag) {
        if (scopeTag == null) {
            throw new IllegalArgumentException("Scope tag provided by scope key cannot be null!");
        }
        if (!this.scopes.containsKey(scopeTag)) {
            ScopeNode scope = new ScopeNode();
            this.scopes.put(scopeTag, scope);
            this.scopedServices.bindServices(new ServiceBinder(this, key, scopeTag, scope));
            this.restoreAndNotifyServices(scopeTag, scope);
        }
    }

    private void restoreAndNotifyServices(String scopeTag, ScopeNode scope) {
        for (Map.Entry<String, Object> serviceEntry : scope.services()) {
            String serviceTag = serviceEntry.getKey();
            Object service = serviceEntry.getValue();
            if (this.isServiceNotRegistered(service)) {
                StateBundle scopeBundle;
                if (this.rootBundle.containsKey(scopeTag) && service instanceof Bundleable && (scopeBundle = this.rootBundle.getBundle(scopeTag)) != null && scopeBundle.containsKey(serviceTag)) {
                    ((Bundleable)service).fromBundle(scopeBundle.getBundle(serviceTag));
                }
                if (service instanceof ScopedServices.Registered) {
                    ((ScopedServices.Registered)service).onServiceRegistered();
                }
            }
            if (!this.isServiceNotTrackedInScope(this.scopeEnteredServices, service, scopeTag)) continue;
            this.trackServiceInScope(this.scopeEnteredServices, service, scopeTag);
        }
    }

    private boolean isServiceNotRegistered(Object service) {
        return !this.scopeEnteredServices.containsKey(service) || this.scopeEnteredServices.get(service).isEmpty();
    }

    private boolean isServiceNotActivated(Object service) {
        return !this.scopeActivatedServices.containsKey(service) || this.scopeActivatedServices.get(service).isEmpty();
    }

    private boolean isServiceNotTrackedInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        return !scopeEventTracker.containsKey(service) || !scopeEventTracker.get(service).contains(scopeTag);
    }

    private void trackServiceInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        Set<String> trackedScopes = scopeEventTracker.get(service);
        if (trackedScopes == null) {
            trackedScopes = new LinkedHashSet<String>();
            scopeEventTracker.put(service, trackedScopes);
        }
        trackedScopes.add(scopeTag);
    }

    private void untrackServiceInScope(Map<Object, Set<String>> scopeEventTracker, Object service, String scopeTag) {
        Set<String> trackedScopes = scopeEventTracker.get(service);
        trackedScopes.remove(scopeTag);
        if (trackedScopes.isEmpty()) {
            scopeEventTracker.remove(service);
        }
    }

    boolean isFinalized() {
        return this.isFinalized;
    }

    void finalizeScopes() {
        this.isFinalized = true;
        this.destroyScope(GLOBAL_SCOPE_TAG);
        this.latestKeys = null;
    }

    void buildScopes(List<Object> newState) {
        if (this.isFinalized) {
            this.isFinalized = false;
            this.isGlobalScopePendingActivation = true;
        }
        if (this.latestKeys == null) {
            this.buildGlobalScope();
        }
        this.latestKeys = newState;
        for (Object key : newState) {
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                for (String parent : child.getParentScopes()) {
                    this.buildScope(key, parent);
                }
            }
            if (!(key instanceof ScopeKey)) continue;
            ScopeKey scopeKey = (ScopeKey)key;
            String scopeTag = scopeKey.getScopeTag();
            this.buildScope(key, scopeTag);
        }
    }

    void clearScopesNotIn(List<Object> newState) {
        LinkedHashSet<String> currentScopes = new LinkedHashSet<String>();
        currentScopes.add(GLOBAL_SCOPE_TAG);
        for (Object key : newState) {
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                currentScopes.addAll(child.getParentScopes());
            }
            if (!(key instanceof ScopeKey)) continue;
            ScopeKey scopeKey = (ScopeKey)key;
            currentScopes.add(scopeKey.getScopeTag());
        }
        List<String> scopeSet = this.getActiveScopesReverse();
        for (String activeScope : scopeSet) {
            if (currentScopes.contains(activeScope)) continue;
            this.destroyScope(activeScope);
        }
    }

    void destroyScope(String scopeTag) {
        if (this.scopes.containsKey(scopeTag)) {
            ScopeNode serviceMap = this.scopes.remove(scopeTag);
            this.destroyServicesAndRemoveState(scopeTag, serviceMap);
        }
    }

    private void destroyServicesAndRemoveState(String scopeTag, ScopeNode serviceMap) {
        Set<Map.Entry<String, Object>> services = serviceMap.services();
        ArrayList<Object> previousServices = new ArrayList<Object>(services.size());
        for (Map.Entry<String, Object> entry : services) {
            previousServices.add(entry.getValue());
        }
        Collections.reverse(previousServices);
        this.untrackEventInvocationTracker.clear();
        for (Map.Entry<String, Object> entry : previousServices) {
            if (!this.isServiceNotTrackedInScope(this.scopeEnteredServices, entry, scopeTag)) {
                this.untrackServiceInScope(this.scopeEnteredServices, entry, scopeTag);
            }
            if (!this.isServiceNotRegistered(entry) || !(entry instanceof ScopedServices.Registered) || this.untrackEventInvocationTracker.containsKey(entry)) continue;
            this.untrackEventInvocationTracker.put(entry, 1);
            ((ScopedServices.Registered)((Object)entry)).onServiceUnregistered();
        }
        this.rootBundle.remove(scopeTag);
    }

    void dispatchActivation(@NonNull Set<String> scopesToDeactivate, @NonNull Set<String> scopesToActivate) {
        if (this.isGlobalScopePendingActivation) {
            this.isGlobalScopePendingActivation = false;
            this.activateGlobalScope();
        }
        for (String newScopeTag : scopesToActivate) {
            if (!this.scopes.containsKey(newScopeTag)) {
                throw new AssertionError((Object)"The new scope should exist, but it doesn't! This shouldn't happen. If you see this error, this functionality is broken.");
            }
            ScopeNode newScope = this.scopes.get(newScopeTag);
            this.notifyScopeActivation(newScopeTag, newScope);
        }
        for (String previousScopeTag : scopesToDeactivate) {
            if (!this.scopes.containsKey(previousScopeTag)) {
                throw new AssertionError((Object)"The previous scope should exist, but it doesn't! This shouldn't happen. If you see this error, this functionality is broken.");
            }
            ScopeNode previousServiceMap = this.scopes.get(previousScopeTag);
            this.notifyScopeDeactivation(previousScopeTag, previousServiceMap);
        }
    }

    private void notifyScopeActivation(String newScopeTag, ScopeNode newScope) {
        for (Map.Entry<String, Object> entry : newScope.services()) {
            Object service = entry.getValue();
            if (this.isServiceNotActivated(service) && service instanceof ScopedServices.Activated) {
                ((ScopedServices.Activated)service).onServiceActive();
            }
            if (!this.isServiceNotTrackedInScope(this.scopeActivatedServices, service, newScopeTag)) continue;
            this.trackServiceInScope(this.scopeActivatedServices, service, newScopeTag);
        }
    }

    private void notifyScopeDeactivation(String previousScopeTag, ScopeNode previousScope) {
        Set<Map.Entry<String, Object>> services = previousScope.services();
        ArrayList<Object> previousServices = new ArrayList<Object>(services.size());
        for (Map.Entry<String, Object> entry : services) {
            previousServices.add(entry.getValue());
        }
        Collections.reverse(previousServices);
        this.untrackEventInvocationTracker.clear();
        for (Map.Entry<String, Object> entry : previousServices) {
            if (!this.isServiceNotTrackedInScope(this.scopeActivatedServices, entry, previousScopeTag)) {
                this.untrackServiceInScope(this.scopeActivatedServices, entry, previousScopeTag);
            }
            if (!this.isServiceNotActivated(entry) || !(entry instanceof ScopedServices.Activated) || this.untrackEventInvocationTracker.containsKey(entry)) continue;
            this.untrackEventInvocationTracker.put(entry, 1);
            ((ScopedServices.Activated)((Object)entry)).onServiceInactive();
        }
    }

    StateBundle saveStates() {
        StateBundle rootBundle = new StateBundle();
        for (Map.Entry<String, ScopeNode> scopeSet : this.scopes.entrySet()) {
            String scopeKey = scopeSet.getKey();
            ScopeNode services = scopeSet.getValue();
            StateBundle scopeBundle = new StateBundle();
            for (Map.Entry<String, Object> serviceEntry : services.services()) {
                String serviceTag = serviceEntry.getKey();
                Object service = serviceEntry.getValue();
                if (!(service instanceof Bundleable)) continue;
                scopeBundle.putBundle(serviceTag, ((Bundleable)service).toBundle());
            }
            rootBundle.putBundle(scopeKey, scopeBundle);
        }
        return rootBundle;
    }

    void setRestoredStates(StateBundle rootBundle) {
        if (rootBundle != null) {
            this.rootBundle.putAll(rootBundle);
        }
    }

    boolean hasService(@NonNull String scopeTag, @NonNull String serviceTag) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        if (!this.scopes.containsKey(scopeTag)) {
            return false;
        }
        ScopeNode services = this.scopes.get(scopeTag);
        return services.hasService(serviceTag);
    }

    @NonNull
    <T> T getService(@NonNull String scopeTag, @NonNull String serviceTag) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        if (!this.scopes.containsKey(scopeTag)) {
            throw new IllegalArgumentException("The specified scope with tag [" + scopeTag + "] does not exist!");
        }
        ScopeNode services = this.scopes.get(scopeTag);
        if (!services.hasService(serviceTag)) {
            throw new IllegalArgumentException("The specified service with tag [" + serviceTag + "] does not exist in scope [" + scopeTag + "]! Did you accidentally try to use the same scope tag with different services?");
        }
        return services.getService(serviceTag);
    }

    boolean hasScope(@NonNull String scopeTag) {
        ScopeManager.checkScopeTag(scopeTag);
        return this.scopes.containsKey(scopeTag);
    }

    @NonNull
    Set<String> findScopesForKey(@NonNull Object key, @NonNull ScopeLookupMode lookupMode) {
        ScopeManager.checkKey(key);
        ScopeManager.checkScopeLookupMode(lookupMode);
        return lookupMode.executeFindScopesForKey(this, key);
    }

    @NonNull
    private LinkedHashSet<String> _findScopesForKey(@NonNull Object targetKey, boolean explicitOnly) {
        LinkedHashSet<String> activeScopes = new LinkedHashSet<String>();
        boolean isKeyFound = false;
        for (int i = this.latestKeys.size() - 1; i >= 0; --i) {
            Object key = this.latestKeys.get(i);
            if (targetKey.equals(key)) {
                isKeyFound = true;
            }
            if (!isKeyFound) continue;
            if (key instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)key;
                String currentScope = scopeKey.getScopeTag();
                activeScopes.add(currentScope);
            }
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                List<String> parentScopes = child.getParentScopes();
                for (int j = parentScopes.size() - 1; j >= 0; --j) {
                    String currentScope = parentScopes.get(j);
                    activeScopes.add(currentScope);
                }
            }
            if (explicitOnly) break;
        }
        return activeScopes;
    }

    @NonNull
    private LinkedHashSet<String> _findScopesForScopeTag(@Nullable String scopeTag, boolean explicitOnly) {
        LinkedHashSet<String> activeScopes = new LinkedHashSet<String>();
        if (this.latestKeys == null) {
            return activeScopes;
        }
        List<Object> latestKeys = this.latestKeys;
        boolean isScopeFound = scopeTag == null;
        for (int i = latestKeys.size() - 1; i >= 0; --i) {
            Object key = latestKeys.get(i);
            if (key instanceof ScopeKey) {
                ScopeKey scopeKey = (ScopeKey)key;
                String currentScope = scopeKey.getScopeTag();
                if (!isScopeFound && currentScope.equals(scopeTag)) {
                    isScopeFound = true;
                }
                if (isScopeFound) {
                    activeScopes.add(currentScope);
                }
            }
            if (key instanceof ScopeKey.Child) {
                ScopeKey.Child child = (ScopeKey.Child)key;
                ScopeManager.checkParentScopes(child);
                List<String> parentScopes = child.getParentScopes();
                for (int j = parentScopes.size() - 1; j >= 0; --j) {
                    String currentScope = parentScopes.get(j);
                    if (!isScopeFound && currentScope.equals(scopeTag)) {
                        isScopeFound = true;
                    }
                    if (!isScopeFound) continue;
                    activeScopes.add(currentScope);
                }
            }
            if (explicitOnly && isScopeFound) break;
        }
        return activeScopes;
    }

    @NonNull
    Set<String> findScopesForKeyAll(Object targetKey) {
        if (this.latestKeys == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> activeScopes = this._findScopesForKey(targetKey, false);
        if (!this.isFinalized && !this.globalServices.isEmpty()) {
            activeScopes.add(GLOBAL_SCOPE_TAG);
        }
        return Collections.unmodifiableSet(activeScopes);
    }

    @NonNull
    Set<String> findScopesForKeyExplicit(Object targetKey) {
        if (this.latestKeys == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> activeScopes = this._findScopesForKey(targetKey, true);
        if (!this.isFinalized && !this.globalServices.isEmpty()) {
            activeScopes.add(GLOBAL_SCOPE_TAG);
        }
        return Collections.unmodifiableSet(activeScopes);
    }

    boolean canFindFromScope(String scopeTag, String serviceTag, ScopeLookupMode lookupMode) {
        ScopeManager.checkServiceTag(serviceTag);
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkScopeLookupMode(lookupMode);
        return lookupMode.executeCanFindFromService(this, scopeTag, serviceTag);
    }

    boolean canFindFromScopeExplicit(String scopeTag, String identifier) {
        if (this.latestKeys == null) {
            return false;
        }
        LinkedHashSet<String> activeScopes = this._findScopesForScopeTag(scopeTag, true);
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return true;
        }
        return !this.isFinalized && this.globalServices.hasService(identifier);
    }

    boolean canFindFromScopeAll(String scopeTag, String identifier) {
        if (this.latestKeys == null) {
            return false;
        }
        LinkedHashSet<String> activeScopes = this._findScopesForScopeTag(scopeTag, false);
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return true;
        }
        return !this.isFinalized && this.globalServices.hasService(identifier);
    }

    <T> T lookupFromScope(String scopeTag, String serviceTag, ScopeLookupMode lookupMode) {
        ScopeManager.checkScopeTag(scopeTag);
        ScopeManager.checkServiceTag(serviceTag);
        ScopeManager.checkScopeLookupMode(lookupMode);
        return lookupMode.executeLookupFromScope(this, scopeTag, serviceTag);
    }

    <T> T lookupFromScopeExplicit(String scopeTag, String identifier) {
        this.verifyStackIsInitialized();
        LinkedHashSet<String> activeScopes = this._findScopesForScopeTag(scopeTag, true);
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return scopeNode.getService(identifier);
        }
        if (!this.isFinalized && this.globalServices.hasService(identifier)) {
            return this.globalServices.getService(identifier);
        }
        throw new IllegalStateException("The service [" + identifier + "] does not exist in any scope that is accessible from [" + scopeTag + "], scopes are [" + Arrays.toString(activeScopes.toArray()) + "]!");
    }

    <T> T lookupFromScopeAll(String scopeTag, String identifier) {
        this.verifyStackIsInitialized();
        LinkedHashSet<String> activeScopes = this._findScopesForScopeTag(scopeTag, false);
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return scopeNode.getService(identifier);
        }
        if (!this.isFinalized && this.globalServices.hasService(identifier)) {
            return this.globalServices.getService(identifier);
        }
        throw new IllegalStateException("The service [" + identifier + "] does not exist in any scope that is accessible from [" + scopeTag + "], scopes are [" + Arrays.toString(activeScopes.toArray()) + "]!");
    }

    boolean canFindService(@NonNull String identifier) {
        ScopeManager.checkServiceTag(identifier);
        List<String> activeScopes = this.getActiveScopesReverse();
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return true;
        }
        return !this.isFinalized && this.globalServices.hasService(identifier);
    }

    @NonNull
    <T> T lookupService(@NonNull String identifier) {
        ScopeManager.checkServiceTag(identifier);
        this.verifyStackIsInitialized();
        LinkedHashSet<String> activeScopes = this._findScopesForScopeTag(null, false);
        for (String scope : activeScopes) {
            ScopeNode scopeNode = this.scopes.get(scope);
            if (scopeNode == null || !scopeNode.hasService(identifier)) continue;
            return scopeNode.getService(identifier);
        }
        if (!this.isFinalized && this.globalServices.hasService(identifier)) {
            return this.globalServices.getService(identifier);
        }
        throw new IllegalStateException("The service [" + identifier + "] does not exist in any scopes, which are " + Arrays.toString(activeScopes.toArray()) + "! Is the scope tag registered via a ScopeKey? If yes, make sure the StateChanger has been set by this time, and that you've bound and are trying to lookup the service with the correct service tag. Otherwise, it is likely that the scope you intend to inherit the service from does not exist.");
    }

    private void verifyStackIsInitialized() {
        if (this.latestKeys == null) {
            throw new IllegalStateException("Cannot lookup from an empty stack.");
        }
    }

    private static void checkKey(@NonNull Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
    }

    private static void checkScopeTag(@NonNull String scopeTag) {
        if (scopeTag == null) {
            throw new IllegalArgumentException("Scope tag cannot be null!");
        }
    }

    private static void checkServiceTag(@NonNull String serviceTag) {
        if (serviceTag == null) {
            throw new IllegalArgumentException("Service tag cannot be null!");
        }
    }

    static void checkParentScopes(ScopeKey.Child child) {
        if (child.getParentScopes() == null) {
            throw new IllegalArgumentException("Parent scopes cannot be null!");
        }
    }

    private static void checkScopeLookupMode(ScopeLookupMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("Mode cannot be null!");
        }
    }

    static class AssertingScopedServices
    implements ScopedServices {
        AssertingScopedServices() {
        }

        @Override
        public void bindServices(@NonNull ServiceBinder serviceBinder) {
            throw new IllegalStateException("No scoped services are defined. To create scoped services, an instance of ScopedServices must be provided to configure the services that are available in a given scope.");
        }
    }
}

