/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.History;
import com.zhuinden.simplestack.PendingStateChange;
import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

class NavigationCore {
    static final int INITIALIZE = 0;
    static final int REATTACH = 1;
    private final List<Object> originalStack = new ArrayList<Object>();
    private final List<Object> initialKeys;
    private List<Object> initialParameters;
    private List<Object> stack = this.originalStack;
    private LinkedList<PendingStateChange> queuedStateChanges = new LinkedList();
    private StateChanger stateChanger;
    private Backstack backstack;
    private final long threadId = Thread.currentThread().getId();
    private LinkedList<Backstack.CompletionListener> completionListeners = new LinkedList();

    void setBackstack(Backstack backstack) {
        this.backstack = backstack;
    }

    public NavigationCore(Object ... initialKeys) {
        if (initialKeys == null || initialKeys.length <= 0) {
            throw new IllegalArgumentException("At least one initial key must be defined");
        }
        this.initialKeys = Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(initialKeys)));
        this.setInitialParameters(new ArrayList<Object>(this.initialKeys));
    }

    public NavigationCore(@NonNull List<?> initialKeys) {
        if (initialKeys == null) {
            throw new NullPointerException("Initial key list should not be null");
        }
        if (initialKeys.size() <= 0) {
            throw new IllegalArgumentException("Initial key list should contain at least one element");
        }
        this.initialKeys = Collections.unmodifiableList(new ArrayList(initialKeys));
        this.setInitialParameters(new ArrayList<Object>(this.initialKeys));
    }

    void setInitialParameters(List<?> initialKeys) {
        if (initialKeys == null || initialKeys.size() <= 0) {
            throw new IllegalArgumentException("At least one initial key must be defined");
        }
        this.initialParameters = new ArrayList(initialKeys);
    }

    @MainThread
    public boolean hasStateChanger() {
        this.assertCorrectThread();
        return this.stateChanger != null;
    }

    @MainThread
    public void setStateChanger(@NonNull StateChanger stateChanger) {
        this.setStateChanger(stateChanger, 0);
    }

    @MainThread
    public void setStateChanger(@NonNull StateChanger stateChanger, int registerMode) {
        if (stateChanger == null) {
            throw new NullPointerException("New state changer cannot be null");
        }
        this.assertCorrectThread();
        this.stateChanger = stateChanger;
        if (registerMode == 0 && (this.queuedStateChanges.size() <= 1 || this.stack.isEmpty())) {
            if (!this.beginStateChangeIfPossible()) {
                ArrayList newHistory = new ArrayList(this.selectActiveHistory());
                if (this.stack.isEmpty()) {
                    this.stack = this.initialParameters;
                }
                this.enqueueStateChange(newHistory, 0, true);
            }
            return;
        }
        this.beginStateChangeIfPossible();
    }

    @MainThread
    public void removeStateChanger() {
        this.assertCorrectThread();
        this.stateChanger = null;
    }

    @MainThread
    public void goTo(@NonNull Object newKey) {
        int direction;
        this.checkNewKey(newKey);
        this.assertCorrectThread();
        List<?> activeHistory = this.selectActiveHistory();
        History.Builder historyBuilder = History.builderFrom(activeHistory);
        if (historyBuilder.contains(newKey)) {
            historyBuilder.removeUntil(newKey);
            direction = -1;
        } else {
            historyBuilder.add(newKey);
            direction = 1;
        }
        this.setHistory(historyBuilder.build(), direction);
    }

    @MainThread
    public void replaceTop(@NonNull Object newTop, int direction) {
        this.checkNewKey(newTop);
        this.assertCorrectThread();
        History.Builder historyBuilder = History.builderFrom(this.selectActiveHistory());
        if (!historyBuilder.isEmpty()) {
            historyBuilder.removeLast();
        }
        historyBuilder.add(newTop);
        this.setHistory(historyBuilder.build(), direction);
    }

    @MainThread
    public void goUp(@NonNull Object newKey) {
        this.goUp(newKey, false);
    }

    @MainThread
    public void goUp(@NonNull Object newKey, boolean fallbackToBack) {
        this.checkNewKey(newKey);
        this.assertCorrectThread();
        List<?> activeHistory = this.selectActiveHistory();
        int size = activeHistory.size();
        if (size <= 1) {
            this.replaceTop(newKey, -1);
            return;
        }
        if (activeHistory.contains(newKey)) {
            if (fallbackToBack) {
                this.setHistory(History.builderFrom(activeHistory).removeLast().build(), -1);
            } else {
                this.goTo(newKey);
            }
        } else {
            this.replaceTop(newKey, -1);
        }
    }

    @MainThread
    public void moveToTop(@NonNull Object newKey, boolean asReplace) {
        this.checkNewKey(newKey);
        this.assertCorrectThread();
        List<?> activeHistory = this.selectActiveHistory();
        int direction = asReplace ? 0 : 1;
        History.Builder historyBuilder = History.builderFrom(activeHistory);
        if (historyBuilder.contains(newKey)) {
            historyBuilder.remove(newKey);
        }
        historyBuilder.add(newKey);
        this.setHistory(historyBuilder.build(), direction);
    }

    @MainThread
    public void moveToTop(@NonNull Object newKey) {
        this.moveToTop(newKey, false);
    }

    @MainThread
    public void jumpToRoot() {
        this.jumpToRoot(-1);
    }

    @MainThread
    public void jumpToRoot(int direction) {
        this.assertCorrectThread();
        List<?> activeHistory = this.selectActiveHistory();
        History<?> currentHistory = History.from(activeHistory);
        this.setHistory(History.of(new Object[]{currentHistory.root()}), direction);
    }

    @MainThread
    public void goUpChain(@NonNull List<?> parentChain) {
        this.goUpChain(parentChain, false);
    }

    @MainThread
    public void goUpChain(@NonNull List<?> parentChain, boolean fallbackToBack) {
        this.checkNewHistory(parentChain);
        this.assertCorrectThread();
        int parentChainSize = parentChain.size();
        if (parentChainSize == 1) {
            this.goUp(parentChain.get(0), fallbackToBack);
            return;
        }
        History.Builder historyBuilder = History.builderFrom(this.selectActiveHistory());
        historyBuilder.removeLast();
        int indexOfSubList = Collections.indexOfSubList(historyBuilder.build(), parentChain);
        if (indexOfSubList != -1) {
            if (fallbackToBack) {
                this.setHistory(historyBuilder.build(), -1);
            } else {
                this.goTo(parentChain.get(parentChainSize - 1));
            }
            return;
        }
        for (int i = 0; i < parentChainSize; ++i) {
            int j;
            Object key = parentChain.get(i);
            if (!historyBuilder.contains(key)) continue;
            int indexOfKey = historyBuilder.indexOf(key);
            History.Builder newHistory = History.newBuilder();
            for (j = 0; j < indexOfKey; ++j) {
                newHistory.add(historyBuilder.get(j));
            }
            for (j = 0; j < parentChainSize; ++j) {
                Object nextKey = parentChain.get(j);
                if (newHistory.contains(nextKey)) {
                    newHistory.remove(nextKey);
                }
                newHistory.add(nextKey);
            }
            this.setHistory(newHistory.build(), -1);
            return;
        }
        History.Builder newHistory = historyBuilder.addAll(parentChain);
        this.setHistory(newHistory.build(), -1);
    }

    @MainThread
    public boolean goBack() {
        this.assertCorrectThread();
        if (this.isStateChangePending()) {
            return true;
        }
        if (this.stack.size() <= 1) {
            return false;
        }
        List<?> activeHistory = this.selectActiveHistory();
        History.Builder historyBuilder = History.builderFrom(activeHistory);
        historyBuilder.removeLast();
        this.setHistory(historyBuilder.build(), -1);
        return true;
    }

    private void resetBackstack() {
        this.stack.clear();
        this.initialParameters = new ArrayList<Object>(this.initialKeys);
    }

    @MainThread
    public void forceClear() {
        this.assertCorrectThread();
        this.assertNoStateChange();
        this.resetBackstack();
    }

    @MainThread
    public void setHistory(@NonNull List<?> newHistory, int direction) {
        this.checkNewHistory(newHistory);
        this.assertCorrectThread();
        this.enqueueStateChange(newHistory, direction, false);
    }

    @NonNull
    public <K> K root() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Cannot obtain elements from an uninitialized NavigationCore.");
        }
        return (K)this.stack.get(0);
    }

    @NonNull
    public <K> K top() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("Cannot obtain elements from an uninitialized NavigationCore.");
        }
        return (K)this.stack.get(this.stack.size() - 1);
    }

    @NonNull
    public <K> K fromTop(int offset) {
        int size = this.stack.size();
        if (size <= 0) {
            throw new IllegalStateException("Cannot obtain elements from an uninitialized NavigationCore.");
        }
        if (offset < -size || offset >= size) {
            throw new IllegalArgumentException("The provided offset value [" + offset + "] was out of range: [" + -size + "; " + size + ")");
        }
        while (offset < 0) {
            offset += size;
        }
        int target = (size - 1 - (offset %= size)) % size;
        return (K)this.stack.get(target);
    }

    @NonNull
    public <K> History<K> getHistory() {
        ArrayList<Object> copy = new ArrayList<Object>(this.stack.size());
        for (Object key : this.stack) {
            copy.add(key);
        }
        return History.from(copy);
    }

    @NonNull
    public <K> History<K> getInitialKeys() {
        ArrayList<Object> copy = new ArrayList<Object>(this.initialKeys.size());
        for (Object key : this.initialKeys) {
            copy.add(key);
        }
        return History.from(copy);
    }

    public boolean isStateChangePending() {
        this.assertCorrectThread();
        return !this.queuedStateChanges.isEmpty();
    }

    private void enqueueStateChange(List<?> newHistory, int direction, boolean initialization) {
        PendingStateChange pendingStateChange = new PendingStateChange(newHistory, direction, initialization);
        this.queuedStateChanges.add(pendingStateChange);
        this.beginStateChangeIfPossible();
    }

    private List<?> selectActiveHistory() {
        if (this.stack.isEmpty() && this.queuedStateChanges.size() <= 0) {
            return this.initialParameters;
        }
        if (this.queuedStateChanges.size() <= 0) {
            return this.stack;
        }
        return this.queuedStateChanges.getLast().newHistory;
    }

    private boolean beginStateChangeIfPossible() {
        PendingStateChange pendingStateChange;
        if (this.hasStateChanger() && this.isStateChangePending() && (pendingStateChange = this.queuedStateChanges.getFirst()).getStatus() == PendingStateChange.Status.ENQUEUED) {
            pendingStateChange.setStatus(PendingStateChange.Status.IN_PROGRESS);
            this.changeState(pendingStateChange);
            return true;
        }
        return false;
    }

    private void changeState(final PendingStateChange pendingStateChange) {
        StateChanger.Callback completionCallback;
        boolean initialization = pendingStateChange.initialization;
        List<?> newHistory = pendingStateChange.newHistory;
        int direction = pendingStateChange.direction;
        List<Object> previousState = initialization ? Collections.emptyList() : new ArrayList<Object>(this.stack);
        final StateChange stateChange = new StateChange(this.backstack, Collections.unmodifiableList(previousState), Collections.unmodifiableList(newHistory), direction);
        pendingStateChange.completionCallback = completionCallback = new StateChanger.Callback(){

            @Override
            public void stateChangeComplete() {
                NavigationCore.this.assertCorrectThread();
                if (!pendingStateChange.didForceExecute) {
                    if (pendingStateChange.getStatus() == PendingStateChange.Status.COMPLETED) {
                        throw new IllegalStateException("State change completion cannot be called multiple times!");
                    }
                    NavigationCore.this.completeStateChange(stateChange);
                }
            }
        };
        this.stateChanger.handleStateChange(stateChange, completionCallback);
    }

    private void completeStateChange(StateChange stateChange) {
        if (this.initialParameters == this.stack) {
            this.stack = this.originalStack;
        }
        this.stack.clear();
        this.stack.addAll(stateChange.newKeys);
        PendingStateChange pendingStateChange = this.queuedStateChanges.removeFirst();
        pendingStateChange.setStatus(PendingStateChange.Status.COMPLETED);
        this.notifyCompletionListeners(stateChange);
        this.beginStateChangeIfPossible();
    }

    public void addCompletionListener(@NonNull Backstack.CompletionListener completionListener) {
        if (completionListener == null) {
            throw new IllegalArgumentException("Null completion listener cannot be added!");
        }
        this.assertCorrectThread();
        this.completionListeners.add(completionListener);
    }

    public void removeCompletionListener(@NonNull Backstack.CompletionListener completionListener) {
        if (completionListener == null) {
            throw new IllegalArgumentException("Null completion listener cannot be removed!");
        }
        this.assertCorrectThread();
        this.completionListeners.remove(completionListener);
    }

    public void removeCompletionListeners() {
        this.completionListeners.clear();
    }

    private void notifyCompletionListeners(StateChange stateChange) {
        for (Backstack.CompletionListener completionListener : this.completionListeners) {
            completionListener.stateChangeCompleted(stateChange);
        }
    }

    @MainThread
    public void executePendingStateChange() {
        PendingStateChange pendingStateChange;
        this.assertCorrectThread();
        if (this.isStateChangePending() && (pendingStateChange = this.queuedStateChanges.getFirst()).getStatus() == PendingStateChange.Status.IN_PROGRESS) {
            pendingStateChange.completionCallback.stateChangeComplete();
            pendingStateChange.didForceExecute = true;
        }
    }

    private void checkNewHistory(List<?> newHistory) {
        if (newHistory == null || newHistory.isEmpty()) {
            throw new IllegalArgumentException("New history cannot be null or empty");
        }
    }

    private void checkNewKey(Object newKey) {
        if (newKey == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
    }

    private void assertNoStateChange() {
        if (this.isStateChangePending()) {
            throw new IllegalStateException("This operation is not allowed while there are enqueued state changes.");
        }
    }

    private void assertCorrectThread() {
        if (Thread.currentThread().getId() != this.threadId) {
            throw new IllegalStateException("The backstack is not thread-safe, and must be manipulated only from the thread where it was originally created.");
        }
    }
}

