/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.BackstackManager;
import com.zhuinden.simplestack.DefaultKeyParceler;
import com.zhuinden.simplestack.DefaultStateClearStrategy;
import com.zhuinden.simplestack.KeyParceler;
import com.zhuinden.simplestack.SavedState;
import com.zhuinden.simplestack.StateBundle;
import com.zhuinden.simplestack.StateChanger;
import java.util.ArrayList;

public class BackstackDelegate {
    private BackstackManager backstackManager;
    private static final String UNINITIALIZED = "";
    private String persistenceTag = "";
    private static final String HISTORY = "simplestack.HISTORY";
    private StateChanger stateChanger;
    private KeyParceler keyParceler = new DefaultKeyParceler();
    private BackstackManager.StateClearStrategy stateClearStrategy = new DefaultStateClearStrategy();

    public void setKeyParceler(KeyParceler keyParceler) {
        if (keyParceler == null) {
            throw new IllegalArgumentException("Specified custom key parceler should not be null!");
        }
        this.keyParceler = keyParceler;
    }

    public void setStateClearStrategy(BackstackManager.StateClearStrategy stateClearStrategy) {
        if (stateClearStrategy == null) {
            throw new IllegalArgumentException("Specified state clear strategy should not be null!");
        }
        this.stateClearStrategy = stateClearStrategy;
    }

    public void setPersistenceTag(@NonNull String persistenceTag) {
        if (this.backstackManager != null && this.backstackManager.getBackstack() != null) {
            throw new IllegalStateException("Persistence tag should be set before calling `onCreate()`");
        }
        if (persistenceTag == null) {
            throw new IllegalArgumentException("Null persistence tag is not allowed!");
        }
        if (this.persistenceTag == UNINITIALIZED) {
            this.persistenceTag = persistenceTag;
        } else if (!this.persistenceTag.equals(persistenceTag)) {
            throw new IllegalStateException("The persistence tag cannot be set to a new value once it's already set!");
        }
    }

    String getHistoryTag() {
        return UNINITIALIZED.equals(this.persistenceTag) ? HISTORY : HISTORY + this.persistenceTag;
    }

    public BackstackDelegate(@Nullable StateChanger stateChanger) {
        this.stateChanger = stateChanger;
    }

    public void onCreate(@Nullable Bundle savedInstanceState, @Nullable Object nonConfigurationInstance, @NonNull ArrayList<Object> initialKeys) {
        if (nonConfigurationInstance != null && !(nonConfigurationInstance instanceof NonConfigurationInstance)) {
            throw new IllegalArgumentException("The provided non configuration instance must be of type BackstackDelegate.NonConfigurationInstance!");
        }
        NonConfigurationInstance nonConfig = (NonConfigurationInstance)nonConfigurationInstance;
        if (nonConfig != null) {
            this.backstackManager = nonConfig.getBackstackManager();
        }
        if (this.backstackManager == null) {
            this.backstackManager = new BackstackManager();
            this.backstackManager.setKeyParceler(this.keyParceler);
            this.backstackManager.setStateClearStrategy(this.stateClearStrategy);
            this.backstackManager.setup(initialKeys);
            if (savedInstanceState != null) {
                this.backstackManager.fromBundle((StateBundle)savedInstanceState.getParcelable(this.getHistoryTag()));
            }
        }
        this.backstackManager.setStateChanger(this.stateChanger);
    }

    public void setStateChanger(@Nullable StateChanger stateChanger) {
        this.stateChanger = stateChanger;
        this.backstackManager.setStateChanger(stateChanger);
    }

    public NonConfigurationInstance onRetainCustomNonConfigurationInstance() {
        return new NonConfigurationInstance(this.backstackManager);
    }

    public boolean onBackPressed() {
        return this.getBackstack().goBack();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        if (this.backstackManager == null) {
            throw new IllegalStateException("You can call this method only after `onCreate()`");
        }
        outState.putParcelable(this.getHistoryTag(), (Parcelable)this.backstackManager.toBundle());
    }

    public void onPostResume() {
        if (this.stateChanger == null) {
            throw new IllegalStateException("State changer is still not set in `onPostResume`!");
        }
        if (this.backstackManager == null) {
            throw new IllegalStateException("You can call this method only after `onCreate()`");
        }
        this.backstackManager.reattachStateChanger();
    }

    public void onPause() {
        if (this.backstackManager == null) {
            throw new IllegalStateException("You can call this method only after `onCreate()`");
        }
        this.backstackManager.detachStateChanger();
    }

    public void onDestroy() {
        this.getBackstack().executePendingStateChange();
    }

    @NonNull
    public Backstack getBackstack() {
        if (this.backstackManager == null) {
            throw new IllegalStateException("The backstack within the delegate must be initialized by `onCreate()`");
        }
        return this.backstackManager.getBackstack();
    }

    public void persistViewToState(@Nullable View view) {
        if (this.backstackManager == null) {
            throw new IllegalStateException("You can call this method only after `onCreate()`");
        }
        this.backstackManager.persistViewToState(view);
    }

    public void restoreViewFromState(@NonNull View view) {
        if (this.backstackManager == null) {
            throw new IllegalStateException("You can call this method only after `onCreate()`");
        }
        this.backstackManager.restoreViewFromState(view);
    }

    @NonNull
    public SavedState getSavedState(@NonNull Object key) {
        if (this.backstackManager == null) {
            throw new IllegalStateException("You can call this method only after `onCreate()`");
        }
        return this.backstackManager.getSavedState(key);
    }

    public static class NonConfigurationInstance {
        private BackstackManager backstackManager;

        NonConfigurationInstance(BackstackManager backstackManager) {
            this.backstackManager = backstackManager;
        }

        BackstackManager getBackstackManager() {
            return this.backstackManager;
        }
    }
}

