/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.BackstackDelegate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class HistoryBuilder
implements Iterable<Object> {
    private ArrayList<Object> list = new ArrayList();

    private HistoryBuilder() {
    }

    public static HistoryBuilder from(@NonNull Backstack backstack) {
        if (backstack == null) {
            throw new IllegalArgumentException("Backstack cannot be null!");
        }
        return HistoryBuilder.from(backstack.getHistory());
    }

    public static HistoryBuilder from(@NonNull BackstackDelegate backstackDelegate) {
        if (backstackDelegate == null) {
            throw new IllegalArgumentException("BackstackDelegate cannot be null!");
        }
        return HistoryBuilder.from(backstackDelegate.getBackstack());
    }

    public static HistoryBuilder from(@NonNull List<?> keys) {
        return HistoryBuilder.newBuilder().addAll(keys);
    }

    public static HistoryBuilder newBuilder() {
        return new HistoryBuilder();
    }

    public static ArrayList<Object> single(@NonNull Object key) {
        return HistoryBuilder.newBuilder().add(key).build();
    }

    public HistoryBuilder addAll(@NonNull List<?> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Provided collection cannot be null");
        }
        this.list.addAll(keys);
        return this;
    }

    public HistoryBuilder addAllAt(@NonNull List<?> keys, int index) {
        if (keys == null) {
            throw new IllegalArgumentException("Provided collection cannot be null");
        }
        this.list.addAll(index, keys);
        return this;
    }

    public HistoryBuilder clear() {
        this.list.clear();
        return this;
    }

    public boolean contains(@NonNull Object key) {
        this.checkKey(key);
        return this.list.contains(key);
    }

    public boolean containsAll(@NonNull Collection<?> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Keys cannot be null!");
        }
        return this.list.containsAll(keys);
    }

    public int size() {
        return this.list.size();
    }

    public HistoryBuilder remove(@NonNull Object key) {
        this.checkKey(key);
        this.list.remove(key);
        return this;
    }

    public HistoryBuilder removeAt(int index) {
        this.list.remove(index);
        return this;
    }

    public HistoryBuilder retainAll(@NonNull Collection<?> keys) {
        this.checkKeys(keys);
        this.list.retainAll(keys);
        return this;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public HistoryBuilder removeLast() {
        if (this.list.isEmpty()) {
            throw new IllegalStateException("Cannot remove element from empty builder");
        }
        this.list.remove(this.list.size() - 1);
        return this;
    }

    public HistoryBuilder removeUntil(@NonNull Object key) {
        this.checkKey(key);
        while (!this.list.isEmpty() && !this.getLast().equals(key)) {
            this.removeLast();
        }
        if (this.list.isEmpty()) {
            throw new IllegalArgumentException("[" + key + "] was not found in history!");
        }
        return this;
    }

    public int indexOf(@NonNull Object key) {
        this.checkKey(key);
        return this.list.indexOf(key);
    }

    public <T> T get(int index) {
        return (T)this.list.get(index);
    }

    @Nullable
    public <T> T getLast() {
        return (T)(this.list.isEmpty() ? null : this.list.get(this.list.size() - 1));
    }

    public HistoryBuilder add(@NonNull Object key) {
        this.checkKey(key);
        this.list.add(key);
        return this;
    }

    public HistoryBuilder add(@NonNull Object key, int index) {
        this.checkKey(key);
        this.list.add(index, key);
        return this;
    }

    @Override
    public Iterator<Object> iterator() {
        return this.list.iterator();
    }

    public ArrayList<Object> build() {
        return new ArrayList<Object>(this.list);
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("History key cannot be null!");
        }
    }

    private void checkKeys(Collection<?> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Keys cannot be null!");
        }
    }
}

