/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack.navigator;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.ContextWrapper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.BackstackManager;
import com.zhuinden.simplestack.DefaultKeyFilter;
import com.zhuinden.simplestack.DefaultKeyParceler;
import com.zhuinden.simplestack.DefaultStateClearStrategy;
import com.zhuinden.simplestack.GlobalServices;
import com.zhuinden.simplestack.KeyFilter;
import com.zhuinden.simplestack.KeyParceler;
import com.zhuinden.simplestack.SavedState;
import com.zhuinden.simplestack.ScopeKey;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopedServices;
import com.zhuinden.simplestack.StateChanger;
import com.zhuinden.simplestack.navigator.BackstackHost;
import com.zhuinden.simplestack.navigator.DefaultStateChanger;
import java.util.LinkedList;
import java.util.List;

@TargetApi(value=11)
public class Navigator {
    private Navigator() {
    }

    @NonNull
    public static Installer configure() {
        return new Installer();
    }

    @NonNull
    public static void install(@NonNull Activity activity, @NonNull ViewGroup container, @NonNull List<?> initialKeys) {
        Navigator.configure().install(activity, container, initialKeys);
    }

    private static Backstack install(Installer installer, @NonNull Activity activity, @NonNull ViewGroup container, @NonNull List<?> initialKeys) {
        if (activity == null) {
            throw new IllegalArgumentException("Activity cannot be null!");
        }
        if (container == null) {
            throw new IllegalArgumentException("State changer cannot be null!");
        }
        if (initialKeys == null || initialKeys.isEmpty()) {
            throw new IllegalArgumentException("Initial keys cannot be null!");
        }
        BackstackHost backstackHost = Navigator.findBackstackHost(activity);
        if (backstackHost == null) {
            backstackHost = new BackstackHost();
            activity.getFragmentManager().beginTransaction().add((Fragment)backstackHost, "NAVIGATOR_BACKSTACK_HOST").commit();
            activity.getFragmentManager().executePendingTransactions();
        }
        backstackHost.stateChanger = installer.stateChanger;
        backstackHost.keyFilter = installer.keyFilter;
        backstackHost.keyParceler = installer.keyParceler;
        backstackHost.stateClearStrategy = installer.stateClearStrategy;
        backstackHost.scopedServices = installer.scopedServices;
        backstackHost.globalServices = installer.globalServices;
        backstackHost.stateChangeCompletionListeners = installer.stateChangeCompletionListeners;
        backstackHost.shouldPersistContainerChild = installer.shouldPersistContainerChild;
        backstackHost.container = container;
        backstackHost.initialKeys = initialKeys;
        return backstackHost.initialize(installer.isInitializeDeferred);
    }

    public static void executeDeferredInitialization(Context context) {
        Object activity = Navigator.findActivity(context);
        BackstackHost backstackHost = Navigator.findBackstackHost(activity);
        backstackHost.initialize(false);
    }

    public static Backstack getBackstack(Context context) {
        BackstackHost backstackHost = Navigator.getBackstackHost(context);
        return backstackHost.getBackstack();
    }

    public static boolean onBackPressed(Context context) {
        return Navigator.getBackstack(context).goBack();
    }

    public static boolean hasScope(@NonNull Context context, @NonNull String scopeTag) {
        return Navigator.getManager(context).hasScope(scopeTag);
    }

    public static boolean hasService(@NonNull Context context, @NonNull ScopeKey scopeKey, @NonNull String serviceTag) {
        return Navigator.getManager(context).hasService(scopeKey, serviceTag);
    }

    public static boolean hasService(@NonNull Context context, @NonNull String scopeTag, @NonNull String serviceTag) {
        return Navigator.getManager(context).hasService(scopeTag, serviceTag);
    }

    @NonNull
    public static <T> T getService(@NonNull Context context, @NonNull ScopeKey scopeKey, @NonNull String serviceTag) {
        return Navigator.getManager(context).getService(scopeKey, serviceTag);
    }

    @NonNull
    public static <T> T getService(@NonNull Context context, @NonNull String scopeTag, @NonNull String serviceTag) {
        return Navigator.getManager(context).getService(scopeTag, serviceTag);
    }

    public static boolean canFindService(@NonNull Context context, @NonNull String serviceTag) {
        return Navigator.getManager(context).canFindService(serviceTag);
    }

    @NonNull
    public static <T> T lookupService(@NonNull Context context, @NonNull String serviceTag) {
        return Navigator.getManager(context).lookupService(serviceTag);
    }

    @NonNull
    public static List<String> findScopesForKey(@NonNull Context context, @NonNull Object key, @NonNull ScopeLookupMode lookupMode) {
        return Navigator.getManager(context).findScopesForKey(key, lookupMode);
    }

    public static boolean canFindFromScope(@NonNull Context context, @NonNull String scopeTag, @NonNull String serviceTag) {
        return Navigator.getManager(context).canFindFromScope(scopeTag, serviceTag);
    }

    public static boolean canFindFromScope(@NonNull Context context, @NonNull String scopeTag, @NonNull String serviceTag, @NonNull ScopeLookupMode lookupMode) {
        return Navigator.getManager(context).canFindFromScope(scopeTag, serviceTag, lookupMode);
    }

    @NonNull
    public static <T> T lookupFromScope(@NonNull Context context, @NonNull String scopeTag, @NonNull String serviceTag) {
        return Navigator.getManager(context).lookupFromScope(scopeTag, serviceTag);
    }

    @NonNull
    public static <T> T lookupFromScope(@NonNull Context context, @NonNull String scopeTag, @NonNull String serviceTag, @NonNull ScopeLookupMode lookupMode) {
        return Navigator.getManager(context).lookupFromScope(scopeTag, serviceTag, lookupMode);
    }

    @NonNull
    public static BackstackManager getManager(Context context) {
        BackstackHost backstackHost = Navigator.getBackstackHost(context);
        return backstackHost.getBackstackManager();
    }

    public static void persistViewToState(@Nullable View view) {
        if (view != null) {
            Context context = view.getContext();
            BackstackHost backstackHost = Navigator.getBackstackHost(context);
            backstackHost.getBackstackManager().persistViewToState(view);
        }
    }

    public static void restoreViewFromState(@NonNull View view) {
        if (view == null) {
            throw new NullPointerException("You cannot restore state into null view!");
        }
        Context context = view.getContext();
        BackstackHost backstackHost = Navigator.getBackstackHost(context);
        backstackHost.getBackstackManager().restoreViewFromState(view);
    }

    @NonNull
    public static SavedState getSavedState(@NonNull Context context, @NonNull Object key) {
        if (context == null) {
            throw new NullPointerException("context cannot be null");
        }
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        BackstackHost backstackHost = Navigator.getBackstackHost(context);
        return backstackHost.getBackstackManager().getSavedState(key);
    }

    public static boolean isNavigatorAvailable(@NonNull Activity activity) {
        return Navigator.findBackstackHost(activity) != null;
    }

    private static BackstackHost findBackstackHost(Activity activity) {
        return (BackstackHost)activity.getFragmentManager().findFragmentByTag("NAVIGATOR_BACKSTACK_HOST");
    }

    @NonNull
    public static <T extends Activity> T findActivity(@NonNull Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context cannot be null!");
        }
        if (context instanceof Activity) {
            return (T)((Activity)context);
        }
        ContextWrapper contextWrapper = (ContextWrapper)context;
        Context baseContext = contextWrapper.getBaseContext();
        if (baseContext == null) {
            throw new IllegalStateException("Activity was not found as base context of view!");
        }
        return Navigator.findActivity(baseContext);
    }

    private static BackstackHost getBackstackHost(Context context) {
        Object activity = Navigator.findActivity(context);
        return Navigator.findBackstackHost(activity);
    }

    @TargetApi(value=11)
    public static class Installer {
        StateChanger stateChanger;
        KeyFilter keyFilter = new DefaultKeyFilter();
        KeyParceler keyParceler = new DefaultKeyParceler();
        BackstackManager.StateClearStrategy stateClearStrategy = new DefaultStateClearStrategy();
        ScopedServices scopedServices = null;
        GlobalServices globalServices = null;
        boolean isInitializeDeferred = false;
        boolean shouldPersistContainerChild = true;
        List<Backstack.CompletionListener> stateChangeCompletionListeners = new LinkedList<Backstack.CompletionListener>();

        @NonNull
        public Installer setStateChanger(@NonNull StateChanger stateChanger) {
            if (stateChanger == null) {
                throw new IllegalArgumentException("If set, StateChanger cannot be null!");
            }
            this.stateChanger = stateChanger;
            return this;
        }

        @NonNull
        public Installer setKeyFilter(@NonNull KeyFilter keyFilter) {
            if (keyFilter == null) {
                throw new IllegalArgumentException("If set, KeyFilter cannot be null!");
            }
            this.keyFilter = keyFilter;
            return this;
        }

        @NonNull
        public Installer setKeyParceler(@NonNull KeyParceler keyParceler) {
            if (keyParceler == null) {
                throw new IllegalArgumentException("If set, KeyParceler cannot be null!");
            }
            this.keyParceler = keyParceler;
            return this;
        }

        @NonNull
        public Installer setStateClearStrategy(@NonNull BackstackManager.StateClearStrategy stateClearStrategy) {
            if (stateClearStrategy == null) {
                throw new IllegalArgumentException("If set, StateClearStrategy cannot be null!");
            }
            this.stateClearStrategy = stateClearStrategy;
            return this;
        }

        @NonNull
        public Installer setScopedServices(@NonNull ScopedServices scopedServices) {
            if (scopedServices == null) {
                throw new IllegalArgumentException("If set, scoped services cannot be null!");
            }
            this.scopedServices = scopedServices;
            return this;
        }

        @NonNull
        public Installer setGlobalServices(@NonNull GlobalServices globalServices) {
            if (globalServices == null) {
                throw new IllegalArgumentException("If set, global services cannot be null!");
            }
            this.globalServices = globalServices;
            return this;
        }

        @NonNull
        public Installer setDeferredInitialization(boolean isInitializeDeferred) {
            this.isInitializeDeferred = isInitializeDeferred;
            return this;
        }

        @NonNull
        public Installer setShouldPersistContainerChild(boolean shouldPersistContainerChild) {
            this.shouldPersistContainerChild = shouldPersistContainerChild;
            return this;
        }

        @NonNull
        public Installer addStateChangeCompletionListener(@NonNull Backstack.CompletionListener stateChangeCompletionListener) {
            if (stateChangeCompletionListener == null) {
                throw new IllegalArgumentException("If added, state change completion listener cannot be null!");
            }
            this.stateChangeCompletionListeners.add(stateChangeCompletionListener);
            return this;
        }

        @NonNull
        public Backstack install(@NonNull Activity activity, @NonNull ViewGroup container, @NonNull List<?> initialKeys) {
            if (this.stateChanger == null) {
                this.stateChanger = DefaultStateChanger.create((Context)activity, container);
            }
            return Navigator.install(this, activity, container, initialKeys);
        }
    }
}

