/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.support.annotation.NonNull;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.BackstackManager;
import com.zhuinden.simplestack.ScopeLookupMode;
import com.zhuinden.simplestack.ScopeManager;
import java.util.Map;

public interface ScopedServices {
    public void bindServices(@NonNull ServiceBinder var1);

    public static class ServiceBinder {
        private final ScopeManager scopeManager;
        private final Object key;
        private final String scopeTag;
        private final Map<String, Object> scope;

        ServiceBinder(ScopeManager scopeManager, Object key, String scopeTag, Map<String, Object> scope) {
            this.scopeManager = scopeManager;
            this.key = key;
            this.scopeTag = scopeTag;
            this.scope = scope;
        }

        @NonNull
        public <T> T getKey() {
            return (T)this.key;
        }

        @NonNull
        public final String getScopeTag() {
            return this.scopeTag;
        }

        public void add(@NonNull String serviceTag, @NonNull Object service) {
            if (serviceTag == null) {
                throw new IllegalArgumentException("Service tag cannot be null!");
            }
            if (service == null) {
                throw new IllegalArgumentException("The provided service should not be null!");
            }
            this.scope.put(serviceTag, service);
        }

        public boolean has(@NonNull String serviceTag) {
            if (serviceTag == null) {
                throw new IllegalArgumentException("Service tag cannot be null!");
            }
            return this.scope.containsKey(serviceTag);
        }

        @NonNull
        public <T> T get(@NonNull String serviceTag) {
            if (serviceTag == null) {
                throw new IllegalArgumentException("Service tag cannot be null!");
            }
            if (!this.has(serviceTag)) {
                throw new IllegalArgumentException("The service with tag [" + serviceTag + "] was not found!");
            }
            return (T)this.scope.get(serviceTag);
        }

        public boolean canFind(@NonNull String serviceTag) {
            return this.scopeManager.canFindService(serviceTag);
        }

        @NonNull
        public <T> T lookup(@NonNull String serviceTag) {
            return this.scopeManager.lookupService(serviceTag);
        }

        public boolean canFindFrom(String scopeTag, String serviceTag) {
            return this.scopeManager.canFindFromScope(scopeTag, serviceTag, ScopeLookupMode.ALL);
        }

        @NonNull
        public <T> T lookupFrom(String scopeTag, String serviceTag) {
            return this.scopeManager.lookupFromScope(scopeTag, serviceTag, ScopeLookupMode.ALL);
        }

        @NonNull
        public Backstack getBackstack() {
            return this.scopeManager.getBackstack();
        }

        @NonNull
        public BackstackManager getManager() {
            return this.scopeManager.getManager();
        }
    }

    public static interface Registered {
        public void onServiceRegistered();

        public void onServiceUnregistered();
    }

    public static interface Activated {
        public void onScopeActive(@NonNull String var1);

        public void onScopeInactive(@NonNull String var1);
    }

    public static interface Scoped {
        public void onEnterScope(@NonNull String var1);

        public void onExitScope(@NonNull String var1);
    }
}

