/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.support.annotation.NonNull;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class GlobalServices {
    private final Map<String, Object> services;

    Map<String, Object> getServices() {
        return this.services;
    }

    private GlobalServices(Map<String, Object> scope) {
        this.services = scope;
    }

    public boolean hasService(@NonNull String serviceTag) {
        if (serviceTag == null) {
            throw new IllegalArgumentException("serviceTag cannot be null!");
        }
        return this.services.containsKey(serviceTag);
    }

    @NonNull
    public <T> T getService(@NonNull String serviceTag) {
        if (serviceTag == null) {
            throw new IllegalArgumentException("serviceTag cannot be null!");
        }
        if (this.hasService(serviceTag)) {
            return (T)this.services.get(serviceTag);
        }
        throw new IllegalArgumentException("The global scope does not contain [" + serviceTag + "]!");
    }

    @NonNull
    public Set<Map.Entry<String, Object>> services() {
        return this.services.entrySet();
    }

    @NonNull
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, Object> scope = new LinkedHashMap<String, Object>();

        private Builder() {
        }

        @NonNull
        public Builder addService(@NonNull String serviceTag, @NonNull Object service) {
            if (serviceTag == null) {
                throw new IllegalArgumentException("serviceTagTag cannot be null!");
            }
            if (service == null) {
                throw new IllegalArgumentException("service cannot be null!");
            }
            this.scope.put(serviceTag, service);
            return this;
        }

        @NonNull
        public GlobalServices build() {
            return new GlobalServices(new LinkedHashMap<String, Object>(this.scope));
        }
    }
}

