/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.History;
import com.zhuinden.simplestack.KeyContextWrapper;
import java.util.LinkedList;
import java.util.List;

public class StateChange {
    public static final int REPLACE = 0;
    public static final int BACKWARD = -1;
    public static final int FORWARD = 1;
    Backstack backstack;
    List<Object> previousState;
    List<Object> newState;
    int direction;

    StateChange(Backstack backstack, List<Object> previousState, List<Object> newState, int direction) {
        this.backstack = backstack;
        this.previousState = previousState;
        this.newState = newState;
        this.direction = direction;
    }

    @NonNull
    public Backstack backstack() {
        return this.backstack;
    }

    public final boolean isTopNewStateEqualToPrevious() {
        return this.topNewState().equals(this.topPreviousState());
    }

    private <T> History<T> createParametricCopyList(List<Object> list) {
        LinkedList<Object> copyList = new LinkedList<Object>();
        for (Object key : list) {
            copyList.add(key);
        }
        return History.from(copyList);
    }

    @NonNull
    public <T> History<T> getPreviousState() {
        return this.createParametricCopyList(this.previousState);
    }

    @NonNull
    public <T> History<T> getNewState() {
        return this.createParametricCopyList(this.newState);
    }

    public int getDirection() {
        return this.direction;
    }

    @Nullable
    public <T> T topPreviousState() {
        if (this.previousState.size() > 0) {
            return (T)this.previousState.get(this.previousState.size() - 1);
        }
        return null;
    }

    @NonNull
    public <T> T topNewState() {
        return (T)this.newState.get(this.newState.size() - 1);
    }

    @NonNull
    public Context createContext(@NonNull Context base, @NonNull Object key) {
        return new KeyContextWrapper(base, key);
    }
}

