/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.BackstackManager;
import com.zhuinden.simplestack.Bundleable;
import com.zhuinden.simplestack.ScopeKey;
import com.zhuinden.simplestack.ScopedServices;
import com.zhuinden.statebundle.StateBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

class ScopeManager {
    private ScopedServices scopedServices = new AssertingScopedServices();
    private BackstackManager backstackManager;
    private final Map<String, Map<String, Object>> scopes = new LinkedHashMap<String, Map<String, Object>>();
    private final StateBundle rootBundle = new StateBundle();

    ScopeManager() {
    }

    void setBackstackManager(BackstackManager backstackManager) {
        this.backstackManager = backstackManager;
    }

    Backstack getBackstack() {
        return this.backstackManager.getBackstack();
    }

    private List<String> getActiveScopesReverse() {
        ArrayList<String> activeScopes = new ArrayList<String>(this.scopes.keySet());
        Collections.reverse(activeScopes);
        return activeScopes;
    }

    void setScopedServices(ScopedServices scopedServices) {
        this.scopedServices = scopedServices;
    }

    void buildScopes(List<Object> newState) {
        for (Object key : newState) {
            if (!(key instanceof ScopeKey)) continue;
            ScopeKey scopeKey = (ScopeKey)key;
            String scopeTag = scopeKey.getScopeTag();
            if (scopeKey == null) {
                throw new IllegalArgumentException("Scope tag provided by scope key cannot be null!");
            }
            if (this.scopes.containsKey(scopeTag)) continue;
            LinkedHashMap<String, Object> scope = new LinkedHashMap<String, Object>();
            this.scopes.put(scopeTag, scope);
            this.scopedServices.bindServices(new ScopedServices.ServiceBinder(this, key, scopeTag, scope));
            for (Map.Entry serviceEntry : scope.entrySet()) {
                StateBundle scopeBundle;
                String serviceTag = (String)serviceEntry.getKey();
                Object service = serviceEntry.getValue();
                if (this.rootBundle.containsKey(scopeTag) && service instanceof Bundleable && (scopeBundle = this.rootBundle.getBundle(scopeTag)) != null && scopeBundle.containsKey(serviceTag)) {
                    ((Bundleable)service).fromBundle(scopeBundle.getBundle(serviceTag));
                }
                if (!(service instanceof ScopedServices.Scoped)) continue;
                ((ScopedServices.Scoped)service).onEnterScope(scopeTag);
            }
        }
    }

    void clearScopesNotIn(List<Object> newState) {
        LinkedHashSet<String> currentScopes = new LinkedHashSet<String>();
        for (Object key : newState) {
            if (!(key instanceof ScopeKey)) continue;
            ScopeKey scopeKey = (ScopeKey)key;
            currentScopes.add(scopeKey.getScopeTag());
        }
        List<String> scopeSet = this.getActiveScopesReverse();
        for (String activeScope : scopeSet) {
            if (currentScopes.contains(activeScope)) continue;
            Map<String, Object> scope = this.scopes.get(activeScope);
            ArrayList<Object> services = new ArrayList<Object>(scope.values());
            Collections.reverse(services);
            for (Object e : services) {
                if (!(e instanceof ScopedServices.Scoped)) continue;
                ((ScopedServices.Scoped)e).onExitScope(activeScope);
            }
            this.scopes.remove(activeScope);
            this.rootBundle.remove(activeScope);
        }
    }

    void destroyScope(String scopeTag) {
        if (this.scopes.containsKey(scopeTag)) {
            Map<String, Object> serviceMap = this.scopes.remove(scopeTag);
            ArrayList<Object> services = new ArrayList<Object>(serviceMap.values());
            Collections.reverse(services);
            for (Object e : services) {
                if (!(e instanceof ScopedServices.Scoped)) continue;
                ((ScopedServices.Scoped)e).onExitScope(scopeTag);
            }
            this.rootBundle.remove(scopeTag);
        }
    }

    void dispatchActivation(@Nullable String previousScopeTag, @Nullable String newScopeTag) {
        if (newScopeTag != null) {
            if (!this.scopes.containsKey(newScopeTag)) {
                throw new AssertionError((Object)"The new scope should exist, but it doesn't! This shouldn't happen. If you see this error, this functionality is broken.");
            }
            Map<String, Object> newServiceMap = this.scopes.get(newScopeTag);
            for (Object service : newServiceMap.values()) {
                if (!(service instanceof ScopedServices.Activated)) continue;
                ((ScopedServices.Activated)service).onScopeActive(newScopeTag);
            }
        }
        if (previousScopeTag != null) {
            if (!this.scopes.containsKey(previousScopeTag)) {
                throw new AssertionError((Object)"The previous scope should exist, but it doesn't! This shouldn't happen. If you see this error, this functionality is broken.");
            }
            Map<String, Object> previousServiceMap = this.scopes.get(previousScopeTag);
            ArrayList<Object> previousServices = new ArrayList<Object>(previousServiceMap.values());
            Collections.reverse(previousServices);
            for (Object e : previousServices) {
                if (!(e instanceof ScopedServices.Activated)) continue;
                ((ScopedServices.Activated)e).onScopeInactive(previousScopeTag);
            }
        }
    }

    StateBundle saveStates() {
        StateBundle rootBundle = new StateBundle();
        for (Map.Entry<String, Map<String, Object>> scopeSet : this.scopes.entrySet()) {
            String scopeKey = scopeSet.getKey();
            Map<String, Object> services = scopeSet.getValue();
            StateBundle scopeBundle = new StateBundle();
            for (Map.Entry<String, Object> serviceEntry : services.entrySet()) {
                String serviceTag = serviceEntry.getKey();
                Object service = serviceEntry.getValue();
                if (!(service instanceof Bundleable)) continue;
                scopeBundle.putBundle(serviceTag, ((Bundleable)service).toBundle());
            }
            rootBundle.putBundle(scopeKey, scopeBundle);
        }
        return rootBundle;
    }

    void setRestoredStates(StateBundle rootBundle) {
        if (rootBundle != null) {
            this.rootBundle.putAll(rootBundle);
        }
    }

    boolean hasService(@NonNull String scopeTag, @NonNull String serviceTag) {
        if (scopeTag == null) {
            throw new IllegalArgumentException("Scope tag cannot be null!");
        }
        if (serviceTag == null) {
            throw new IllegalArgumentException("Service tag cannot be null!");
        }
        if (!this.scopes.containsKey(scopeTag)) {
            return false;
        }
        Map<String, Object> services = this.scopes.get(scopeTag);
        return services.containsKey(serviceTag);
    }

    @NonNull
    <T> T getService(@NonNull String scopeTag, @NonNull String serviceTag) {
        if (scopeTag == null) {
            throw new IllegalArgumentException("Scope tag cannot be null!");
        }
        if (serviceTag == null) {
            throw new IllegalArgumentException("Service tag cannot be null!");
        }
        if (!this.scopes.containsKey(scopeTag)) {
            throw new IllegalArgumentException("The specified scope with tag [" + scopeTag + "] does not exist!");
        }
        Map<String, Object> services = this.scopes.get(scopeTag);
        if (!services.containsKey(serviceTag)) {
            throw new IllegalArgumentException("The specified service with tag [" + serviceTag + "] does not exist in scope [" + scopeTag + "]! Did you accidentally try to use the same scope tag with different services?");
        }
        return (T)services.get(serviceTag);
    }

    boolean hasScope(@NonNull String scopeTag) {
        if (scopeTag == null) {
            throw new IllegalArgumentException("Scope tag cannot be null!");
        }
        return this.scopes.containsKey(scopeTag);
    }

    boolean canFindService(@NonNull String serviceTag) {
        if (serviceTag == null) {
            throw new IllegalArgumentException("Service tag cannot be null!");
        }
        List<String> activeScopes = this.getActiveScopesReverse();
        for (String scopeTag : activeScopes) {
            if (!this.hasService(scopeTag, serviceTag)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    <T> T lookupService(@NonNull String serviceTag) {
        if (serviceTag == null) {
            throw new IllegalArgumentException("Service tag cannot be null!");
        }
        List<String> activeScopes = this.getActiveScopesReverse();
        for (String scopeTag : activeScopes) {
            if (!this.hasService(scopeTag, serviceTag)) continue;
            return this.getService(scopeTag, serviceTag);
        }
        throw new IllegalStateException("The service [" + serviceTag + "] does not exist in any scopes!");
    }

    static class AssertingScopedServices
    implements ScopedServices {
        AssertingScopedServices() {
        }

        @Override
        public void bindServices(@NonNull ScopedServices.ServiceBinder serviceBinder) {
            throw new IllegalStateException("No scoped services are defined. To create scoped services, an instance of ScopedServices must be provided to configure the services that are available in a given scope.");
        }
    }
}

