/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.content.Context;
import android.support.annotation.NonNull;
import com.zhuinden.simplestack.KeyContextWrapper;
import com.zhuinden.simplestack.PendingStateChange;
import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Backstack {
    public static final int INITIALIZE = 0;
    public static final int REATTACH = 1;
    private final List<Object> originalStack = new ArrayList<Object>();
    private final List<Object> initialParameters;
    private List<Object> stack = this.originalStack;
    private LinkedList<PendingStateChange> queuedStateChanges = new LinkedList();
    private StateChanger stateChanger;
    private LinkedList<CompletionListener> completionListeners = new LinkedList();

    public static <T> T getKey(Context context) {
        return KeyContextWrapper.getKey(context);
    }

    public Backstack(Object ... initialKeys) {
        if (initialKeys == null || initialKeys.length <= 0) {
            throw new IllegalArgumentException("At least one initial key must be defined");
        }
        this.initialParameters = Collections.unmodifiableList(new ArrayList<Object>(Arrays.asList(initialKeys)));
    }

    public Backstack(@NonNull List<?> initialKeys) {
        if (initialKeys == null) {
            throw new NullPointerException("Initial key list should not be null");
        }
        if (initialKeys.size() <= 0) {
            throw new IllegalArgumentException("Initial key list should contain at least one element");
        }
        this.initialParameters = Collections.unmodifiableList(new ArrayList(initialKeys));
    }

    public boolean hasStateChanger() {
        return this.stateChanger != null;
    }

    public void setStateChanger(@NonNull StateChanger stateChanger, int registerMode) {
        if (stateChanger == null) {
            throw new NullPointerException("New state changer cannot be null");
        }
        this.stateChanger = stateChanger;
        if (registerMode == 0 && (this.queuedStateChanges.size() <= 1 || this.stack.isEmpty())) {
            if (!this.beginStateChangeIfPossible()) {
                ArrayList<Object> newHistory = new ArrayList<Object>();
                newHistory.addAll(this.selectActiveHistory());
                this.stack = this.initialParameters;
                this.enqueueStateChange(newHistory, 0, true);
            }
            return;
        }
        this.beginStateChangeIfPossible();
    }

    public void removeStateChanger() {
        this.stateChanger = null;
    }

    public void goTo(@NonNull Object newKey) {
        int direction;
        this.checkNewKey(newKey);
        ArrayList<Object> newHistory = new ArrayList<Object>();
        boolean isNewKey = true;
        for (Object key : this.selectActiveHistory()) {
            newHistory.add(key);
            if (!key.equals(newKey)) continue;
            isNewKey = false;
            break;
        }
        if (isNewKey) {
            newHistory.add(newKey);
            direction = 1;
        } else {
            direction = -1;
        }
        this.enqueueStateChange(newHistory, direction, false);
    }

    public boolean goBack() {
        if (this.isStateChangePending()) {
            return true;
        }
        if (this.stack.size() <= 1) {
            this.stack.clear();
            return false;
        }
        ArrayList<Object> newHistory = new ArrayList<Object>();
        List<Object> activeHistory = this.selectActiveHistory();
        for (int i = 0; i < activeHistory.size() - 1; ++i) {
            newHistory.add(activeHistory.get(i));
        }
        this.enqueueStateChange(newHistory, -1, false);
        return true;
    }

    public void setHistory(@NonNull List<Object> newHistory, int direction) {
        this.checkNewHistory(newHistory);
        this.enqueueStateChange(newHistory, direction, false);
    }

    public List<Object> getHistory() {
        ArrayList<Object> copy = new ArrayList<Object>();
        copy.addAll(this.stack);
        return Collections.unmodifiableList(copy);
    }

    public boolean isStateChangePending() {
        return !this.queuedStateChanges.isEmpty();
    }

    private void enqueueStateChange(List<Object> newHistory, int direction, boolean initialization) {
        PendingStateChange pendingStateChange = new PendingStateChange(newHistory, direction, initialization);
        this.queuedStateChanges.add(pendingStateChange);
        this.beginStateChangeIfPossible();
    }

    private List<Object> selectActiveHistory() {
        if (this.stack.isEmpty() && this.queuedStateChanges.size() <= 0) {
            return this.initialParameters;
        }
        if (this.queuedStateChanges.size() <= 0) {
            return this.stack;
        }
        return this.queuedStateChanges.getLast().newHistory;
    }

    private boolean beginStateChangeIfPossible() {
        PendingStateChange pendingStateChange;
        if (this.hasStateChanger() && this.isStateChangePending() && (pendingStateChange = this.queuedStateChanges.getFirst()).getStatus() == PendingStateChange.Status.ENQUEUED) {
            pendingStateChange.setStatus(PendingStateChange.Status.IN_PROGRESS);
            this.changeState(pendingStateChange);
            return true;
        }
        return false;
    }

    private void changeState(final PendingStateChange pendingStateChange) {
        StateChanger.Callback completionCallback;
        List previousState;
        boolean initialization = pendingStateChange.initialization;
        List<Object> newHistory = pendingStateChange.newHistory;
        int direction = pendingStateChange.direction;
        if (initialization) {
            previousState = Collections.emptyList();
        } else {
            previousState = new ArrayList();
            previousState.addAll(this.stack);
        }
        final StateChange stateChange = new StateChange(Collections.unmodifiableList(previousState), Collections.unmodifiableList(newHistory), direction);
        pendingStateChange.completionCallback = completionCallback = new StateChanger.Callback(){

            @Override
            public void stateChangeComplete() {
                if (!pendingStateChange.didForceExecute) {
                    if (pendingStateChange.getStatus() == PendingStateChange.Status.COMPLETED) {
                        throw new IllegalStateException("State change completion cannot be called multiple times!");
                    }
                    Backstack.this.completeStateChange(stateChange);
                }
            }
        };
        this.stateChanger.handleStateChange(stateChange, completionCallback);
    }

    private void completeStateChange(StateChange stateChange) {
        if (this.initialParameters == this.stack) {
            this.stack = this.originalStack;
        }
        this.stack.clear();
        this.stack.addAll(stateChange.newState);
        PendingStateChange pendingStateChange = this.queuedStateChanges.removeFirst();
        pendingStateChange.setStatus(PendingStateChange.Status.COMPLETED);
        this.notifyCompletionListeners(stateChange);
        this.beginStateChangeIfPossible();
    }

    public void addCompletionListener(@NonNull CompletionListener completionListener) {
        if (completionListener == null) {
            throw new IllegalArgumentException("Null completion listener cannot be added!");
        }
        this.completionListeners.add(completionListener);
    }

    public void removeCompletionListener(@NonNull CompletionListener completionListener) {
        if (completionListener == null) {
            throw new IllegalArgumentException("Null completion listener cannot be removed!");
        }
        this.completionListeners.remove(completionListener);
    }

    private void notifyCompletionListeners(StateChange stateChange) {
        for (CompletionListener completionListener : this.completionListeners) {
            completionListener.stateChangeCompleted(stateChange);
        }
    }

    public void executePendingStateChange() {
        PendingStateChange pendingStateChange;
        if (this.isStateChangePending() && (pendingStateChange = this.queuedStateChanges.getFirst()).getStatus() == PendingStateChange.Status.IN_PROGRESS) {
            pendingStateChange.completionCallback.stateChangeComplete();
            pendingStateChange.didForceExecute = true;
        }
    }

    private void checkNewHistory(List<Object> newHistory) {
        if (newHistory == null || newHistory.isEmpty()) {
            throw new IllegalArgumentException("New history cannot be null or empty");
        }
    }

    private void checkNewKey(Object newKey) {
        if (newKey == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
    }

    public static interface CompletionListener {
        public void stateChangeCompleted(@NonNull StateChange var1);
    }
}

