/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import android.view.View;
import com.zhuinden.simplestack.Backstack;
import com.zhuinden.simplestack.Bundleable;
import com.zhuinden.simplestack.HistoryBuilder;
import com.zhuinden.simplestack.KeyContextWrapper;
import com.zhuinden.simplestack.SavedState;
import com.zhuinden.simplestack.StateChange;
import com.zhuinden.simplestack.StateChanger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BackstackDelegate {
    private final Backstack.CompletionListener completionListener = new Backstack.CompletionListener(){

        @Override
        public void stateChangeCompleted(@NonNull StateChange stateChange) {
            BackstackDelegate.this.stateChangeCompleted(stateChange);
        }
    };
    private static final String UNINITIALIZED = "";
    private String persistenceTag = "";
    private static final String HISTORY = "simplestack.HISTORY";
    private static final String STATES = "simplestack.HISTORY_STATES";
    Backstack backstack;
    Map<Parcelable, SavedState> keyStateMap = new HashMap<Parcelable, SavedState>();
    StateChanger stateChanger;

    public void setPersistenceTag(@NonNull String persistenceTag) {
        if (this.backstack != null) {
            throw new IllegalStateException("Persistence tag should be set before calling `onCreate()`");
        }
        if (persistenceTag == null) {
            throw new IllegalArgumentException("Null persistence tag is not allowed!");
        }
        if (this.persistenceTag == UNINITIALIZED) {
            this.persistenceTag = persistenceTag;
        } else if (!this.persistenceTag.equals(persistenceTag)) {
            throw new IllegalStateException("The persistence tag cannot be set to a new value once it's already set!");
        }
    }

    private String getHistoryTag() {
        return UNINITIALIZED.equals(this.persistenceTag) ? HISTORY : HISTORY + this.persistenceTag;
    }

    private String getStateTag() {
        return UNINITIALIZED.equals(this.persistenceTag) ? STATES : STATES + this.persistenceTag;
    }

    public BackstackDelegate(@Nullable StateChanger stateChanger) {
        this.stateChanger = stateChanger;
    }

    public void onCreate(@Nullable Bundle savedInstanceState, @Nullable Object nonConfigurationInstance, @NonNull ArrayList<Parcelable> initialKeys) {
        NonConfigurationInstance nonConfig;
        ArrayList keys;
        if (nonConfigurationInstance != null && !(nonConfigurationInstance instanceof NonConfigurationInstance)) {
            throw new IllegalArgumentException("The provided non configuration instance must be of type BackstackDelegate.NonConfigurationInstance!");
        }
        if (savedInstanceState != null) {
            keys = savedInstanceState.getParcelableArrayList(this.getHistoryTag());
            ArrayList savedStates = savedInstanceState.getParcelableArrayList(this.getStateTag());
            if (savedStates != null) {
                for (SavedState savedState : savedStates) {
                    this.keyStateMap.put(savedState.getKey(), savedState);
                }
            }
        } else {
            keys = initialKeys;
        }
        this.backstack = (nonConfig = (NonConfigurationInstance)nonConfigurationInstance) != null ? nonConfig.getBackstack() : new Backstack(keys);
        this.registerAsCompletionListener();
        this.initializeBackstack(this.stateChanger);
    }

    protected void registerAsCompletionListener() {
        this.backstack.addCompletionListener(this.completionListener);
    }

    protected void unregisterAsCompletionListener() {
        this.backstack.removeCompletionListener(this.completionListener);
    }

    public void setStateChanger(@Nullable StateChanger stateChanger) {
        if (this.backstack.hasStateChanger()) {
            this.backstack.removeStateChanger();
        }
        this.stateChanger = stateChanger;
        this.initializeBackstack(stateChanger);
    }

    private void initializeBackstack(StateChanger stateChanger) {
        if (stateChanger != null) {
            this.backstack.setStateChanger(stateChanger, 0);
        }
    }

    public NonConfigurationInstance onRetainCustomNonConfigurationInstance() {
        return new NonConfigurationInstance(this.backstack);
    }

    public boolean onBackPressed() {
        return this.backstack.goBack();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putParcelableArrayList(this.getHistoryTag(), HistoryBuilder.from(this.backstack).build());
        outState.putParcelableArrayList(this.getStateTag(), new ArrayList<SavedState>(this.keyStateMap.values()));
    }

    public void onPostResume() {
        if (this.stateChanger == null) {
            throw new IllegalStateException("State changer is still not set in `onPostResume`!");
        }
        if (!this.backstack.hasStateChanger()) {
            this.backstack.setStateChanger(this.stateChanger, 1);
        }
    }

    public void onPause() {
        if (this.backstack.hasStateChanger()) {
            this.backstack.removeStateChanger();
        }
    }

    public void onDestroy() {
        this.backstack.executePendingStateChange();
        this.unregisterAsCompletionListener();
    }

    @NonNull
    public Backstack getBackstack() {
        if (this.backstack == null) {
            throw new IllegalStateException("The backstack within the delegate must be initialized by `onCreate()`");
        }
        return this.backstack;
    }

    public void persistViewToState(@Nullable View view) {
        if (view != null) {
            Object key = KeyContextWrapper.getKey(view.getContext());
            if (key == null) {
                throw new IllegalArgumentException("The view [" + view + "] contained no key!");
            }
            SparseArray viewHierarchyState = new SparseArray();
            view.saveHierarchyState(viewHierarchyState);
            Bundle bundle = null;
            if (view instanceof Bundleable) {
                bundle = ((Bundleable)view).toBundle();
            }
            SavedState previousSavedState = SavedState.builder().setKey((Parcelable)key).setViewHierarchyState((SparseArray<Parcelable>)viewHierarchyState).setBundle(bundle).build();
            this.keyStateMap.put((Parcelable)key, previousSavedState);
        }
    }

    public void restoreViewFromState(@NonNull View view) {
        if (view == null) {
            throw new IllegalArgumentException("You cannot restore state into null view!");
        }
        Object newKey = KeyContextWrapper.getKey(view.getContext());
        SavedState savedState = this.getSavedState((Parcelable)newKey);
        view.restoreHierarchyState(savedState.getViewHierarchyState());
        if (view instanceof Bundleable) {
            ((Bundleable)view).fromBundle(savedState.getBundle());
        }
    }

    @NonNull
    public SavedState getSavedState(@NonNull Parcelable key) {
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null!");
        }
        if (!this.keyStateMap.containsKey(key)) {
            this.keyStateMap.put(key, SavedState.builder().setKey(key).build());
        }
        return this.keyStateMap.get(key);
    }

    protected void stateChangeCompleted(StateChange stateChange) {
        if (!this.backstack.isStateChangePending()) {
            this.clearStatesNotIn(this.keyStateMap, stateChange);
        }
    }

    protected void clearStatesNotIn(@NonNull Map<Parcelable, SavedState> keyStateMap, @NonNull StateChange stateChange) {
        keyStateMap.keySet().retainAll(stateChange.getNewState());
    }

    public static class NonConfigurationInstance {
        private Backstack backstack;

        private NonConfigurationInstance(Backstack backstack) {
            this.backstack = backstack;
        }

        Backstack getBackstack() {
            return this.backstack;
        }
    }
}

