/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.content.Context;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zhuinden.simplestack.KeyContextWrapper;
import java.util.List;

public class StateChange {
    public static final int REPLACE = 0;
    public static final int BACKWARD = -1;
    public static final int FORWARD = 1;
    List<Parcelable> previousState;
    List<Parcelable> newState;
    int direction;

    StateChange(List<Parcelable> previousState, List<Parcelable> newState, int direction) {
        this.previousState = previousState;
        this.newState = newState;
        this.direction = direction;
    }

    public List<Parcelable> getPreviousState() {
        return this.previousState;
    }

    public List<Parcelable> getNewState() {
        return this.newState;
    }

    public int getDirection() {
        return this.direction;
    }

    @Nullable
    public <T extends Parcelable> T topPreviousState() {
        if (this.previousState.size() > 0) {
            return (T)this.previousState.get(this.previousState.size() - 1);
        }
        return null;
    }

    @NonNull
    public <T extends Parcelable> T topNewState() {
        return (T)this.newState.get(this.newState.size() - 1);
    }

    @NonNull
    public Context createContext(Context base, Parcelable key) {
        return new KeyContextWrapper(base, key);
    }
}

