/*
 * Decompiled with CFR 0.152.
 */
package com.zhuinden.simplestack;

import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class HistoryBuilder {
    private ArrayList<Parcelable> list = new ArrayList();

    private HistoryBuilder() {
    }

    public static HistoryBuilder from(List<? extends Parcelable> collection) {
        return HistoryBuilder.newBuilder().addAll(collection);
    }

    public static HistoryBuilder newBuilder() {
        return new HistoryBuilder();
    }

    public static ArrayList<Parcelable> single(Parcelable key) {
        return HistoryBuilder.newBuilder().add(key).build();
    }

    public HistoryBuilder addAll(List<? extends Parcelable> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Provided collection cannot be null");
        }
        this.list.addAll(collection);
        return this;
    }

    public HistoryBuilder addAllAt(List<? extends Parcelable> collection, int index) {
        if (collection == null) {
            throw new IllegalArgumentException("Provided collection cannot be null");
        }
        this.list.addAll(index, collection);
        return this;
    }

    public HistoryBuilder clear() {
        this.list.clear();
        return this;
    }

    public boolean contains(Parcelable key) {
        return this.list.contains(key);
    }

    public boolean containsAll(Collection<Parcelable> keys) {
        return this.list.containsAll(keys);
    }

    public int size() {
        return this.list.size();
    }

    public HistoryBuilder remove(Parcelable key) {
        this.list.remove(key);
        return this;
    }

    public HistoryBuilder removeAt(int index) {
        this.list.remove(index);
        return this;
    }

    public HistoryBuilder retainAll(Collection<Parcelable> keys) {
        this.list.retainAll(keys);
        return this;
    }

    public HistoryBuilder removeLast() {
        if (this.list.isEmpty()) {
            throw new IllegalStateException("Cannot remove element from empty list");
        }
        this.list.remove(this.list.size() - 1);
        return this;
    }

    public HistoryBuilder removeUntil(Parcelable key) {
        if (key == null) {
            throw new IllegalArgumentException("History key cannot be null");
        }
        while (!this.list.isEmpty() && !this.getLast().equals(key)) {
            this.removeLast();
        }
        if (this.list.isEmpty()) {
            throw new IllegalArgumentException("[" + key + "] was not found in history!");
        }
        return this;
    }

    public <T extends Parcelable> T get(int index) {
        return (T)this.list.get(index);
    }

    public <T extends Parcelable> T getLast() {
        return (T)(this.list.isEmpty() ? null : this.list.get(this.list.size() - 1));
    }

    public HistoryBuilder add(Parcelable key) {
        if (key == null) {
            throw new IllegalArgumentException("History key cannot be null");
        }
        this.list.add(key);
        return this;
    }

    public HistoryBuilder add(Parcelable key, int index) {
        if (key == null) {
            throw new IllegalArgumentException("History key cannot be null");
        }
        this.list.add(index, key);
        return this;
    }

    public ArrayList<Parcelable> build() {
        return new ArrayList<Parcelable>(this.list);
    }
}

