/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.ArrayRes;
import androidx.annotation.BoolRes;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.IntegerRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.zlylib.upperdialog.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class ResUtils {
    public static Resources getResources() {
        return Utils.getAppContext().getResources();
    }

    public static Drawable getDrawable(@DrawableRes int id2) {
        return ContextCompat.getDrawable((Context)Utils.getAppContext(), (int)id2);
    }

    public static String getString(@StringRes int id2) {
        return ResUtils.getResources().getString(id2);
    }

    @Deprecated
    public static int getColor(@ColorRes int id2) {
        return ContextCompat.getColor((Context)Utils.getAppContext(), (int)id2);
    }

    public static int getColor(Context context, @ColorRes int id2) {
        return context.getResources().getColor(id2);
    }

    public static int getColor(View view, @ColorRes int id2) {
        return view.getContext().getResources().getColor(id2);
    }

    public static float getDimens(@DimenRes int id2) {
        return ResUtils.getResources().getDimension(id2);
    }

    public static String[] getStringArray(@ArrayRes int id2) {
        return ResUtils.getResources().getStringArray(id2);
    }

    public static boolean getBoolean(@BoolRes int id2) {
        return ResUtils.getResources().getBoolean(id2);
    }

    public static int getInteger(@IntegerRes int id2) {
        return ResUtils.getResources().getInteger(id2);
    }

    public static String getAssets(String fileName) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String line;
            AssetManager assetManager = Utils.getAppContext().getAssets();
            BufferedReader bf = new BufferedReader(new InputStreamReader(assetManager.open(fileName)));
            while ((line = bf.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return stringBuilder.toString();
    }
}

