/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.popup;

import android.animation.Animator;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import com.zlylib.upperdialog.common.Align;
import com.zlylib.upperdialog.common.AnimatorHelper;
import com.zlylib.upperdialog.dialog.DialogLayer;
import com.zlylib.upperdialog.manager.DecorLayer;
import com.zlylib.upperdialog.utils.Utils;

public class PopupLayer
extends DialogLayer {
    private ViewTreeObserver.OnScrollChangedListener mOnScrollChangedListener;

    public PopupLayer(Context context) {
        super(context);
    }

    public PopupLayer(Activity activity) {
        super(activity);
    }

    public PopupLayer(View targetView) {
        super(Utils.requireNonNull(targetView, "targetView == null").getContext());
        this.getViewHolder().setTarget(targetView);
    }

    @Override
    protected DecorLayer.Level getLevel() {
        return DecorLayer.Level.POPUP;
    }

    @Override
    protected ViewHolder onCreateViewHolder() {
        return new ViewHolder();
    }

    @Override
    public ViewHolder getViewHolder() {
        return (ViewHolder)super.getViewHolder();
    }

    @Override
    protected Config onCreateConfig() {
        return new Config();
    }

    @Override
    public Config getConfig() {
        return (Config)super.getConfig();
    }

    @Override
    protected View onCreateChild(LayoutInflater inflater, ViewGroup parent) {
        return super.onCreateChild(inflater, parent);
    }

    @Override
    protected Animator onCreateDefContentInAnimator(View view) {
        return AnimatorHelper.createTopInAnim(view);
    }

    @Override
    protected Animator onCreateDefContentOutAnimator(View view) {
        return AnimatorHelper.createTopOutAnim(view);
    }

    @Override
    public void onAttach() {
        super.onAttach();
    }

    @Override
    public void onPreDraw() {
        super.onPreDraw();
    }

    @Override
    public void onShow() {
        super.onShow();
    }

    @Override
    public void onPreRemove() {
        super.onPreRemove();
    }

    @Override
    public void onDetach() {
        this.getViewHolder().getParent().getViewTreeObserver().removeOnScrollChangedListener(this.mOnScrollChangedListener);
        this.mOnScrollChangedListener = null;
        super.onDetach();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        Utils.getViewSize((View)this.getViewHolder().getBackground(), new Runnable(){

            @Override
            public void run() {
                PopupLayer.this.updateLocation();
            }
        });
    }

    @Override
    protected void initContainer() {
        super.initContainer();
        this.getViewHolder().getContentWrapper().setClipChildren(this.getConfig().mContentClip);
        this.getViewHolder().getChild().setClipChildren(this.getConfig().mContentClip);
        this.getViewHolder().getChild().setClipToPadding(false);
        FrameLayout.LayoutParams contentParams = (FrameLayout.LayoutParams)this.getViewHolder().getContent().getLayoutParams();
        FrameLayout.LayoutParams contentWrapperParams = (FrameLayout.LayoutParams)this.getViewHolder().getContentWrapper().getLayoutParams();
        contentWrapperParams.width = contentParams.width == -1 ? -1 : -2;
        contentWrapperParams.height = contentParams.height == -1 ? -1 : -2;
        this.getViewHolder().getContentWrapper().setLayoutParams((ViewGroup.LayoutParams)contentWrapperParams);
        Utils.getViewSize((View)this.getViewHolder().getChild(), new Runnable(){

            @Override
            public void run() {
                PopupLayer.this.updateLocation();
            }
        });
        this.mOnScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(){

            public void onScrollChanged() {
                if (PopupLayer.this.getConfig().mViewTreeScrollChangedToDismiss) {
                    PopupLayer.this.dismiss();
                }
                if (PopupLayer.this.getConfig().mOnViewTreeScrollChangedListener != null) {
                    PopupLayer.this.getConfig().mOnViewTreeScrollChangedListener.onScrollChanged();
                }
                PopupLayer.this.updateLocation();
            }
        };
        this.getViewHolder().getParent().getViewTreeObserver().addOnScrollChangedListener(this.mOnScrollChangedListener);
    }

    private void initContentWrapperLocation(int targetX, int targetY, int targetWidth, int targetHeight) {
        int[] lp = new int[2];
        this.getViewHolder().getChild().getLocationOnScreen(lp);
        int parentX = lp[0];
        int parentY = lp[1];
        int parentWidth = this.getViewHolder().getChild().getWidth();
        int parentHeight = this.getViewHolder().getChild().getHeight();
        int width = this.getViewHolder().getContentWrapper().getWidth();
        int height = this.getViewHolder().getContentWrapper().getHeight();
        FrameLayout.LayoutParams p = (FrameLayout.LayoutParams)this.getViewHolder().getContent().getLayoutParams();
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getViewHolder().getContentWrapper().getLayoutParams();
        float w = width;
        float h = height;
        float x = 0.0f;
        float y = 0.0f;
        switch (this.getConfig().mAlignHorizontal) {
            case CENTER: {
                int l;
                if (p.width == -1) {
                    l = targetX - parentX;
                    int r = parentX + parentWidth - (targetX + targetWidth);
                    if (l < r) {
                        w = targetWidth + l * 2;
                        x = 0.0f;
                    } else {
                        w = targetWidth + r * 2;
                        x = l - r;
                    }
                    w -= this.getConfig().mOffsetX;
                    break;
                }
                x = targetX - (width - targetWidth) / 2;
                break;
            }
            case TO_LEFT: {
                int l;
                if (p.width == -1) {
                    l = targetX - parentX;
                    w = l;
                    x = 0.0f;
                    w -= this.getConfig().mOffsetX;
                    break;
                }
                x = targetX - width;
                break;
            }
            case TO_RIGHT: {
                if (p.width == -1) {
                    int r = parentX + parentWidth - (targetX + targetWidth);
                    x = targetX + targetWidth;
                    w = r;
                    w -= this.getConfig().mOffsetX;
                    break;
                }
                x = targetX + targetWidth;
                break;
            }
            case ALIGN_LEFT: {
                int l;
                if (p.width == -1) {
                    l = targetX - parentX;
                    w = parentWidth - l;
                    x = targetX;
                    w -= this.getConfig().mOffsetX;
                    break;
                }
                x = targetX;
                break;
            }
            case ALIGN_RIGHT: {
                int l;
                if (p.width == -1) {
                    l = targetX - parentX;
                    w = l + targetWidth;
                    x = 0.0f;
                    w -= this.getConfig().mOffsetX;
                    break;
                }
                x = targetX - (width - targetWidth);
                break;
            }
            case ALIGN_PARENT_LEFT: {
                if (p.width == -1) {
                    x = 0.0f;
                    w -= this.getConfig().mOffsetX;
                    break;
                }
                x = 0.0f;
                break;
            }
            case ALIGN_PARENT_RIGHT: {
                if (p.width == -1) {
                    x = 0.0f;
                    w -= this.getConfig().mOffsetX;
                    break;
                }
                x = parentX + parentWidth - width;
                break;
            }
        }
        switch (this.getConfig().mAlignVertical) {
            case CENTER: {
                int t;
                if (p.height == -1) {
                    t = targetY - parentY;
                    int b = parentY + parentHeight - (targetY + targetHeight);
                    if (t < b) {
                        h = targetHeight + t * 2;
                        y = 0.0f;
                    } else {
                        h = targetHeight + b * 2;
                        y = t - b;
                    }
                } else {
                    y = targetY - (height - targetHeight) / 2;
                }
                h -= this.getConfig().mOffsetY;
                break;
            }
            case ABOVE: {
                int t;
                if (p.height == -1) {
                    t = targetY - parentY;
                    h = t;
                    x = 0.0f;
                    h -= this.getConfig().mOffsetY;
                    break;
                }
                y = targetY - height;
                break;
            }
            case BELOW: {
                if (p.height == -1) {
                    int b = parentY + parentHeight - (targetY + targetHeight);
                    y = targetY + targetHeight;
                    h = b;
                    h -= this.getConfig().mOffsetY;
                    break;
                }
                y = targetY + targetHeight;
                break;
            }
            case ALIGN_TOP: {
                int t;
                if (p.width == -1) {
                    t = targetY - parentY;
                    h = parentHeight - t;
                    y = targetY;
                    h -= this.getConfig().mOffsetY;
                    break;
                }
                y = targetY;
                break;
            }
            case ALIGN_BOTTOM: {
                int t;
                if (p.width == -1) {
                    t = targetY - parentY;
                    h = t + targetHeight;
                    h -= this.getConfig().mOffsetY;
                    y = 0.0f;
                    break;
                }
                y = targetY - (height - targetHeight);
                break;
            }
            case ALIGN_PARENT_TOP: {
                if (p.width == -1) {
                    h -= this.getConfig().mOffsetY;
                    y = 0.0f;
                    break;
                }
                y = 0.0f;
                break;
            }
            case ALIGN_PARENT_BOTTOM: {
                if (p.width == -1) {
                    h -= this.getConfig().mOffsetY;
                    y = 0.0f;
                    break;
                }
                y = parentY + parentHeight - height;
                break;
            }
        }
        boolean paramsChanged = false;
        if ((float)width != w) {
            paramsChanged = true;
        }
        if ((float)height != h) {
            paramsChanged = true;
        }
        if (paramsChanged) {
            params.width = (int)w;
            params.height = (int)h;
            this.getViewHolder().getContentWrapper().setLayoutParams((ViewGroup.LayoutParams)params);
        }
        if (this.getConfig().mUpdateLocationInterceptor != null) {
            float[] xy = new float[]{x, y};
            this.getConfig().mUpdateLocationInterceptor.interceptor(xy, params.width, params.height, targetX, targetY, targetWidth, targetHeight, parentX, parentY, parentWidth, parentHeight);
            x = xy[0];
            y = xy[1];
        }
        if (this.getConfig().mOffsetX != 0.0f) {
            x += this.getConfig().mOffsetX;
        }
        if (this.getConfig().mOffsetY != 0.0f) {
            y += this.getConfig().mOffsetY;
        }
        if (this.getConfig().mInside) {
            x = Utils.floatRange(x, 0.0f, (float)parentWidth - w);
            y = Utils.floatRange(y, 0.0f, (float)parentHeight - h);
        }
        this.getViewHolder().getContentWrapper().setX(x);
        this.getViewHolder().getContentWrapper().setY(y);
    }

    private void initBackgroundLocation() {
        float h;
        float w;
        float y;
        float x;
        FrameLayout.LayoutParams params;
        block16: {
            int parentH;
            float cwy;
            int cwh;
            int height;
            block15: {
                if (!this.getConfig().mBackgroundAlign) {
                    this.getViewHolder().getBackground().setX(0.0f);
                    this.getViewHolder().getBackground().setY(0.0f);
                    return;
                }
                params = (FrameLayout.LayoutParams)this.getViewHolder().getBackground().getLayoutParams();
                int width = this.getViewHolder().getBackground().getWidth();
                height = this.getViewHolder().getBackground().getHeight();
                int cww = this.getViewHolder().getContentWrapper().getWidth();
                cwh = this.getViewHolder().getContentWrapper().getHeight();
                float cwx = this.getViewHolder().getContentWrapper().getX();
                cwy = this.getViewHolder().getContentWrapper().getY();
                x = 0.0f;
                y = 0.0f;
                w = params.width;
                h = params.height;
                int parentW = this.getViewHolder().getChild().getWidth();
                parentH = this.getViewHolder().getChild().getHeight();
                if (this.getConfig().mAlignDirection != Align.Direction.HORIZONTAL) break block15;
                switch (this.getConfig().mAlignHorizontal) {
                    case TO_RIGHT: 
                    case ALIGN_LEFT: 
                    case ALIGN_PARENT_LEFT: {
                        x = cwx;
                        if (this.getConfig().mBackgroundResize) {
                            w = (int)((float)parentW - cwx);
                            break;
                        }
                        break block16;
                    }
                    case TO_LEFT: 
                    case ALIGN_RIGHT: 
                    case ALIGN_PARENT_RIGHT: {
                        x = -((float)width - (cwx + (float)cww));
                        if (this.getConfig().mBackgroundResize) {
                            w = cwx + (float)cww;
                            x = 0.0f;
                            break;
                        }
                        break block16;
                    }
                }
                break block16;
            }
            if (this.getConfig().mAlignDirection == Align.Direction.VERTICAL) {
                switch (this.getConfig().mAlignVertical) {
                    case BELOW: 
                    case ALIGN_TOP: 
                    case ALIGN_PARENT_TOP: {
                        y = cwy;
                        if (!this.getConfig().mBackgroundResize) break;
                        h = (int)((float)parentH - cwy);
                        break;
                    }
                    case ABOVE: 
                    case ALIGN_BOTTOM: 
                    case ALIGN_PARENT_BOTTOM: {
                        y = -((float)height - (cwy + (float)cwh));
                        if (!this.getConfig().mBackgroundResize) break;
                        h = cwy + (float)cwh;
                        y = 0.0f;
                        break;
                    }
                }
            }
        }
        boolean changed = false;
        if ((float)params.width != w) {
            changed = true;
        }
        if ((float)params.height != h) {
            changed = true;
        }
        if (changed) {
            params.width = (int)w;
            params.height = (int)h;
            this.getViewHolder().getBackground().setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.getViewHolder().getBackground().setX(x);
        this.getViewHolder().getBackground().setY(y);
    }

    @Override
    protected void initBackground() {
        super.initBackground();
    }

    @Override
    protected void initContent() {
        super.initContent();
        FrameLayout.LayoutParams contentParams = (FrameLayout.LayoutParams)this.getViewHolder().getContent().getLayoutParams();
        contentParams.gravity = -1;
        this.getViewHolder().getContent().setLayoutParams((ViewGroup.LayoutParams)contentParams);
    }

    public void updateLocation() {
        View target = this.getViewHolder().getTarget();
        int[] locationTarget = new int[]{0, 0};
        if (target != null) {
            target.getLocationOnScreen(locationTarget);
        }
        int[] locationRoot = new int[2];
        this.getViewHolder().getDecor().getLocationOnScreen(locationRoot);
        int targetX = locationTarget[0] - locationRoot[0];
        int targetY = locationTarget[1] - locationRoot[1];
        int targetWidth = 0;
        int targetHeight = 0;
        if (target != null) {
            targetWidth = target.getWidth();
            targetHeight = target.getHeight();
        }
        this.initContentWrapperLocation(targetX, targetY, targetWidth, targetHeight);
        this.initBackgroundLocation();
    }

    public PopupLayer updateLocationInterceptor(UpdateLocationInterceptor interceptor) {
        this.getConfig().mUpdateLocationInterceptor = interceptor;
        return this;
    }

    public PopupLayer onViewTreeScrollChangedListener(OnViewTreeScrollChangedListener listener) {
        this.getConfig().mOnViewTreeScrollChangedListener = listener;
        return this;
    }

    public PopupLayer scrollChangedToDismiss(boolean toDismiss) {
        this.getConfig().mViewTreeScrollChangedToDismiss = toDismiss;
        return this;
    }

    public PopupLayer targetView(View targetView) {
        this.getViewHolder().setTarget(targetView);
        this.updateLocation();
        return this;
    }

    public PopupLayer contentClip(boolean clip) {
        this.getConfig().mContentClip = clip;
        return this;
    }

    public PopupLayer backgroundAlign(boolean align) {
        this.getConfig().mBackgroundAlign = align;
        return this;
    }

    public PopupLayer backgroundOffset(boolean offset) {
        this.getConfig().mBackgroundOffset = offset;
        return this;
    }

    public PopupLayer backgroundResize(boolean resize) {
        this.getConfig().mBackgroundResize = resize;
        return this;
    }

    public PopupLayer align(Align.Direction direction, Align.Horizontal horizontal, Align.Vertical vertical, boolean inside) {
        this.getConfig().mAlignDirection = Utils.requireNonNull(direction, "direction == null");
        this.getConfig().mAlignHorizontal = Utils.requireNonNull(horizontal, "horizontal == null");
        this.getConfig().mAlignVertical = Utils.requireNonNull(vertical, "vertical == null");
        this.getConfig().mInside = inside;
        return this;
    }

    public PopupLayer direction(Align.Direction direction) {
        this.getConfig().mAlignDirection = Utils.requireNonNull(direction, "direction == null");
        return this;
    }

    public PopupLayer horizontal(Align.Horizontal horizontal) {
        this.getConfig().mAlignHorizontal = Utils.requireNonNull(horizontal, "horizontal == null");
        return this;
    }

    public PopupLayer vertical(Align.Vertical vertical) {
        this.getConfig().mAlignVertical = Utils.requireNonNull(vertical, "vertical == null");
        return this;
    }

    public PopupLayer inside(boolean inside) {
        this.getConfig().mInside = inside;
        return this;
    }

    public PopupLayer offsetX(float offsetX, int unit) {
        this.getConfig().mOffsetX = TypedValue.applyDimension((int)unit, (float)offsetX, (DisplayMetrics)this.getActivity().getResources().getDisplayMetrics());
        return this;
    }

    public PopupLayer offsetXdp(float dp) {
        this.getConfig().mOffsetX = dp;
        return this.offsetX(dp, 1);
    }

    public PopupLayer offsetXpx(float px) {
        this.getConfig().mOffsetX = px;
        return this.offsetX(px, 0);
    }

    public PopupLayer offsetY(float offsetY, int unit) {
        this.getConfig().mOffsetY = TypedValue.applyDimension((int)unit, (float)offsetY, (DisplayMetrics)this.getActivity().getResources().getDisplayMetrics());
        return this;
    }

    public PopupLayer offsetYdp(float dp) {
        this.getConfig().mOffsetY = dp;
        return this.offsetY(dp, 1);
    }

    public PopupLayer offsetYpY(float px) {
        this.getConfig().mOffsetY = px;
        return this.offsetY(px, 0);
    }

    public static interface OnViewTreeScrollChangedListener {
        public void onScrollChanged();
    }

    public static interface UpdateLocationInterceptor {
        public void interceptor(float[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);
    }

    protected static class ListenerHolder
    extends DialogLayer.ListenerHolder {
        protected ListenerHolder() {
        }
    }

    protected static class Config
    extends DialogLayer.Config {
        protected OnViewTreeScrollChangedListener mOnViewTreeScrollChangedListener = null;
        protected boolean mViewTreeScrollChangedToDismiss = false;
        protected UpdateLocationInterceptor mUpdateLocationInterceptor = null;
        protected boolean mContentClip = true;
        protected boolean mBackgroundAlign = true;
        protected boolean mBackgroundOffset = true;
        protected boolean mBackgroundResize = false;
        protected boolean mInside = true;
        protected Align.Direction mAlignDirection = Align.Direction.VERTICAL;
        protected Align.Horizontal mAlignHorizontal = Align.Horizontal.CENTER;
        protected Align.Vertical mAlignVertical = Align.Vertical.BELOW;
        protected float mOffsetX = 0.0f;
        protected float mOffsetY = 0.0f;

        protected Config() {
        }
    }

    public static class ViewHolder
    extends DialogLayer.ViewHolder {
        private View mTarget;

        public void setTarget(View target) {
            this.mTarget = target;
        }

        public View getTarget() {
            return this.mTarget;
        }
    }
}

