/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.upperdialog.dialog;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.zlylib.upperdialog.R;
import com.zlylib.upperdialog.common.AnimatorHelper;
import com.zlylib.upperdialog.manager.DecorLayer;
import com.zlylib.upperdialog.manager.Layer;
import com.zlylib.upperdialog.manager.SoftInputHelper;
import com.zlylib.upperdialog.utils.Utils;
import com.zlylib.upperdialog.view.BackgroundView;
import com.zlylib.upperdialog.view.ContainerLayout;
import com.zlylib.upperdialog.view.DragLayout;
import per.goweii.burred.Blurred;

public class DialogLayer
extends DecorLayer {
    private static final long ANIM_DUR_DEF = 220L;
    private static final float BG_DIM_AMOUNT_DEF = 0.6f;
    private SoftInputHelper mSoftInputHelper = null;

    public DialogLayer(Context context) {
        this(Utils.getActivity(Utils.requireNonNull(context, "context == null")));
    }

    public DialogLayer(Activity activity) {
        super(activity);
        this.getViewHolder().setActivityContent((FrameLayout)this.getViewHolder().getDecor().findViewById(0x1020002));
    }

    @Override
    protected DecorLayer.Level getLevel() {
        return DecorLayer.Level.DIALOG;
    }

    @Override
    protected ViewHolder onCreateViewHolder() {
        return new ViewHolder();
    }

    @Override
    public ViewHolder getViewHolder() {
        return (ViewHolder)super.getViewHolder();
    }

    @Override
    protected Config onCreateConfig() {
        return new Config();
    }

    @Override
    public Config getConfig() {
        return (Config)super.getConfig();
    }

    @Override
    protected View onCreateChild(LayoutInflater inflater, ViewGroup parent) {
        ContainerLayout container = (ContainerLayout)inflater.inflate(R.layout.anylayer_dialog_layer, parent, false);
        this.getViewHolder().setChild((View)container);
        this.getViewHolder().setContent(this.onCreateContent(inflater, (ViewGroup)this.getViewHolder().getContentWrapper()));
        this.getViewHolder().getContentWrapper().addView(this.getViewHolder().getContent());
        return container;
    }

    protected View onCreateContent(LayoutInflater inflater, ViewGroup parent) {
        if (this.getViewHolder().getContent() != null) {
            ViewGroup contentParent = (ViewGroup)this.getViewHolder().getContent().getParent();
            if (contentParent != null) {
                contentParent.removeView(this.getViewHolder().getContent());
            }
            return this.getViewHolder().getContent();
        }
        return inflater.inflate(this.getConfig().mContentViewId, parent, false);
    }

    @Override
    protected Animator onCreateInAnimator(View view) {
        Animator backgroundAnimator = this.onCreateBackgroundInAnimator((View)this.getViewHolder().getBackground());
        Animator contentAnimator = this.onCreateContentInAnimator(this.getViewHolder().getContent());
        if (backgroundAnimator == null && contentAnimator == null) {
            return null;
        }
        if (backgroundAnimator == null) {
            return contentAnimator;
        }
        if (contentAnimator == null) {
            return backgroundAnimator;
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{backgroundAnimator, contentAnimator});
        return animatorSet;
    }

    protected Animator onCreateBackgroundInAnimator(View view) {
        Animator backgroundAnimator = this.getConfig().mBackgroundAnimatorCreator != null ? this.getConfig().mBackgroundAnimatorCreator.createInAnimator(view) : this.onCreateDefBackgroundInAnimator(view);
        return backgroundAnimator;
    }

    protected Animator onCreateDefBackgroundInAnimator(View view) {
        return AnimatorHelper.createAlphaInAnim(view);
    }

    protected Animator onCreateContentInAnimator(View view) {
        Animator contentAnimator;
        if (this.getConfig().mContentAnimatorCreator != null) {
            contentAnimator = this.getConfig().mContentAnimatorCreator.createInAnimator(view);
        } else {
            if (this.getConfig().mAnimStyle != null) {
                switch (this.getConfig().mAnimStyle) {
                    case ALPHA: {
                        contentAnimator = AnimatorHelper.createAlphaInAnim(view);
                        break;
                    }
                    case ZOOM: {
                        contentAnimator = AnimatorHelper.createZoomInAnim(view);
                        break;
                    }
                    case LEFT: {
                        contentAnimator = AnimatorHelper.createLeftInAnim(view);
                        break;
                    }
                    case RIGHT: {
                        contentAnimator = AnimatorHelper.createRightInAnim(view);
                        break;
                    }
                    case TOP: {
                        contentAnimator = AnimatorHelper.createTopInAnim(view);
                        break;
                    }
                    case BOTTOM: {
                        contentAnimator = AnimatorHelper.createBottomInAnim(view);
                        break;
                    }
                    default: {
                        contentAnimator = this.onCreateDefContentInAnimator(view);
                        break;
                    }
                }
            } else {
                switch (this.getConfig().mDragStyle) {
                    case Left: {
                        contentAnimator = AnimatorHelper.createLeftInAnim(view);
                        break;
                    }
                    case Top: {
                        contentAnimator = AnimatorHelper.createTopInAnim(view);
                        break;
                    }
                    case Right: {
                        contentAnimator = AnimatorHelper.createRightInAnim(view);
                        break;
                    }
                    case Bottom: {
                        contentAnimator = AnimatorHelper.createBottomInAnim(view);
                        break;
                    }
                    default: {
                        contentAnimator = this.onCreateDefContentInAnimator(view);
                    }
                }
            }
            contentAnimator.setDuration(220L);
        }
        return contentAnimator;
    }

    protected Animator onCreateDefContentInAnimator(View view) {
        return AnimatorHelper.createZoomAlphaInAnim(view);
    }

    @Override
    protected Animator onCreateOutAnimator(View view) {
        Animator backgroundAnimator = this.onCreateBackgroundOutAnimator((View)this.getViewHolder().getBackground());
        Animator contentAnimator = this.onCreateContentOutAnimator(this.getViewHolder().getContent());
        if (backgroundAnimator == null && contentAnimator == null) {
            return null;
        }
        if (backgroundAnimator == null) {
            return contentAnimator;
        }
        if (contentAnimator == null) {
            return backgroundAnimator;
        }
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.playTogether(new Animator[]{backgroundAnimator, contentAnimator});
        return animatorSet;
    }

    protected Animator onCreateBackgroundOutAnimator(View view) {
        Animator backgroundAnimator = this.getConfig().mBackgroundAnimatorCreator != null ? this.getConfig().mBackgroundAnimatorCreator.createOutAnimator(view) : AnimatorHelper.createAlphaOutAnim(view);
        if (this.getConfig().mContentAnimatorCreator == null) {
            backgroundAnimator.setDuration(220L);
        }
        return backgroundAnimator;
    }

    protected Animator onCreateDefBackgroundOutAnimator(View view) {
        return AnimatorHelper.createAlphaOutAnim(view);
    }

    protected Animator onCreateContentOutAnimator(View view) {
        Animator contentAnimator;
        if (this.getConfig().mContentAnimatorCreator != null) {
            contentAnimator = this.getConfig().mContentAnimatorCreator.createOutAnimator(view);
        } else {
            if (this.getConfig().mAnimStyle != null) {
                switch (this.getConfig().mAnimStyle) {
                    case ALPHA: {
                        contentAnimator = AnimatorHelper.createAlphaOutAnim(view);
                        break;
                    }
                    case ZOOM: {
                        contentAnimator = AnimatorHelper.createZoomOutAnim(view);
                        break;
                    }
                    case LEFT: {
                        contentAnimator = AnimatorHelper.createLeftOutAnim(view);
                        break;
                    }
                    case RIGHT: {
                        contentAnimator = AnimatorHelper.createRightOutAnim(view);
                        break;
                    }
                    case TOP: {
                        contentAnimator = AnimatorHelper.createTopOutAnim(view);
                        break;
                    }
                    case BOTTOM: {
                        contentAnimator = AnimatorHelper.createBottomOutAnim(view);
                        break;
                    }
                    default: {
                        contentAnimator = this.onCreateDefContentOutAnimator(view);
                        break;
                    }
                }
            } else {
                switch (this.getConfig().mDragStyle) {
                    case Left: {
                        contentAnimator = AnimatorHelper.createLeftOutAnim(view);
                        break;
                    }
                    case Top: {
                        contentAnimator = AnimatorHelper.createTopOutAnim(view);
                        break;
                    }
                    case Right: {
                        contentAnimator = AnimatorHelper.createRightOutAnim(view);
                        break;
                    }
                    case Bottom: {
                        contentAnimator = AnimatorHelper.createBottomOutAnim(view);
                        break;
                    }
                    default: {
                        contentAnimator = this.onCreateDefContentOutAnimator(view);
                    }
                }
            }
            contentAnimator.setDuration(220L);
        }
        return contentAnimator;
    }

    protected Animator onCreateDefContentOutAnimator(View view) {
        return AnimatorHelper.createZoomAlphaOutAnim(view);
    }

    @Override
    public void onAttach() {
        super.onAttach();
        this.initContent();
        this.initBackground();
        this.initContainer();
    }

    @Override
    public void onPreDraw() {
        super.onPreDraw();
    }

    @Override
    public void onShow() {
        super.onShow();
    }

    @Override
    public void onPreRemove() {
        super.onPreRemove();
    }

    @Override
    public void onDetach() {
        super.onDetach();
        this.getViewHolder().recycle();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        Utils.getViewSize((View)this.getViewHolder().getBackground(), new Runnable(){

            @Override
            public void run() {
                DialogLayer.this.fitContainerToActivityContent();
            }
        });
    }

    protected void initContainer() {
        if (this.getConfig().mOutsideInterceptTouchEvent) {
            this.getViewHolder().getChild().setClickable(true);
            if (this.getConfig().mCancelableOnTouchOutside) {
                this.getViewHolder().getChild().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        DialogLayer.this.dismiss();
                    }
                });
            }
        } else {
            this.getViewHolder().getChild().setOnClickListener(null);
            this.getViewHolder().getChild().setClickable(false);
        }
        if (this.getConfig().mOutsideTouchedToDismiss || this.getConfig().mOutsideTouchedListener != null) {
            this.getViewHolder().getChild().setOnTouchedListener(new ContainerLayout.OnTouchedListener(){

                @Override
                public void onTouched() {
                    if (DialogLayer.this.getConfig().mOutsideTouchedToDismiss) {
                        DialogLayer.this.dismiss();
                    }
                    if (DialogLayer.this.getConfig().mOutsideTouchedListener != null) {
                        DialogLayer.this.getConfig().mOutsideTouchedListener.outsideTouched();
                    }
                }
            });
        }
        this.fitContainerToActivityContent();
        FrameLayout.LayoutParams contentWrapperParams = (FrameLayout.LayoutParams)this.getViewHolder().getContentWrapper().getLayoutParams();
        contentWrapperParams.width = -1;
        contentWrapperParams.height = -1;
        this.getViewHolder().getContentWrapper().setLayoutParams((ViewGroup.LayoutParams)contentWrapperParams);
        if (this.getConfig().mAvoidStatusBar) {
            this.getViewHolder().getContentWrapper().setPadding(0, Utils.getStatusBarHeight((Context)this.getActivity()), 0, 0);
            this.getViewHolder().getContentWrapper().setClipToPadding(false);
        } else {
            this.getViewHolder().getContentWrapper().setPadding(0, 0, 0, 0);
            this.getViewHolder().getContentWrapper().setClipToPadding(true);
        }
        this.getViewHolder().getContentWrapper().setDragStyle(this.getConfig().mDragStyle);
        this.getViewHolder().getContentWrapper().setOnDragListener(new DragLayout.OnDragListener(){

            @Override
            public void onDragStart() {
                if (DialogLayer.this.getConfig().mDragTransformer == null) {
                    DialogLayer.this.getConfig().mDragTransformer = new DragTransformer(){

                        @Override
                        public void onDragging(View content, View background, float f) {
                            background.setAlpha(1.0f - f);
                        }
                    };
                }
            }

            @Override
            public void onDragging(float f) {
                if (DialogLayer.this.getConfig().mDragTransformer != null) {
                    DialogLayer.this.getConfig().mDragTransformer.onDragging(DialogLayer.this.getViewHolder().getContent(), (View)DialogLayer.this.getViewHolder().getBackground(), f);
                }
            }

            @Override
            public void onDragEnd() {
                DialogLayer.this.getViewHolder().getContentWrapper().setVisibility(4);
                DialogLayer.this.getViewHolder().getContentWrapper().post(new Runnable(){

                    @Override
                    public void run() {
                        DialogLayer.this.dismiss(false);
                    }
                });
            }
        });
        this.getViewHolder().getContentWrapper().setVisibility(0);
    }

    private void fitContainerToActivityContent() {
        int dh = this.getViewHolder().getDecor().getHeight();
        int dw = this.getViewHolder().getDecor().getWidth();
        int[] dl = new int[2];
        this.getViewHolder().getDecor().getLocationOnScreen(dl);
        int ach = this.getViewHolder().getActivityContent().getHeight();
        int acw = this.getViewHolder().getActivityContent().getWidth();
        int[] acl = new int[2];
        this.getViewHolder().getActivityContent().getLocationOnScreen(acl);
        FrameLayout.LayoutParams containerParams = (FrameLayout.LayoutParams)this.getViewHolder().getChild().getLayoutParams();
        containerParams.leftMargin = 0;
        containerParams.topMargin = 0;
        containerParams.rightMargin = dl[0] + dw - (acl[0] + acw);
        containerParams.bottomMargin = dl[1] + dh - (acl[1] + ach);
        this.getViewHolder().getChild().setLayoutParams((ViewGroup.LayoutParams)containerParams);
    }

    protected void initBackground() {
        if (this.getConfig().mBackgroundBlurPercent > 0.0f || this.getConfig().mBackgroundBlurRadius > 0.0f) {
            Utils.getViewSize((View)this.getViewHolder().getBackground(), new Runnable(){

                @Override
                public void run() {
                    float radius = DialogLayer.this.getConfig().mBackgroundBlurRadius;
                    if (DialogLayer.this.getConfig().mBackgroundBlurPercent > 0.0f) {
                        int w = DialogLayer.this.getViewHolder().getBackground().getWidth();
                        int h = DialogLayer.this.getViewHolder().getBackground().getHeight();
                        int min = Math.min(w, h);
                        radius = (float)min * DialogLayer.this.getConfig().mBackgroundBlurPercent;
                    }
                    float scale = DialogLayer.this.getConfig().mBackgroundBlurScale;
                    if (radius > 25.0f) {
                        scale *= radius / 25.0f;
                        radius = 25.0f;
                    }
                    Bitmap snapshot = Utils.snapshot(DialogLayer.this.getViewHolder().getDecor(), DialogLayer.this.getViewHolder().getBackground(), scale, DialogLayer.this.getViewHolder().getParent(), DialogLayer.this.getViewHolder().getChild());
                    Blurred.init((Context)DialogLayer.this.getActivity());
                    Bitmap blurBitmap = Blurred.with((Bitmap)snapshot).recycleOriginal(true).keepSize(false).radius(radius).blur();
                    DialogLayer.this.getViewHolder().getBackground().setScaleType(ImageView.ScaleType.CENTER_CROP);
                    DialogLayer.this.getViewHolder().getBackground().setImageBitmap(blurBitmap);
                    DialogLayer.this.getViewHolder().getBackground().setColorFilter(DialogLayer.this.getConfig().mBackgroundColor);
                }
            });
        } else if (this.getConfig().mBackgroundBitmap != null) {
            this.getViewHolder().getBackground().setImageBitmap(this.getConfig().mBackgroundBitmap);
            if (this.getConfig().mBackgroundColor != -1) {
                this.getViewHolder().getBackground().setColorFilter(this.getConfig().mBackgroundColor);
            }
        } else if (this.getConfig().mBackgroundDrawable != null) {
            this.getViewHolder().getBackground().setImageDrawable(this.getConfig().mBackgroundDrawable);
            if (this.getConfig().mBackgroundColor != -1) {
                this.getViewHolder().getBackground().setColorFilter(this.getConfig().mBackgroundColor);
            }
        } else if (this.getConfig().mBackgroundResource != -1) {
            this.getViewHolder().getBackground().setImageResource(this.getConfig().mBackgroundResource);
            if (this.getConfig().mBackgroundColor != -1) {
                this.getViewHolder().getBackground().setColorFilter(this.getConfig().mBackgroundColor);
            }
        } else if (this.getConfig().mBackgroundColor != -1) {
            this.getViewHolder().getBackground().setImageDrawable((Drawable)new ColorDrawable(this.getConfig().mBackgroundColor));
        } else if (this.getConfig().mBackgroundDimAmount != -1.0f) {
            int color2 = Color.argb((int)((int)(255.0f * Utils.floatRange01(this.getConfig().mBackgroundDimAmount))), (int)0, (int)0, (int)0);
            this.getViewHolder().getBackground().setImageDrawable((Drawable)new ColorDrawable(color2));
        } else {
            this.getViewHolder().getBackground().setImageDrawable((Drawable)new ColorDrawable(0));
        }
    }

    protected void initContent() {
        View statusBar;
        this.getViewHolder().getContent().setClickable(true);
        ViewGroup.LayoutParams layoutParams = this.getViewHolder().getContent().getLayoutParams();
        FrameLayout.LayoutParams contentParams = layoutParams == null ? new FrameLayout.LayoutParams(-2, -2) : (layoutParams instanceof FrameLayout.LayoutParams ? (FrameLayout.LayoutParams)layoutParams : new FrameLayout.LayoutParams(layoutParams.width, layoutParams.height));
        if (this.getConfig().mGravity != -1) {
            contentParams.gravity = this.getConfig().mGravity;
        }
        this.getViewHolder().getContent().setLayoutParams((ViewGroup.LayoutParams)contentParams);
        if (this.getConfig().mAsStatusBarViewId > 0 && (statusBar = this.getViewHolder().getContent().findViewById(this.getConfig().mAsStatusBarViewId)) != null) {
            ViewGroup.LayoutParams params = statusBar.getLayoutParams();
            params.height = Utils.getStatusBarHeight((Context)this.getActivity());
            statusBar.setLayoutParams(params);
            statusBar.setVisibility(0);
        }
    }

    public DialogLayer contentView(View contentView) {
        Utils.requireNonNull(contentView, "contentView == null");
        this.getViewHolder().setContent(contentView);
        return this;
    }

    public DialogLayer contentView(int contentViewId) {
        this.getConfig().mContentViewId = contentViewId;
        return this;
    }

    public DialogLayer asStatusBar(int statusBarId) {
        this.getConfig().mAsStatusBarViewId = statusBarId;
        return this;
    }

    public DialogLayer avoidStatusBar(boolean avoid) {
        this.getConfig().mAvoidStatusBar = avoid;
        return this;
    }

    public DialogLayer gravity(int gravity) {
        this.getConfig().mGravity = gravity;
        return this;
    }

    public DialogLayer dragDismiss(DragLayout.DragStyle dragStyle) {
        this.getConfig().mDragStyle = dragStyle;
        return this;
    }

    public DialogLayer dragTransformer(DragTransformer dragTransformer) {
        this.getConfig().mDragTransformer = dragTransformer;
        return this;
    }

    public DialogLayer animStyle(AnimStyle animStyle) {
        this.getConfig().mAnimStyle = animStyle;
        return this;
    }

    public DialogLayer contentAnimator(Layer.AnimatorCreator contentAnimatorCreator) {
        this.getConfig().mContentAnimatorCreator = contentAnimatorCreator;
        return this;
    }

    public DialogLayer backgroundAnimator(Layer.AnimatorCreator backgroundAnimatorCreator) {
        this.getConfig().mBackgroundAnimatorCreator = backgroundAnimatorCreator;
        return this;
    }

    public DialogLayer backgroundBlurRadius(float radius) {
        this.getConfig().mBackgroundBlurRadius = radius;
        return this;
    }

    public DialogLayer backgroundBlurPercent(float percent) {
        this.getConfig().mBackgroundBlurPercent = percent;
        return this;
    }

    public DialogLayer backgroundBlurScale(float scale) {
        this.getConfig().mBackgroundBlurScale = scale;
        return this;
    }

    public DialogLayer backgroundBitmap(Bitmap bitmap) {
        Utils.requireNonNull(bitmap, "bitmap == null");
        this.getConfig().mBackgroundBitmap = bitmap;
        return this;
    }

    public DialogLayer backgroundDimAmount(float dimAmount) {
        this.getConfig().mBackgroundDimAmount = Utils.floatRange01(dimAmount);
        return this;
    }

    public DialogLayer backgroundDimDefault() {
        return this.backgroundDimAmount(0.6f);
    }

    public DialogLayer backgroundResource(int resource) {
        this.getConfig().mBackgroundResource = resource;
        return this;
    }

    public DialogLayer backgroundDrawable(Drawable drawable) {
        Utils.requireNonNull(drawable, "drawable == null");
        this.getConfig().mBackgroundDrawable = drawable;
        return this;
    }

    public DialogLayer backgroundColorInt(int colorInt) {
        this.getConfig().mBackgroundColor = colorInt;
        return this;
    }

    public DialogLayer backgroundColorRes(int colorRes) {
        this.getConfig().mBackgroundColor = this.getActivity().getResources().getColor(colorRes);
        return this;
    }

    public DialogLayer cancelableOnTouchOutside(boolean cancelable) {
        this.getConfig().mCancelableOnTouchOutside = cancelable;
        return this;
    }

    @Override
    public DialogLayer cancelableOnClickKeyBack(boolean cancelable) {
        return (DialogLayer)super.cancelableOnClickKeyBack(cancelable);
    }

    public View getContentView() {
        return this.getViewHolder().getContent();
    }

    public ImageView getBackground() {
        return this.getViewHolder().getBackground();
    }

    public DialogLayer compatSoftInput(boolean bottomToContentView, EditText ... editTexts) {
        if (this.mSoftInputHelper == null) {
            this.mSoftInputHelper = SoftInputHelper.attach(this.getActivity()).moveWithTranslation().moveBy((View)this.getViewHolder().getContentWrapper());
        }
        if (bottomToContentView) {
            this.mSoftInputHelper.moveWith(this.getViewHolder().getContent(), (View[])editTexts);
        } else {
            for (EditText editText : editTexts) {
                this.mSoftInputHelper.moveWith((View)editText, new View[]{editText});
            }
        }
        return this;
    }

    public DialogLayer compatSoftInput(EditText ... editTexts) {
        return this.compatSoftInput(true, editTexts);
    }

    public void removeSoftInput() {
        if (this.mSoftInputHelper != null) {
            this.mSoftInputHelper.detach();
        }
    }

    public DialogLayer outsideInterceptTouchEvent(boolean intercept) {
        this.getConfig().mOutsideInterceptTouchEvent = intercept;
        return this;
    }

    public DialogLayer outsideTouched(OutsideTouchedListener listener) {
        this.getConfig().mOutsideTouchedListener = listener;
        return this;
    }

    public DialogLayer outsideTouchedToDismiss(boolean toDismiss) {
        this.getConfig().mOutsideTouchedToDismiss = toDismiss;
        return this;
    }

    public static enum AnimStyle {
        ALPHA,
        ZOOM,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }

    public static interface DragTransformer {
        public void onDragging(View var1, View var2, float var3);
    }

    public static interface OutsideTouchedListener {
        public void outsideTouched();
    }

    protected static class ListenerHolder
    extends DecorLayer.ListenerHolder {
        protected ListenerHolder() {
        }
    }

    protected static class Config
    extends DecorLayer.Config {
        protected boolean mOutsideInterceptTouchEvent = true;
        protected OutsideTouchedListener mOutsideTouchedListener = null;
        protected boolean mOutsideTouchedToDismiss = false;
        protected Layer.AnimatorCreator mBackgroundAnimatorCreator = null;
        protected Layer.AnimatorCreator mContentAnimatorCreator = null;
        protected AnimStyle mAnimStyle = null;
        protected int mContentViewId = 0;
        protected boolean mCancelableOnTouchOutside = true;
        protected int mAsStatusBarViewId = 0;
        protected boolean mAvoidStatusBar = false;
        protected int mGravity = 17;
        protected float mBackgroundBlurPercent = 0.0f;
        protected float mBackgroundBlurRadius = 0.0f;
        protected float mBackgroundBlurScale = 2.0f;
        protected Bitmap mBackgroundBitmap = null;
        protected int mBackgroundResource = -1;
        protected Drawable mBackgroundDrawable = null;
        protected float mBackgroundDimAmount = -1.0f;
        protected int mBackgroundColor = -1;
        protected DragLayout.DragStyle mDragStyle = DragLayout.DragStyle.None;
        protected DragTransformer mDragTransformer = null;

        protected Config() {
        }
    }

    public static class ViewHolder
    extends DecorLayer.ViewHolder {
        private FrameLayout mActivityContent;
        private BackgroundView mBackground;
        private DragLayout mContentWrapper;
        private View mContent;

        public void recycle() {
            if (this.mBackground.getDrawable() instanceof BitmapDrawable) {
                BitmapDrawable bd = (BitmapDrawable)this.mBackground.getDrawable();
                bd.getBitmap().recycle();
            }
        }

        public void setActivityContent(FrameLayout activityContent) {
            this.mActivityContent = activityContent;
        }

        public FrameLayout getActivityContent() {
            return this.mActivityContent;
        }

        @Override
        public void setChild(View child) {
            super.setChild(child);
            this.mContentWrapper = (DragLayout)this.getChild().findViewById(R.id.fl_content_wrapper);
            this.mBackground = (BackgroundView)this.getChild().findViewById(R.id.iv_background);
        }

        public ContainerLayout getChild() {
            return (ContainerLayout)super.getChild();
        }

        void setContent(View content) {
            this.mContent = content;
        }

        public View getContent() {
            return this.mContent;
        }

        public DragLayout getContentWrapper() {
            return this.mContentWrapper;
        }

        public BackgroundView getBackground() {
            return this.mBackground;
        }
    }
}

