/*
 * Decompiled with CFR 0.152.
 */
package com.zlylib.titlebarlib;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.zlylib.titlebarlib.OnActionBarChildClickListener;
import com.zlylib.titlebarlib.R;
import com.zlylib.titlebarlib.widget.ActionBarEx;

public final class ActionBarCommon
extends ActionBarEx {
    private String leftText;
    private float leftTextSize;
    private int leftTextColor;
    private int leftTextPaddingLeft;
    private int leftTextPaddingRight;
    private int leftIconRes;
    private int leftIconColor;
    private int leftIconPadding;
    private int leftIconMarginLeft;
    private String rightText;
    private float rightTextSize;
    private int rightTextColor;
    private int rightTextPaddingLeft;
    private int rightTextPaddingRight;
    private int rightIconRes;
    private int rightIconColor;
    private int rightIconPadding;
    private int rightIconMarginRight;
    private String titleText;
    private float titleTextSize;
    private int titleTextColor;
    private int titleTextMaxWidth;
    private boolean leftTextClickToFinish;
    private boolean leftIconClickToFinish;
    private ImageView leftIconView;
    private TextView leftTextView;
    private TextView titleTextView;
    private TextView rightTextView;
    private ImageView rightIconView;
    private boolean centerTextMarquee = true;

    public ActionBarCommon(Context context) {
        this(context, null);
    }

    public ActionBarCommon(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ActionBarCommon(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ImageView getLeftIconView() {
        return this.leftIconView;
    }

    public TextView getLeftTextView() {
        return this.leftTextView;
    }

    public TextView getTitleTextView() {
        return this.titleTextView;
    }

    public TextView getRightTextView() {
        return this.rightTextView;
    }

    public ImageView getRightIconView() {
        return this.rightIconView;
    }

    @Override
    protected void initAttrs(AttributeSet attrs) {
        super.initAttrs(attrs);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.ActionBarCommon);
        float titleTextMaxWidthDef = this.getContext().getResources().getDimension(R.dimen.actionbarex_common_title_bar_title_text_max_width_def);
        float iconPaddingDef = this.getContext().getResources().getDimension(R.dimen.actionbarex_common_title_bar_icon_padding_def);
        float textSizeDef = this.getContext().getResources().getDimension(R.dimen.actionbarex_common_title_bar_text_size_def);
        float textPaddingLeftDef = this.getContext().getResources().getDimension(R.dimen.actionbarex_common_title_bar_text_padding_left_def);
        float textPaddingRightDef = this.getContext().getResources().getDimension(R.dimen.actionbarex_common_title_bar_text_padding_right_def);
        float titleTextSizeDef = this.getContext().getResources().getDimension(R.dimen.actionbarex_common_title_bar_title_text_size_def);
        int iconColorDef = ContextCompat.getColor((Context)this.getContext(), (int)R.color.actionbarex_common_title_bar_icon_color_def);
        int textColorDef = ContextCompat.getColor((Context)this.getContext(), (int)R.color.actionbarex_common_title_bar_text_color_def);
        int titleTextColorDef = ContextCompat.getColor((Context)this.getContext(), (int)R.color.actionbarex_common_title_bar_title_text_color_def);
        this.leftTextClickToFinish = typedArray.getBoolean(R.styleable.ActionBarCommon_abc_leftTextClickToFinish, false);
        this.leftIconClickToFinish = typedArray.getBoolean(R.styleable.ActionBarCommon_abc_leftIconClickToFinish, false);
        this.leftText = typedArray.getString(R.styleable.ActionBarCommon_abc_leftText);
        this.leftTextSize = typedArray.getDimension(R.styleable.ActionBarCommon_abc_leftTextSize, textSizeDef);
        this.leftTextColor = typedArray.getColor(R.styleable.ActionBarCommon_abc_leftTextColor, textColorDef);
        this.leftTextPaddingLeft = (int)typedArray.getDimension(R.styleable.ActionBarCommon_abc_leftTextPaddingLeft, textPaddingLeftDef);
        this.leftTextPaddingRight = (int)typedArray.getDimension(R.styleable.ActionBarCommon_abc_leftTextPaddingRight, textPaddingRightDef);
        this.leftIconRes = typedArray.getResourceId(R.styleable.ActionBarCommon_abc_leftIconRes, 0);
        this.leftIconColor = typedArray.getColor(R.styleable.ActionBarCommon_abc_leftIconColor, iconColorDef);
        this.leftIconPadding = (int)typedArray.getDimension(R.styleable.ActionBarCommon_abc_leftIconPadding, iconPaddingDef);
        this.leftIconMarginLeft = (int)typedArray.getDimension(R.styleable.ActionBarCommon_abc_leftIconMarginLeft, 0.0f);
        this.rightText = typedArray.getString(R.styleable.ActionBarCommon_abc_rightText);
        this.rightTextSize = typedArray.getDimension(R.styleable.ActionBarCommon_abc_rightTextSize, textSizeDef);
        this.rightTextColor = typedArray.getColor(R.styleable.ActionBarCommon_abc_rightTextColor, textColorDef);
        this.rightTextPaddingLeft = (int)typedArray.getDimension(R.styleable.ActionBarCommon_abc_rightTextPaddingLeft, textPaddingLeftDef);
        this.rightTextPaddingRight = (int)typedArray.getDimension(R.styleable.ActionBarCommon_abc_rightTextPaddingRight, textPaddingRightDef);
        this.rightIconRes = typedArray.getResourceId(R.styleable.ActionBarCommon_abc_rightIconRes, 0);
        this.rightIconColor = typedArray.getColor(R.styleable.ActionBarCommon_abc_rightIconColor, iconColorDef);
        this.rightIconPadding = (int)typedArray.getDimension(R.styleable.ActionBarCommon_abc_rightIconPadding, iconPaddingDef);
        this.rightIconMarginRight = (int)typedArray.getDimension(R.styleable.ActionBarCommon_abc_rightIconMarginRight, 0.0f);
        this.titleText = typedArray.getString(R.styleable.ActionBarCommon_abc_titleText);
        this.titleTextSize = typedArray.getDimension(R.styleable.ActionBarCommon_abc_titleTextSize, titleTextSizeDef);
        this.titleTextColor = typedArray.getColor(R.styleable.ActionBarCommon_abc_titleTextColor, titleTextColorDef);
        this.titleTextMaxWidth = (int)typedArray.getDimension(R.styleable.ActionBarCommon_abc_titleTextMaxWidth, titleTextMaxWidthDef);
        typedArray.recycle();
    }

    @Override
    protected View inflateTitleBar() {
        RelativeLayout titleBarChild = (RelativeLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.actionbarex_common_action_bar_title_bar_common, (ViewGroup)this.getTitleBar(), false);
        this.leftIconView = (ImageView)titleBarChild.findViewById(R.id.actionbarex_common_iv_left);
        this.leftTextView = (TextView)titleBarChild.findViewById(R.id.actionbarex_common_tv_left);
        this.titleTextView = (TextView)titleBarChild.findViewById(R.id.actionbarex_common_tv_title);
        this.rightTextView = (TextView)titleBarChild.findViewById(R.id.actionbarex_common_tv_right);
        this.rightIconView = (ImageView)titleBarChild.findViewById(R.id.actionbarex_common_iv_right);
        LinearLayout.LayoutParams leftIconViewParams = (LinearLayout.LayoutParams)this.leftIconView.getLayoutParams();
        leftIconViewParams.leftMargin = this.leftIconMarginLeft;
        this.leftIconView.setLayoutParams((ViewGroup.LayoutParams)leftIconViewParams);
        if (this.leftIconRes > 0) {
            this.leftIconView.setVisibility(0);
            this.leftIconView.setPadding(this.leftIconPadding, this.leftIconPadding, this.leftIconPadding, this.leftIconPadding);
            this.leftIconView.setImageResource(this.leftIconRes);
            this.leftIconView.setColorFilter(this.leftIconColor);
            if (this.leftIconClickToFinish) {
                this.leftIconView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ActionBarCommon.this.finishActivity();
                    }
                });
            }
        } else {
            this.leftIconView.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.leftText)) {
            this.leftTextView.setVisibility(0);
            this.leftTextView.setText((CharSequence)this.leftText);
            this.leftTextView.setTextColor(this.leftTextColor);
            this.leftTextView.setTextSize(0, this.leftTextSize);
            this.leftTextView.setPadding(this.leftTextPaddingLeft, 0, this.leftTextPaddingRight, 0);
            if (this.leftTextClickToFinish) {
                this.leftTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ActionBarCommon.this.finishActivity();
                    }
                });
            }
        } else {
            this.leftTextView.setVisibility(8);
        }
        this.titleTextView.setVisibility(0);
        this.titleTextView.setText((CharSequence)this.titleText);
        this.titleTextView.setTextColor(this.titleTextColor);
        this.titleTextView.setTextSize(0, this.titleTextSize);
        this.titleTextView.setMaxWidth(this.titleTextMaxWidth);
        LinearLayout.LayoutParams rightIconViewParams = (LinearLayout.LayoutParams)this.rightIconView.getLayoutParams();
        rightIconViewParams.rightMargin = this.rightIconMarginRight;
        this.rightIconView.setLayoutParams((ViewGroup.LayoutParams)rightIconViewParams);
        if (this.rightIconRes > 0) {
            this.rightIconView.setVisibility(0);
            this.rightIconView.setPadding(this.rightIconPadding, this.rightIconPadding, this.rightIconPadding, this.rightIconPadding);
            this.rightIconView.setImageResource(this.rightIconRes);
            this.rightIconView.setColorFilter(this.rightIconColor);
        } else {
            this.rightIconView.setVisibility(8);
        }
        if (!TextUtils.isEmpty((CharSequence)this.rightText)) {
            this.rightTextView.setVisibility(0);
            this.rightTextView.setText((CharSequence)this.rightText);
            this.rightTextView.setTextColor(this.rightTextColor);
            this.rightTextView.setTextSize(0, this.rightTextSize);
            this.rightTextView.setPadding(this.rightTextPaddingLeft, 0, this.rightTextPaddingRight, 0);
        } else {
            this.rightTextView.setVisibility(8);
        }
        return titleBarChild;
    }

    public void setOnLeftIconClickListener(final OnActionBarChildClickListener onLeftIconClickListener) {
        this.leftIconView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (onLeftIconClickListener != null) {
                    onLeftIconClickListener.onClick(v);
                }
            }
        });
    }

    public void setOnLeftTextClickListener(final OnActionBarChildClickListener onLeftTextClickListener) {
        this.leftTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (onLeftTextClickListener != null) {
                    onLeftTextClickListener.onClick(v);
                }
            }
        });
    }

    public void setOnRightTextClickListener(final OnActionBarChildClickListener onRightTextClickListener) {
        this.rightTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (onRightTextClickListener != null) {
                    onRightTextClickListener.onClick(v);
                }
            }
        });
    }

    public void setOnRightIconClickListener(final OnActionBarChildClickListener onRightIconClickListener) {
        this.rightIconView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (onRightIconClickListener != null) {
                    onRightIconClickListener.onClick(v);
                }
            }
        });
    }
}

