/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.android.schedulers;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.HandlerScheduler;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.disposables.Disposables;
import io.reactivex.functions.Function;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class HandlerImmediateScheduler
extends Scheduler {
    private final Handler handler;
    private final HandlerScheduler impl;

    public HandlerImmediateScheduler(@NonNull Handler handler, boolean async) {
        this.handler = Objects.requireNonNull(handler);
        this.impl = new HandlerScheduler(handler, async);
    }

    public Disposable scheduleDirect(@NonNull Runnable run) {
        if (this.handler.getLooper() == Looper.myLooper()) {
            RxJavaPlugins.onSchedule((Runnable)run).run();
            return Disposables.disposed();
        }
        return this.impl.scheduleDirect(run);
    }

    public void start() {
        this.impl.start();
    }

    public void shutdown() {
        this.impl.shutdown();
    }

    public long now(@NonNull TimeUnit unit) {
        return this.impl.now(unit);
    }

    public <S extends Scheduler> S when(@NonNull Function<Flowable<Flowable<Completable>>, Completable> combine) {
        return (S)this.impl.when(combine);
    }

    @SuppressLint(value={"NewApi"})
    public Disposable scheduleDirect(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
        return this.impl.scheduleDirect(run, delay, unit);
    }

    public Disposable schedulePeriodicallyDirect(@NonNull Runnable run, long initialDelay, long period, @NonNull TimeUnit unit) {
        return this.impl.schedulePeriodicallyDirect(run, initialDelay, period, unit);
    }

    public Scheduler.Worker createWorker() {
        return new HandlerImmediateWorker(this.handler, this.impl.createWorker());
    }

    private static final class HandlerImmediateWorker
    extends Scheduler.Worker {
        private final Handler handler;
        private final Scheduler.Worker actual;

        HandlerImmediateWorker(Handler handler, Scheduler.Worker actual) {
            this.handler = handler;
            this.actual = actual;
        }

        public Disposable schedule(@NonNull Runnable run) {
            if (!this.actual.isDisposed() && this.handler.getLooper() == Looper.myLooper()) {
                RxJavaPlugins.onSchedule((Runnable)run).run();
                return Disposables.disposed();
            }
            return this.actual.schedule(run);
        }

        @SuppressLint(value={"NewApi"})
        public Disposable schedule(@NonNull Runnable run, long delay, @NonNull TimeUnit unit) {
            return this.actual.schedule(run, delay, unit);
        }

        public Disposable schedulePeriodically(@NonNull Runnable run, long initialDelay, long period, @NonNull TimeUnit unit) {
            return this.actual.schedulePeriodically(run, initialDelay, period, unit);
        }

        public void dispose() {
            this.actual.dispose();
        }

        public boolean isDisposed() {
            return this.actual.isDisposed();
        }

        public long now(@NonNull TimeUnit unit) {
            return this.actual.now(unit);
        }
    }
}

