/*
 * Decompiled with CFR 0.152.
 */
package com.leaf.library;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.regex.Pattern;

public class StatusBarUtil {
    private static final int DEFAULT_ALPHA = 0;

    public static void setColor(@NonNull Activity activity, @ColorInt int color) {
        StatusBarUtil.setColor(activity, color, 0);
    }

    public static void setColor(@NonNull Activity activity, @ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().clearFlags(0x4000000);
            activity.getWindow().addFlags(Integer.MIN_VALUE);
            activity.getWindow().setStatusBarColor(StatusBarUtil.cipherColor(color, alpha));
        } else if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().addFlags(0x4000000);
            StatusBarUtil.setTranslucentView((ViewGroup)activity.getWindow().getDecorView(), color, alpha);
            StatusBarUtil.setRootView(activity, true);
        }
    }

    public static void setGradientColor(@NonNull Activity activity, View view) {
        ViewGroup decorView = (ViewGroup)activity.getWindow().getDecorView();
        View fakeStatusBarView = decorView.findViewById(16908331);
        if (fakeStatusBarView != null) {
            decorView.removeView(fakeStatusBarView);
        }
        StatusBarUtil.setRootView(activity, false);
        StatusBarUtil.setTransparentForWindow(activity);
        StatusBarUtil.setPaddingTop((Context)activity, view);
    }

    public static void setTransparentForWindow(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 21) {
            activity.getWindow().setStatusBarColor(0);
            activity.getWindow().getDecorView().setSystemUiVisibility(1280);
        } else if (Build.VERSION.SDK_INT >= 19) {
            activity.getWindow().setFlags(0x4000000, 0x4000000);
        }
    }

    public static void setPaddingTop(Context context, @NonNull View view) {
        ViewGroup.LayoutParams lp;
        if (Build.VERSION.SDK_INT >= 19 && (lp = view.getLayoutParams()) != null && lp.height > 0 && view.getPaddingTop() == 0) {
            lp.height += StatusBarUtil.getStatusBarHeight(context);
            view.setPadding(view.getPaddingLeft(), view.getPaddingTop() + StatusBarUtil.getStatusBarHeight(context), view.getPaddingRight(), view.getPaddingBottom());
        }
    }

    public static void setDarkMode(@NonNull Activity activity) {
        StatusBarUtil.darkMode(activity.getWindow(), true);
    }

    public static void setLightMode(@NonNull Activity activity) {
        StatusBarUtil.darkMode(activity.getWindow(), false);
    }

    @TargetApi(value=23)
    private static void darkMode(Window window, boolean dark) {
        if (StatusBarUtil.isFlyme4()) {
            StatusBarUtil.setModeForFlyme4(window, dark);
        } else if (StatusBarUtil.isMIUI6()) {
            StatusBarUtil.setModeForMIUI6(window, dark);
        }
        StatusBarUtil.darkModeForM(window, dark);
    }

    @RequiresApi(value=23)
    private static void darkModeForM(Window window, boolean dark) {
        if (Build.VERSION.SDK_INT >= 23) {
            int systemUiVisibility = window.getDecorView().getSystemUiVisibility();
            systemUiVisibility = dark ? (systemUiVisibility |= 0x2000) : (systemUiVisibility &= 0xFFFFDFFF);
            window.getDecorView().setSystemUiVisibility(systemUiVisibility);
        }
    }

    private static void setModeForMIUI6(Window window, boolean dark) {
        Class<?> clazz = window.getClass();
        try {
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            int darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)window, dark ? darkModeFlag : 0, darkModeFlag);
        }
        catch (Exception e) {
            Log.e((String)"StatusBar", (String)"darkIcon: failed");
        }
    }

    private static void setModeForFlyme4(Window window, boolean dark) {
        try {
            WindowManager.LayoutParams lp = window.getAttributes();
            Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
            Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
            darkFlag.setAccessible(true);
            meizuFlags.setAccessible(true);
            int bit = darkFlag.getInt(null);
            int value = meizuFlags.getInt(lp);
            value = dark ? (value |= bit) : (value &= ~bit);
            meizuFlags.setInt(lp, value);
            window.setAttributes(lp);
        }
        catch (Exception e) {
            Log.e((String)"StatusBar", (String)"darkIcon: failed");
        }
    }

    private static boolean isFlyme4() {
        return Build.FINGERPRINT.contains("Flyme_OS_4") || Build.VERSION.INCREMENTAL.contains("Flyme_OS_4") || Pattern.compile("Flyme OS [4|5]", 2).matcher(Build.DISPLAY).find();
    }

    private static boolean isMIUI6() {
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method mtd = clz.getMethod("get", String.class);
            String val = (String)mtd.invoke(null, "ro.miui.ui.version.name");
            val = val.replaceAll("[vV]", "");
            int version = Integer.parseInt(val);
            return version >= 6;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int cipherColor(@ColorInt int color, int alpha) {
        if (alpha == 0) {
            return color;
        }
        float a = 1.0f - (float)alpha / 255.0f;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        red = (int)((double)((float)red * a) + 0.5);
        green = (int)((double)((float)green * a) + 0.5);
        blue = (int)((double)((float)blue * a) + 0.5);
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    private static void setTranslucentView(ViewGroup viewGroup, @ColorInt int color, @IntRange(from=0L, to=255L) int alpha) {
        if (Build.VERSION.SDK_INT >= 19) {
            int cipherColor = StatusBarUtil.cipherColor(color, alpha);
            View translucentView = viewGroup.findViewById(16908331);
            if (translucentView == null && cipherColor != 0) {
                translucentView = new View(viewGroup.getContext());
                translucentView.setId(16908331);
                ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, StatusBarUtil.getStatusBarHeight(viewGroup.getContext()));
                viewGroup.addView(translucentView, params);
            }
            if (translucentView != null) {
                translucentView.setBackgroundColor(cipherColor);
            }
        }
    }

    private static void setRootView(Activity activity, boolean fitSystemWindows) {
        ViewGroup parent = (ViewGroup)activity.findViewById(0x1020002);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            View childView = parent.getChildAt(i);
            if (!(childView instanceof ViewGroup)) continue;
            childView.setFitsSystemWindows(fitSystemWindows);
            ((ViewGroup)childView).setClipToPadding(fitSystemWindows);
        }
    }

    private static int getStatusBarHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        return context.getResources().getDimensionPixelSize(resourceId);
    }
}

