/*
 * Decompiled with CFR 0.152.
 */
package top.wefor.circularanim;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.support.annotation.DrawableRes;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.widget.ImageView;

public class CircularAnim {
    public static final long PERFECT_MILLS = 618L;
    public static final int MINI_RADIUS = 0;

    public static VisibleBuilder show(View animView) {
        return new VisibleBuilder(animView, true);
    }

    public static VisibleBuilder hide(View animView) {
        return new VisibleBuilder(animView, false);
    }

    public static FullActivityBuilder fullActivity(Activity activity, View triggerView) {
        return new FullActivityBuilder(activity, triggerView);
    }

    @SuppressLint(value={"NewApi"})
    public static class FullActivityBuilder {
        private Activity mActivity;
        private View mTriggerView;
        private float mStartRadius = 0.0f;
        @DrawableRes
        private int mColorOrImageRes = 17170443;
        private Long mDurationMills;
        private OnAnimationEndListener mOnAnimationEndListener;
        private int mEnterAnim = 0x10A0000;
        private int mExitAnim = 0x10A0001;

        public FullActivityBuilder(Activity activity, View triggerView) {
            this.mActivity = activity;
            this.mTriggerView = triggerView;
        }

        public FullActivityBuilder startRadius(float startRadius) {
            this.mStartRadius = startRadius;
            return this;
        }

        public FullActivityBuilder colorOrImageRes(@DrawableRes int colorOrImageRes) {
            this.mColorOrImageRes = colorOrImageRes;
            return this;
        }

        public FullActivityBuilder duration(long durationMills) {
            this.mDurationMills = durationMills;
            return this;
        }

        public FullActivityBuilder overridePendingTransition(int enterAnim, int exitAnim) {
            this.mEnterAnim = enterAnim;
            this.mExitAnim = exitAnim;
            return this;
        }

        public void go(OnAnimationEndListener onAnimationEndListener) {
            this.mOnAnimationEndListener = onAnimationEndListener;
            if (Build.VERSION.SDK_INT < 21) {
                this.doOnEnd();
                return;
            }
            int[] location = new int[2];
            this.mTriggerView.getLocationInWindow(location);
            final int cx = location[0] + this.mTriggerView.getWidth() / 2;
            final int cy = location[1] + this.mTriggerView.getHeight() / 2;
            final ImageView view = new ImageView((Context)this.mActivity);
            view.setScaleType(ImageView.ScaleType.CENTER_CROP);
            view.setImageResource(this.mColorOrImageRes);
            final ViewGroup decorView = (ViewGroup)this.mActivity.getWindow().getDecorView();
            int w = decorView.getWidth();
            int h = decorView.getHeight();
            decorView.addView((View)view, w, h);
            int maxW = Math.max(cx, w - cx);
            int maxH = Math.max(cy, h - cy);
            final int finalRadius = (int)Math.sqrt(maxW * maxW + maxH * maxH) + 1;
            try {
                Animator anim2 = ViewAnimationUtils.createCircularReveal((View)view, (int)cx, (int)cy, (float)this.mStartRadius, (float)finalRadius);
                int maxRadius = (int)Math.sqrt(w * w + h * h) + 1;
                if (this.mDurationMills == null) {
                    double rate = 1.0 * (double)finalRadius / (double)maxRadius;
                    this.mDurationMills = (long)(618.0 * Math.sqrt(rate));
                }
                final long finalDuration = this.mDurationMills;
                anim2.setDuration((long)((double)finalDuration * 0.9));
                anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        FullActivityBuilder.this.doOnEnd();
                        FullActivityBuilder.this.mActivity.overridePendingTransition(FullActivityBuilder.this.mEnterAnim, FullActivityBuilder.this.mExitAnim);
                        FullActivityBuilder.this.mTriggerView.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                if (FullActivityBuilder.this.mActivity.isFinishing()) {
                                    return;
                                }
                                try {
                                    Animator anim2 = ViewAnimationUtils.createCircularReveal((View)view, (int)cx, (int)cy, (float)finalRadius, (float)FullActivityBuilder.this.mStartRadius);
                                    anim2.setDuration(finalDuration);
                                    anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                        public void onAnimationEnd(Animator animation) {
                                            super.onAnimationEnd(animation);
                                            try {
                                                decorView.removeView((View)view);
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    });
                                    anim2.start();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    try {
                                        decorView.removeView((View)view);
                                    }
                                    catch (Exception e1) {
                                        e1.printStackTrace();
                                    }
                                }
                            }
                        }, 1000L);
                    }
                });
                anim2.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.doOnEnd();
            }
        }

        private void doOnEnd() {
            this.mOnAnimationEndListener.onAnimationEnd();
        }
    }

    @SuppressLint(value={"NewApi"})
    public static class VisibleBuilder {
        private View mAnimView;
        private View mTriggerView;
        private Float mStartRadius;
        private Float mEndRadius;
        private long mDurationMills = 618L;
        private boolean isShow;
        private OnAnimationEndListener mOnAnimationEndListener;

        public VisibleBuilder(View animView, boolean isShow) {
            this.mAnimView = animView;
            this.isShow = isShow;
            if (isShow) {
                this.mStartRadius = Float.valueOf(0.0f);
            } else {
                this.mEndRadius = Float.valueOf(0.0f);
            }
        }

        public VisibleBuilder triggerView(View triggerView) {
            this.mTriggerView = triggerView;
            return this;
        }

        public VisibleBuilder startRadius(float startRadius) {
            this.mStartRadius = Float.valueOf(startRadius);
            return this;
        }

        public VisibleBuilder endRadius(float endRadius) {
            this.mEndRadius = Float.valueOf(endRadius);
            return this;
        }

        public VisibleBuilder duration(long durationMills) {
            this.mDurationMills = durationMills;
            return this;
        }

        public VisibleBuilder onAnimationEndListener(OnAnimationEndListener onAnimationEndListener) {
            this.mOnAnimationEndListener = onAnimationEndListener;
            return this;
        }

        public void go() {
            int maxRadius;
            int rippleCY;
            int rippleCX;
            if (Build.VERSION.SDK_INT < 21) {
                this.doOnEnd();
                return;
            }
            if (this.mTriggerView != null) {
                int[] tvLocation = new int[2];
                this.mTriggerView.getLocationInWindow(tvLocation);
                int tvCX = tvLocation[0] + this.mTriggerView.getWidth() / 2;
                int tvCY = tvLocation[1] + this.mTriggerView.getHeight() / 2;
                int[] avLocation = new int[2];
                this.mAnimView.getLocationInWindow(avLocation);
                int avLX = avLocation[0];
                int avTY = avLocation[1];
                int triggerX = Math.max(avLX, tvCX);
                triggerX = Math.min(triggerX, avLX + this.mAnimView.getWidth());
                int triggerY = Math.max(avTY, tvCY);
                triggerY = Math.min(triggerY, avTY + this.mAnimView.getHeight());
                int avW = this.mAnimView.getWidth();
                int avH = this.mAnimView.getHeight();
                rippleCX = triggerX - avLX;
                rippleCY = triggerY - avTY;
                int maxW = Math.max(rippleCX, avW - rippleCX);
                int maxH = Math.max(rippleCY, avH - rippleCY);
                maxRadius = (int)Math.sqrt(maxW * maxW + maxH * maxH) + 1;
            } else {
                rippleCX = (this.mAnimView.getLeft() + this.mAnimView.getRight()) / 2;
                rippleCY = (this.mAnimView.getTop() + this.mAnimView.getBottom()) / 2;
                int w = this.mAnimView.getWidth();
                int h = this.mAnimView.getHeight();
                maxRadius = (int)Math.sqrt(w * w + h * h) + 1;
            }
            if (this.isShow && this.mEndRadius == null) {
                this.mEndRadius = Float.valueOf((float)maxRadius + 0.0f);
            } else if (!this.isShow && this.mStartRadius == null) {
                this.mStartRadius = Float.valueOf((float)maxRadius + 0.0f);
            }
            try {
                Animator anim2 = ViewAnimationUtils.createCircularReveal((View)this.mAnimView, (int)rippleCX, (int)rippleCY, (float)this.mStartRadius.floatValue(), (float)this.mEndRadius.floatValue());
                this.mAnimView.setVisibility(0);
                anim2.setDuration(this.mDurationMills);
                anim2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        VisibleBuilder.this.doOnEnd();
                    }
                });
                anim2.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.doOnEnd();
            }
        }

        private void doOnEnd() {
            if (this.isShow) {
                this.mAnimView.setVisibility(0);
            } else {
                this.mAnimView.setVisibility(4);
            }
            if (this.mOnAnimationEndListener != null) {
                this.mOnAnimationEndListener.onAnimationEnd();
            }
        }
    }

    public static interface OnAnimationEndListener {
        public void onAnimationEnd();
    }
}

