/*
 * Decompiled with CFR 0.152.
 */
package xdean.jex.log;

import xdean.jex.log.Log;
import xdean.jex.log.impl.JulLog;
import xdean.jex.log.impl.Log4jLog;
import xdean.jex.log.impl.NoLog;
import xdean.jex.log.impl.Slf4jLog;

public enum LogFactory {

    private static final LogImpl LOG_IMPL;

    public static Log from(Object o) {
        return LogFactory.from(o.getClass());
    }

    public static Log from(Class<?> clz) {
        return LogFactory.from(clz.getName());
    }

    public static Log from(String name) {
        if (LOG_IMPL == LogImpl.SLF4J) {
            return new Slf4jLog(name);
        }
        if (LOG_IMPL == LogImpl.LOG4J) {
            return new Log4jLog(name);
        }
        if (LOG_IMPL == LogImpl.JUL) {
            return new JulLog(name);
        }
        return new NoLog();
    }

    static {
        ClassLoader cl = LogFactory.class.getClassLoader();
        LogImpl impl = LogImpl.JUL;
        try {
            cl.loadClass("org.slf4j.Logger");
            impl = LogImpl.SLF4J;
        }
        catch (ClassNotFoundException e) {
            try {
                cl.loadClass("org.apache.logging.log4j.spi.ExtendedLogger");
                impl = LogImpl.LOG4J;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        LOG_IMPL = impl;
    }

    public static enum LogImpl {
        SLF4J,
        LOG4J,
        JUL;

    }
}

