/*
 * Decompiled with CFR 0.152.
 */
package pyxis.uzuki.live.richutilskt.service;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Binder;
import android.os.Bundle;
import android.util.Log;
import android.view.WindowManager;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pyxis.uzuki.live.richutilskt.impl.F1;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001:\u0004;<=>B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001b\u001a\u00020\u001cJ\u001a\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001c\u0010 \u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010#\u001a\u0004\u0018\u00010\"H\u0002J\u0016\u0010$\u001a\u00060\u0015R\u00020\u00002\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020\u001cH\u0016J\b\u0010(\u001a\u00020\u001cH\u0016J\"\u0010)\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0016J\b\u0010,\u001a\u00020\u001cH\u0002J\u001a\u0010-\u001a\u00020\u001c2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u001c0/J\u0014\u0010-\u001a\u00020\u001c2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\r00J\u0006\u00101\u001a\u00020\u001cJ\n\u00102\u001a\u00020\"*\u000203J\n\u00104\u001a\u00020\"*\u000203J\u000e\u00105\u001a\u0004\u0018\u000106*\u000203H\u0002J\u0012\u00107\u001a\n\u0012\u0004\u0012\u000206\u0018\u000108*\u000203J\n\u00109\u001a\u00020\"*\u000203J\n\u0010:\u001a\u00020\"*\u000203R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00060\u0015R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0018\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0019\u001a\u00060\u001aR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lpyxis/uzuki/live/richutilskt/service/RLocationService;", "Landroid/app/Service;", "()V", "FASTEST_INTERVAL_IN_MS", "", "MIN_BEARING_DIFF", "", "TWO_MINUTES", "", "axisX", "axisY", "bearing", "currentBestLocation", "Landroid/location/Location;", "getCurrentBestLocation", "()Landroid/location/Location;", "setCurrentBestLocation", "(Landroid/location/Location;)V", "gpsLocationListener", "Lpyxis/uzuki/live/richutilskt/service/RLocationService$LocationChangeListener;", "localBinder", "Lpyxis/uzuki/live/richutilskt/service/RLocationService$LocalBinder;", "locationCallback", "Lpyxis/uzuki/live/richutilskt/service/RLocationService$LocationCallback;", "networkLocationListener", "sensorEventListener", "Lpyxis/uzuki/live/richutilskt/service/RLocationService$SensorListener;", "getLocation", "", "isBetterLocation", "", "location", "isSameProvider", "provider1", "", "provider2", "onBind", "intent", "Landroid/content/Intent;", "onCreate", "onDestroy", "onStartCommand", "flags", "startId", "readDisplayRotation", "setLocationCallback", "callback", "Lkotlin/Function1;", "Lpyxis/uzuki/live/richutilskt/impl/F1;", "stopUpdates", "getAddressLine", "Landroid/content/Context;", "getCountryName", "getFirstAddress", "Landroid/location/Address;", "getGeoCoderAddress", "", "getLocality", "getPostalCode", "LocalBinder", "LocationCallback", "LocationChangeListener", "SensorListener", "RichUtils_release"})
@SuppressLint(value={"MissingPermission"})
public final class RLocationService
extends Service {
    private final LocationChangeListener gpsLocationListener = new LocationChangeListener();
    private final LocationChangeListener networkLocationListener = new LocationChangeListener();
    private final SensorListener sensorEventListener = new SensorListener();
    private final LocalBinder localBinder = new LocalBinder();
    private final int TWO_MINUTES = 120000;
    private final float MIN_BEARING_DIFF = 2.0f;
    private final long FASTEST_INTERVAL_IN_MS = 1000L;
    private float bearing;
    private int axisX;
    private int axisY;
    @Nullable
    private Location currentBestLocation;
    private LocationCallback locationCallback;

    @Nullable
    public final Location getCurrentBestLocation() {
        return this.currentBestLocation;
    }

    public final void setCurrentBestLocation(@Nullable Location location) {
        this.currentBestLocation = location;
    }

    @NotNull
    public LocalBinder onBind(@Nullable Intent intent) {
        return this.localBinder;
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        super.onStartCommand(intent, flags, startId);
        return 1;
    }

    public void onCreate() {
        super.onCreate();
        this.getLocation();
    }

    public void onDestroy() {
        super.onDestroy();
        this.stopUpdates();
        RLocationService $receiver$iv = this;
        Object object = $receiver$iv.getSystemService("sensor");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        ((SensorManager)object).unregisterListener((SensorEventListener)this.sensorEventListener);
    }

    public final void getLocation() {
        RLocationService $receiver$iv = this;
        Object object = $receiver$iv.getSystemService("location");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        Location lastKnownGpsLocation = ((LocationManager)object).getLastKnownLocation("gps");
        RLocationService $receiver$iv2 = this;
        Object object2 = $receiver$iv2.getSystemService("location");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        Location lastKnownNetworkLocation = ((LocationManager)object2).getLastKnownLocation("network");
        Location bestLastKnownLocation = this.currentBestLocation;
        if (lastKnownGpsLocation != null && this.isBetterLocation(lastKnownGpsLocation, bestLastKnownLocation)) {
            bestLastKnownLocation = lastKnownGpsLocation;
        }
        if (lastKnownNetworkLocation != null && this.isBetterLocation(lastKnownNetworkLocation, bestLastKnownLocation)) {
            bestLastKnownLocation = lastKnownNetworkLocation;
        }
        this.currentBestLocation = bestLastKnownLocation;
        RLocationService $receiver$iv3 = this;
        Object object3 = $receiver$iv3.getSystemService("location");
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        if (((LocationManager)object3).getAllProviders().contains("gps")) {
            $receiver$iv3 = this;
            Object object4 = $receiver$iv3.getSystemService("location");
            if (object4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
            }
            if (((LocationManager)object4).isProviderEnabled("gps")) {
                $receiver$iv3 = this;
                Object object5 = $receiver$iv3.getSystemService("location");
                if (object5 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
                }
                ((LocationManager)object5).requestLocationUpdates("gps", this.FASTEST_INTERVAL_IN_MS, 0.0f, (LocationListener)this.gpsLocationListener);
            }
        }
        $receiver$iv3 = this;
        Object object6 = $receiver$iv3.getSystemService("location");
        if (object6 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        if (((LocationManager)object6).getAllProviders().contains("network")) {
            $receiver$iv3 = this;
            Object object7 = $receiver$iv3.getSystemService("location");
            if (object7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
            }
            if (((LocationManager)object7).isProviderEnabled("network")) {
                $receiver$iv3 = this;
                Object object8 = $receiver$iv3.getSystemService("location");
                if (object8 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
                }
                ((LocationManager)object8).requestLocationUpdates("network", this.FASTEST_INTERVAL_IN_MS, 0.0f, (LocationListener)this.networkLocationListener);
            }
        }
        Location location = bestLastKnownLocation;
        if (location != null) {
            location.setBearing(this.bearing);
        }
        LocationCallback locationCallback = this.locationCallback;
        if (locationCallback != null) {
            Location location2 = this.currentBestLocation;
            if (location2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.location.Location");
            }
            locationCallback.handleNewLocation(location2);
        }
        RLocationService $receiver$iv4 = this;
        Object object9 = $receiver$iv4.getSystemService("sensor");
        if (object9 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        Sensor mSensor = ((SensorManager)object9).getDefaultSensor(11);
        $receiver$iv4 = this;
        Object object10 = $receiver$iv4.getSystemService("sensor");
        if (object10 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        ((SensorManager)object10).registerListener((SensorEventListener)this.sensorEventListener, mSensor, 15);
    }

    public final void setLocationCallback(@NotNull Function1<? super Location, Unit> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.locationCallback = new LocationCallback(callback){
            final /* synthetic */ Function1 $callback;

            public void invoke(@NotNull Location location) {
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                this.$callback.invoke((Object)location);
            }

            public void handleNewLocation(@NotNull Location location) {
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                this.$callback.invoke((Object)location);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        };
    }

    public final void setLocationCallback(@NotNull F1<Location> callback) {
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.locationCallback = new LocationCallback(callback){
            final /* synthetic */ F1 $callback;

            public void invoke(@NotNull Location location) {
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                this.$callback.invoke(location);
            }

            public void handleNewLocation(@NotNull Location location) {
                Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
                this.$callback.invoke(location);
            }
            {
                this.$callback = $captured_local_variable$0;
            }
        };
    }

    public final void stopUpdates() {
        RLocationService $receiver$iv = this;
        Object object = $receiver$iv.getSystemService("location");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        ((LocationManager)object).removeUpdates((LocationListener)this.gpsLocationListener);
        $receiver$iv = this;
        Object object2 = $receiver$iv.getSystemService("location");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.location.LocationManager");
        }
        ((LocationManager)object2).removeUpdates((LocationListener)this.networkLocationListener);
        $receiver$iv = this;
        Object object3 = $receiver$iv.getSystemService("sensor");
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.hardware.SensorManager");
        }
        ((SensorManager)object3).unregisterListener((SensorEventListener)this.sensorEventListener);
    }

    @Nullable
    public final List<Address> getGeoCoderAddress(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Geocoder geoCoder = new Geocoder($receiver, Locale.ENGLISH);
        try {
            Location location = this.currentBestLocation;
            Location location2 = this.currentBestLocation;
            return geoCoder.getFromLocation(location != null ? location.getLatitude() : 0.0, location2 != null ? location2.getLongitude() : 0.0, 1);
        }
        catch (IOException e) {
            Log.e((String)RLocationService.class.getSimpleName(), (String)"Impossible to connect to Geocoder", (Throwable)e);
            return null;
        }
    }

    private final Address getFirstAddress(@NotNull Context $receiver) {
        Collection collection;
        List<Address> addresses = this.getGeoCoderAddress($receiver);
        if (addresses != null && !(collection = (Collection)addresses).isEmpty()) {
            return addresses.get(0);
        }
        return null;
    }

    @NotNull
    public final String getAddressLine(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = this.getFirstAddress($receiver);
        if (object == null || (object = object.getAddressLine(0)) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getLocality(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = this.getFirstAddress($receiver);
        if (object == null || (object = object.getLocality()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getPostalCode(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = this.getFirstAddress($receiver);
        if (object == null || (object = object.getPostalCode()) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public final String getCountryName(@NotNull Context $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = this.getFirstAddress($receiver);
        if (object == null || (object = object.getCountryName()) == null) {
            object = "";
        }
        return object;
    }

    private final boolean isBetterLocation(Location location, Location currentBestLocation) {
        boolean isNewer;
        if (currentBestLocation == null) {
            return true;
        }
        long timeDelta = location.getTime() - currentBestLocation.getTime();
        boolean isSignificantlyNewer = timeDelta > (long)this.TWO_MINUTES;
        boolean isSignificantlyOlder = timeDelta < (long)(-this.TWO_MINUTES);
        boolean bl = isNewer = timeDelta > 0L;
        if (isSignificantlyNewer) {
            return true;
        }
        if (isSignificantlyOlder) {
            return false;
        }
        int accuracyDelta = (int)(location.getAccuracy() - currentBestLocation.getAccuracy());
        boolean isLessAccurate = accuracyDelta > 0;
        boolean isMoreAccurate = accuracyDelta < 0;
        boolean isSignificantlyLessAccurate = accuracyDelta > 200;
        boolean isFromSameProvider = this.isSameProvider(location.getProvider(), currentBestLocation.getProvider());
        if (isMoreAccurate) {
            return true;
        }
        if (isNewer && !isLessAccurate) {
            return true;
        }
        return isNewer && !isSignificantlyLessAccurate && isFromSameProvider;
    }

    private final boolean isSameProvider(String provider1, String provider2) {
        return provider1 == null ? provider2 == null : Intrinsics.areEqual((Object)provider1, (Object)provider2);
    }

    private final void readDisplayRotation() {
        this.axisX = 1;
        this.axisY = 2;
        RLocationService $receiver$iv = this;
        Object object = $receiver$iv.getSystemService("window");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.WindowManager");
        }
        switch (((WindowManager)object).getDefaultDisplay().getRotation()) {
            case 1: {
                this.axisX = 2;
                this.axisY = 129;
                break;
            }
            case 2: {
                this.axisY = 130;
                break;
            }
            case 3: {
                this.axisX = 130;
                this.axisY = 1;
            }
        }
    }

    public static final /* synthetic */ void access$setLocationCallback$p(RLocationService $this, @Nullable LocationCallback locationCallback) {
        $this.locationCallback = locationCallback;
    }

    public static final /* synthetic */ void access$setAxisX$p(RLocationService $this, int n) {
        $this.axisX = n;
    }

    public static final /* synthetic */ void access$setAxisY$p(RLocationService $this, int n) {
        $this.axisY = n;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0012\u0010\n\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J$\u0010\u000b\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lpyxis/uzuki/live/richutilskt/service/RLocationService$LocationChangeListener;", "Landroid/location/LocationListener;", "(Lpyxis/uzuki/live/richutilskt/service/RLocationService;)V", "onLocationChanged", "", "location", "Landroid/location/Location;", "onProviderDisabled", "provider", "", "onProviderEnabled", "onStatusChanged", "status", "", "extras", "Landroid/os/Bundle;", "RichUtils_release"})
    private final class LocationChangeListener
    implements LocationListener {
        public void onLocationChanged(@Nullable Location location) {
            block4: {
                if (location == null) {
                    return;
                }
                if (!RLocationService.this.isBetterLocation(location, RLocationService.this.getCurrentBestLocation())) break block4;
                RLocationService.this.setCurrentBestLocation(location);
                Location location2 = RLocationService.this.getCurrentBestLocation();
                if (location2 != null) {
                    location2.setBearing(RLocationService.this.bearing);
                }
                LocationCallback locationCallback = RLocationService.this.locationCallback;
                if (locationCallback != null) {
                    Location location3 = RLocationService.this.getCurrentBestLocation();
                    if (location3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.location.Location");
                    }
                    locationCallback.handleNewLocation(location3);
                }
            }
        }

        public void onProviderDisabled(@Nullable String provider) {
        }

        public void onProviderEnabled(@Nullable String provider) {
        }

        public void onStatusChanged(@Nullable String provider, int status, @Nullable Bundle extras) {
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lpyxis/uzuki/live/richutilskt/service/RLocationService$SensorListener;", "Landroid/hardware/SensorEventListener;", "(Lpyxis/uzuki/live/richutilskt/service/RLocationService;)V", "onAccuracyChanged", "", "sensor", "Landroid/hardware/Sensor;", "accuracy", "", "onSensorChanged", "event", "Landroid/hardware/SensorEvent;", "RichUtils_release"})
    private final class SensorListener
    implements SensorEventListener {
        public void onAccuracyChanged(@Nullable Sensor sensor, int accuracy) {
            Sensor sensor2 = sensor;
            if (sensor2 != null) {
                if (sensor2.getType() == 11) {
                    Log.i((String)RLocationService.class.getSimpleName(), (String)("Rotation sensor accuracy changed to: " + accuracy));
                }
            }
        }

        public void onSensorChanged(@Nullable SensorEvent event) {
            block1: {
                boolean abs;
                double azimuth;
                float[] rotationMatrix = new float[16];
                SensorEvent sensorEvent = event;
                SensorManager.getRotationMatrixFromVector((float[])rotationMatrix, (float[])((float[])(sensorEvent != null ? sensorEvent.values : null)));
                float[] orientationValues = new float[3];
                RLocationService.this.readDisplayRotation();
                SensorManager.remapCoordinateSystem((float[])rotationMatrix, (int)RLocationService.this.axisX, (int)RLocationService.this.axisY, (float[])rotationMatrix);
                SensorManager.getOrientation((float[])rotationMatrix, (float[])orientationValues);
                double newBearing = azimuth = Math.toDegrees(orientationValues[0]);
                boolean bl = abs = Math.abs((float)((double)RLocationService.this.bearing - newBearing)) > RLocationService.this.MIN_BEARING_DIFF;
                if (!abs) break block1;
                RLocationService.this.bearing = (float)newBearing;
                Location location = RLocationService.this.getCurrentBestLocation();
                if (location != null) {
                    location.setBearing(RLocationService.this.bearing);
                }
            }
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lpyxis/uzuki/live/richutilskt/service/RLocationService$LocalBinder;", "Landroid/os/Binder;", "(Lpyxis/uzuki/live/richutilskt/service/RLocationService;)V", "service", "Lpyxis/uzuki/live/richutilskt/service/RLocationService;", "getService", "()Lpyxis/uzuki/live/richutilskt/service/RLocationService;", "RichUtils_release"})
    public final class LocalBinder
    extends Binder {
        @NotNull
        public final RLocationService getService() {
            return RLocationService.this;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lpyxis/uzuki/live/richutilskt/service/RLocationService$LocationCallback;", "", "handleNewLocation", "", "location", "Landroid/location/Location;", "RichUtils_release"})
    public static interface LocationCallback {
        public void handleNewLocation(@NotNull Location var1);
    }
}

