/*
 * Decompiled with CFR 0.152.
 */
package convalida.validators.util;

import android.support.design.widget.TextInputLayout;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.ViewParent;
import android.widget.EditText;
import convalida.validators.util.ExecuteValidationListener;

public final class EditTextUtils {
    private static TextInputLayout getTextInputLayout(EditText editText) {
        ViewParent parent = editText.getParent();
        while (parent instanceof View) {
            if (parent instanceof TextInputLayout) {
                return (TextInputLayout)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public static void setError(EditText editText, String errorMessage) {
        TextInputLayout layout = EditTextUtils.getTextInputLayout(editText);
        if (layout != null) {
            layout.setErrorEnabled(errorMessage != null);
            layout.setError((CharSequence)errorMessage);
        } else {
            editText.setError((CharSequence)errorMessage);
        }
    }

    public static void addOnTextChangedListener(EditText editText, final ExecuteValidationListener listener) {
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                listener.execute(s.toString());
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    public static boolean isVisible(EditText editText) {
        return editText.getVisibility() == 8 || editText.getVisibility() == 4;
    }
}

