/*
 * Decompiled with CFR 0.152.
 */
package convalida.validators;

import android.widget.EditText;
import convalida.validators.AbstractValidator;
import java.util.regex.Pattern;

public class PasswordValidator
extends AbstractValidator {
    private int min;
    private String pattern;

    public PasswordValidator(EditText editText, int min, String pattern, String errorMessage, boolean autoDismiss) {
        super(editText, errorMessage, autoDismiss);
        this.min = min;
        this.pattern = pattern;
    }

    @Override
    public boolean isValid(String value) {
        boolean hasError = value.isEmpty();
        if (this.min > 0) {
            hasError |= value.length() < this.min;
        }
        if (!this.pattern.isEmpty()) {
            hasError |= !Pattern.matches(this.pattern, value);
        }
        return !hasError;
    }
}

