/*
 * Decompiled with CFR 0.152.
 */
package convalida.validators;

import android.widget.EditText;
import convalida.validators.AbstractValidator;

public class CpfValidator
extends AbstractValidator {
    private boolean required;

    public CpfValidator(EditText editText, String errorMessage, boolean autoDismiss, boolean required) {
        super(editText, errorMessage, autoDismiss);
        this.required = required;
    }

    @Override
    public boolean isValid(String value) {
        boolean invalidLength;
        boolean bl = invalidLength = (value = value.replace(".", "").replace("-", "").replace(" ", "")).length() > 0 && value.length() < 11;
        if (this.required && value.isEmpty()) {
            return false;
        }
        if (value.isEmpty()) {
            return true;
        }
        if (invalidLength) {
            return false;
        }
        boolean hasOnlyDigits = value.matches("\\d{11}");
        boolean isNotInBlackList = !CpfValidator.inBlackList(value);
        int charAt9Position = Character.getNumericValue(value.charAt(9));
        int charAt10Position = Character.getNumericValue(value.charAt(10));
        boolean digit9IsValid = CpfValidator.cpfDv(value, 1) == charAt9Position;
        boolean digit10IsValid = CpfValidator.cpfDv(value, 2) == charAt10Position;
        return hasOnlyDigits && isNotInBlackList && digit9IsValid && digit10IsValid;
    }

    private static int cpfDv(String cpf, int step) {
        int dv = 11 - CpfValidator.cpfSum(cpf, step) % 11;
        return dv == 10 || dv == 11 ? 0 : dv;
    }

    private static int cpfSum(String rawCPF, int step) {
        int sum = 0;
        int count = 8 + step;
        int baseMultiplier = 9 + step;
        for (int i = 0; i < count; ++i) {
            sum += (baseMultiplier - i) * Character.getNumericValue(rawCPF.charAt(i));
        }
        return sum;
    }

    private static boolean inBlackList(String cpf) {
        boolean equal = true;
        for (int i = 1; i < 11 && equal; ++i) {
            if (cpf.charAt(i) == cpf.charAt(0)) continue;
            equal = false;
        }
        return equal || cpf.equals("12345678909");
    }
}

